/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.EditableResourceRequirements;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.ResourceRequirementsFluent;
import io.dekorate.kubernetes.config.ResourceRequirementsFluentImpl;
import java.util.Objects;

public class ResourceRequirementsBuilder
extends ResourceRequirementsFluentImpl<ResourceRequirementsBuilder>
implements VisitableBuilder<ResourceRequirements, ResourceRequirementsBuilder> {
    ResourceRequirementsFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceRequirementsBuilder() {
        this(true);
    }

    public ResourceRequirementsBuilder(Boolean validationEnabled) {
        this(new ResourceRequirements(), validationEnabled);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceRequirements(), validationEnabled);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, ResourceRequirements instance) {
        this(fluent, instance, true);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, ResourceRequirements instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMemory(instance.getMemory());
        fluent.withCpu(instance.getCpu());
        this.validationEnabled = validationEnabled;
    }

    public ResourceRequirementsBuilder(ResourceRequirements instance) {
        this(instance, (Boolean)true);
    }

    public ResourceRequirementsBuilder(ResourceRequirements instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMemory(instance.getMemory());
        this.withCpu(instance.getCpu());
        this.validationEnabled = validationEnabled;
    }

    public EditableResourceRequirements build() {
        EditableResourceRequirements buildable = new EditableResourceRequirements(this.fluent.getMemory(), this.fluent.getCpu());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceRequirementsBuilder that = (ResourceRequirementsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

