/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.configurator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.ImageConfigurationFluent;

@Description(value="Apply build related info to image configuration.")
public class ApplyBuildToImageConfiguration
extends Configurator<ImageConfigurationFluent> {
    private static final String DEKORATE_BUILD = "dekorate.build";
    private static final String DEKORATE_PUSH = "dekorate.push";
    private static final String DEKORATE_DOCKER_REGISTRY = "dekorate.docker.registry";

    public void visit(ImageConfigurationFluent config) {
        String registry = System.getProperty(DEKORATE_DOCKER_REGISTRY, config.getRegistry());
        config.withAutoBuildEnabled(Boolean.parseBoolean(System.getProperty(DEKORATE_BUILD, String.valueOf(config.isAutoBuildEnabled())))).withAutoPushEnabled(Boolean.parseBoolean(System.getProperty(DEKORATE_PUSH, String.valueOf(config.isAutoPushEnabled())))).withRegistry(registry);
    }
}

