/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.model.Container;
import io.dekorate.deps.kubernetes.api.model.ContainerBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.PodSpecBuilder;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.adapter.ContainerAdapter;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Predicates;

@Description(value="A decorator that adds a the container if no matching container found")
public class ApplyApplicationContainerDecorator
extends NamedResourceDecorator<PodSpecBuilder> {
    private final io.dekorate.kubernetes.config.Container container;

    public ApplyApplicationContainerDecorator(io.dekorate.kubernetes.config.Container container) {
        this(ANY, container);
    }

    public ApplyApplicationContainerDecorator(String deployment, io.dekorate.kubernetes.config.Container container) {
        super(deployment);
        this.container = container;
    }

    @Override
    public void andThenVisit(PodSpecBuilder podSpec, ObjectMeta resourceMeta) {
        Predicate p = Predicates.builderMatches((io.dekorate.kubernetes.config.Container)this.container);
        if (!podSpec.hasMatchingContainer(p).booleanValue()) {
            podSpec.addToContainers(new Container[]{ContainerAdapter.adapt(this.container)});
        } else {
            ContainerBuilder builder = new ContainerBuilder(podSpec.buildMatchingContainer(p));
            podSpec.removeMatchingFromContainers(p);
            ContainerAdapter.applyContainerToBuilder(builder, this.container);
            podSpec.addToContainers(new Container[]{builder.build()});
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }
}

