/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;

@Description(value="Apply the number of replicas to the DeploymentSpec.")
public class ApplyReplicasDecorator
extends NamedResourceDecorator<DeploymentSpecFluent> {
    private final int replicas;

    public ApplyReplicasDecorator(int replicas) {
        this(ANY, replicas);
    }

    public ApplyReplicasDecorator(String deploymentName, int replicas) {
        super(deploymentName);
        this.replicas = replicas;
    }

    public void andThenVisit(DeploymentSpecFluent deploymentSpec, ObjectMeta resourceMeta) {
        if (this.replicas > 0) {
            deploymentSpec.withReplicas(Integer.valueOf(this.replicas));
        }
    }
}

