/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.Ingress;
import io.dekorate.kubernetes.config.IngressRule;
import io.dekorate.kubernetes.config.IngressRuleBuilder;
import io.dekorate.kubernetes.config.IngressRuleFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressFluent<A extends IngressFluent<A>>
extends BaseFluent<A> {
    private String host;
    private String ingressClassName;
    private String targetPort;
    private Boolean expose;
    private String tlsSecretName;
    private List<String> tlsHosts = new ArrayList<String>();
    private ArrayList<IngressRuleBuilder> rules = new ArrayList();

    public IngressFluent() {
    }

    public IngressFluent(Ingress instance) {
        Ingress ingress = instance = instance != null ? instance : new Ingress();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withIngressClassName(instance.getIngressClassName());
            this.withTargetPort(instance.getTargetPort());
            this.withExpose(instance.getExpose());
            this.withTlsSecretName(instance.getTlsSecretName());
            this.withTlsHosts(instance.getTlsHosts());
            this.withRules(instance.getRules());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public A withIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return (A)((Object)this);
    }

    public boolean hasIngressClassName() {
        return this.ingressClassName != null;
    }

    public String getTargetPort() {
        return this.targetPort;
    }

    public A withTargetPort(String targetPort) {
        this.targetPort = targetPort;
        return (A)((Object)this);
    }

    public boolean hasTargetPort() {
        return this.targetPort != null;
    }

    public Boolean getExpose() {
        return this.expose;
    }

    public A withExpose(Boolean expose) {
        this.expose = expose;
        return (A)((Object)this);
    }

    public boolean hasExpose() {
        return this.expose != null;
    }

    public String getTlsSecretName() {
        return this.tlsSecretName;
    }

    public A withTlsSecretName(String tlsSecretName) {
        this.tlsSecretName = tlsSecretName;
        return (A)((Object)this);
    }

    public boolean hasTlsSecretName() {
        return this.tlsSecretName != null;
    }

    public A withTlsHosts(String ... tlsHosts) {
        if (this.tlsHosts != null) {
            this.tlsHosts.clear();
            this._visitables.remove((Object)"tlsHosts");
        }
        if (tlsHosts != null) {
            for (String item : tlsHosts) {
                this.addToTlsHosts(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getTlsHosts() {
        int size = this.tlsHosts != null ? this.tlsHosts.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.tlsHosts) {
            result[index++] = item;
        }
        return result;
    }

    public A addToTlsHosts(int index, String item) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        this.tlsHosts.add(index, item);
        return (A)((Object)this);
    }

    public A setToTlsHosts(int index, String item) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        this.tlsHosts.set(index, item);
        return (A)((Object)this);
    }

    public A addToTlsHosts(String ... items) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.tlsHosts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTlsHosts(Collection<String> items) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.tlsHosts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTlsHosts(String ... items) {
        if (this.tlsHosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tlsHosts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTlsHosts(Collection<String> items) {
        if (this.tlsHosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tlsHosts.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsHosts() {
        return this.tlsHosts != null && !this.tlsHosts.isEmpty();
    }

    public A withRules(IngressRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove((Object)"rules");
        }
        if (rules != null) {
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)((Object)this);
    }

    public IngressRule[] buildRules() {
        int size = this.rules != null ? this.rules.size() : 0;
        IngressRule[] result = new IngressRule[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.rules) {
            result[index++] = (IngressRule)visitableBuilder.build();
        }
        return result;
    }

    public IngressRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public IngressRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public IngressRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public IngressRule buildMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToRules(int index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRules(int index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRules(IngressRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRules(Collection<IngressRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRules(IngressRule ... items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRules(Collection<IngressRule> items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRules(Predicate<IngressRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        Iterator<IngressRuleBuilder> each = this.rules.iterator();
        List visitables = this._visitables.get((Object)"rules");
        while (each.hasNext()) {
            IngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(IngressRule item) {
        return new RulesNested(-1, item);
    }

    public RulesNested<A> setNewRuleLike(int index, IngressRule item) {
        return new RulesNested(index, item);
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressFluent that = (IngressFluent)((Object)o);
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.ingressClassName, that.ingressClassName)) {
            return false;
        }
        if (!Objects.equals(this.targetPort, that.targetPort)) {
            return false;
        }
        if (!Objects.equals(this.expose, that.expose)) {
            return false;
        }
        if (!Objects.equals(this.tlsSecretName, that.tlsSecretName)) {
            return false;
        }
        if (!Objects.equals(this.tlsHosts, that.tlsHosts)) {
            return false;
        }
        return Objects.equals(this.rules, that.rules);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.ingressClassName, this.targetPort, this.expose, this.tlsSecretName, this.tlsHosts, this.rules, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.ingressClassName != null) {
            sb.append("ingressClassName:");
            sb.append(this.ingressClassName + ",");
        }
        if (this.targetPort != null) {
            sb.append("targetPort:");
            sb.append(this.targetPort + ",");
        }
        if (this.expose != null) {
            sb.append("expose:");
            sb.append(this.expose + ",");
        }
        if (this.tlsSecretName != null) {
            sb.append("tlsSecretName:");
            sb.append(this.tlsSecretName + ",");
        }
        if (this.tlsHosts != null && !this.tlsHosts.isEmpty()) {
            sb.append("tlsHosts:");
            sb.append(this.tlsHosts + ",");
        }
        if (this.rules != null) {
            sb.append("rules:");
            sb.append(this.rules);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withExpose() {
        return this.withExpose(true);
    }

    public class RulesNested<N>
    extends IngressRuleFluent<RulesNested<N>>
    implements Nested<N> {
        IngressRuleBuilder builder;
        int index;

        RulesNested(int index, IngressRule item) {
            this.index = index;
            this.builder = new IngressRuleBuilder(this, item);
        }

        public N and() {
            return (N)IngressFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }
}

