/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyImageDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.utils.Images;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ContainerFluent;

public class ApplyRegistryToImageDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>> {
    private final String registry;
    private final boolean replaceExisting;

    public ApplyRegistryToImageDecorator(String resourceName, String containerName, String registry, boolean replaceExisitng) {
        super(resourceName, containerName);
        this.registry = registry;
        this.replaceExisting = replaceExisitng;
    }

    public ApplyRegistryToImageDecorator(String resourceName, String containerName, String registry) {
        this(resourceName, containerName, registry, true);
    }

    public ApplyRegistryToImageDecorator(String containerName, String registry) {
        this(ANY, containerName, registry);
    }

    public ApplyRegistryToImageDecorator(String registry) {
        this(ANY, ANY, registry);
    }

    @Override
    public void andThenVisit(ContainerFluent<?> container) {
        String image = container.getImage();
        String existingRegistry = Images.getRegistry((String)image);
        String repository = Images.getRepository((String)image);
        String tag = Images.getTag((String)image);
        if (this.replaceExisting || Strings.isNullOrEmpty((String)existingRegistry)) {
            container.withImage(Images.getImage((String)this.registry, (String)repository, (String)tag));
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ApplyImageDecorator.class, AddInitContainerDecorator.class};
    }
}

