/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.config.Ingress;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLS;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLSBuilder;

public class AddIngressTlsDecorator
extends NamedResourceDecorator<IngressSpecBuilder> {
    private final Ingress ingress;

    public AddIngressTlsDecorator(String name, Ingress ingress) {
        super(name);
        this.ingress = ingress;
    }

    public void andThenVisit(IngressSpecBuilder spec, ObjectMeta meta) {
        IngressTLSBuilder builder = (IngressTLSBuilder)new IngressTLSBuilder().withSecretName(this.ingress.getTlsSecretName());
        if (this.ingress.getTlsHosts() != null && this.ingress.getTlsHosts().length > 0) {
            builder.withHosts(this.ingress.getTlsHosts());
        }
        spec.addToTls(new IngressTLS[]{builder.build()});
    }
}

