/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging$class;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.util.HashMap;
import java.util.Locale;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.delta.DeltaConfig;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.metering.DeltaLogging$class;
import org.apache.spark.sql.delta.util.DeltaProgressReporter$class;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class DeltaConfigs$
implements DeltaLogging {
    public static final DeltaConfigs$ MODULE$;
    private final String sqlConfPrefix;
    private final HashMap<String, DeltaConfig<?>> org$apache$spark$sql$delta$DeltaConfigs$$entries;
    private final DeltaConfig<CalendarInterval> LOG_RETENTION;
    private final DeltaConfig<CalendarInterval> SAMPLE_RETENTION;
    private final DeltaConfig<CalendarInterval> CHECKPOINT_RETENTION_DURATION;
    private final DeltaConfig<Object> CHECKPOINT_INTERVAL;
    private final DeltaConfig<Object> ENABLE_EXPIRED_LOG_CLEANUP;
    private final DeltaConfig<Object> ENABLE_FULL_RETENTION_ROLLBACK;
    private final DeltaConfig<CalendarInterval> TOMBSTONE_RETENTION;
    private final DeltaConfig<Object> RANDOMIZE_FILE_PREFIXES;
    private final DeltaConfig<Object> RANDOM_PREFIX_LENGTH;
    private final DeltaConfig<Object> IS_APPEND_ONLY;
    private final DeltaConfig<Object> AUTO_OPTIMIZE;
    private final DeltaConfig<Object> DATA_SKIPPING_NUM_INDEXED_COLS;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaConfigs$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging$class.recordDeltaEvent(this, deltaLog, opType, tags, data);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging$class.recordDeltaOperation(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging$class.recordDeltaOperation$default$3(this);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging$class.recordDeltaEvent$default$3(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging$class.recordDeltaEvent$default$4(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging$class.logConsole(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging$class.recordUsage(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging$class.recordEvent(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging$class.recordOperation(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging$class.recordUsage$default$3(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging$class.recordUsage$default$4(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging$class.recordUsage$default$5(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging$class.recordUsage$default$6(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging$class.recordUsage$default$7(this);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging$class.recordEvent$default$2(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging$class.recordEvent$default$3(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging$class.recordEvent$default$4(this);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging$class.recordOperation$default$2(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging$class.recordOperation$default$4(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging$class.recordOperation$default$5(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging$class.recordOperation$default$6(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging$class.recordOperation$default$7(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging$class.recordOperation$default$8(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging$class.recordOperation$default$9(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter$class.withStatusCode(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter$class.withStatusCode$default$3(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public CalendarInterval parseCalendarInterval(String s) {
        if (s == null || s.trim().isEmpty()) {
            throw new IllegalArgumentException("Interval cannot be null or blank.");
        }
        String sInLowerCase = s.trim().toLowerCase(Locale.ROOT);
        String interval = sInLowerCase.startsWith("interval ") ? sInLowerCase : new StringBuilder().append((Object)"interval ").append((Object)sInLowerCase).toString();
        CalendarInterval cal = CalendarInterval.fromString((String)interval);
        if (cal == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid interval: ").append((Object)s).toString());
        }
        return cal;
    }

    public String sqlConfPrefix() {
        return this.sqlConfPrefix;
    }

    public HashMap<String, DeltaConfig<?>> org$apache$spark$sql$delta$DeltaConfigs$$entries() {
        return this.org$apache$spark$sql$delta$DeltaConfigs$$entries;
    }

    private <T> DeltaConfig<T> buildConfig(String key, String defaultValue, Function1<String, T> fromString, Function1<T, Object> validationFunction, String helpMessage, Option<Protocol> minimumProtocolVersion) {
        DeltaConfig<T> deltaConfig = new DeltaConfig<T>(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delta.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), defaultValue, fromString, validationFunction, helpMessage, minimumProtocolVersion);
        this.org$apache$spark$sql$delta$DeltaConfigs$$entries().put(key.toLowerCase(Locale.ROOT), deltaConfig);
        return deltaConfig;
    }

    private <T> Option<Protocol> buildConfig$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> validateConfigurations(Map<String, String> configurations) {
        return (Map)configurations.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$1) {
                Tuple2 tuple2;
                block6: {
                    Tuple2 tuple22;
                    block5: {
                        block4: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block4;
                            String key = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            if (!key.toLowerCase(Locale.ROOT).startsWith("delta.")) break block4;
                            tuple22 = (Tuple2)Option$.MODULE$.apply(DeltaConfigs$.MODULE$.org$apache$spark$sql$delta$DeltaConfigs$$entries().get(new StringOps(Predef$.MODULE$.augmentString(key.toLowerCase(Locale.ROOT))).stripPrefix("delta."))).map((Function1)new Serializable(this, value){
                                public static final long serialVersionUID = 0L;
                                private final String value$1;

                                public final Tuple2<String, String> apply(DeltaConfig<Object> x$1) {
                                    return x$1.apply(this.value$1);
                                }
                                {
                                    this.value$1 = value$1;
                                }
                            }).getOrElse((Function0)new Serializable(this, key){
                                public static final long serialVersionUID = 0L;
                                private final String key$1;

                                public final Nothing$ apply() {
                                    throw DeltaErrors$.MODULE$.unknownConfigurationKeyException(this.key$1);
                                }
                                {
                                    this.key$1 = key$1;
                                }
                            });
                            break block5;
                        }
                        if (tuple2 == null) break block6;
                        String key = (String)tuple2._1();
                        if (DeltaConfigs$.MODULE$.org$apache$spark$sql$delta$DeltaConfigs$$entries().containsKey(key.toLowerCase(Locale.ROOT))) {
                            DeltaConfigs$.MODULE$.logConsole(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n              |You are trying to set a property the key of which is the same as Delta config: ", ".\n              |If you are trying to set a Delta config, prefix it with \"delta.\", e.g. 'delta.", "'.\n            "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, key})))).stripMargin());
                        }
                        tuple22 = tuple2;
                    }
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    public void verifyProtocolVersionRequirements(Map<String, String> configurations, Protocol current) {
        configurations.foreach((Function1)new Serializable(current){
            public static final long serialVersionUID = 0L;
            private final Protocol current$1;

            public final void apply(Tuple2<String, String> config) {
                String key = new StringOps(Predef$.MODULE$.augmentString(((String)config._1()).toLowerCase(Locale.ROOT))).stripPrefix("delta.");
                if (DeltaConfigs$.MODULE$.org$apache$spark$sql$delta$DeltaConfigs$$entries().containsKey(key) && DeltaConfigs$.MODULE$.org$apache$spark$sql$delta$DeltaConfigs$$entries().get(key).minimumProtocolVersion().isDefined()) {
                    Protocol required = (Protocol)DeltaConfigs$.MODULE$.org$apache$spark$sql$delta$DeltaConfigs$$entries().get(key).minimumProtocolVersion().get();
                    if (this.current$1.minWriterVersion() < required.minWriterVersion() || this.current$1.minReaderVersion() < required.minReaderVersion()) {
                        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting the Delta config ", " requires a protocol version of ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config._1(), required}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"or above, but the protocol version of the Delta table is ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.current$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please upgrade the protocol version of the table before setting this config."})).s((Seq)Nil$.MODULE$)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                }
            }
            {
                this.current$1 = current$1;
            }
        });
    }

    public Map<String, String> mergeGlobalConfigs(SQLConf sqlConfs, Map<String, String> tableConf, Protocol protocol) {
        scala.collection.mutable.Map globalConfs = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.org$apache$spark$sql$delta$DeltaConfigs$$entries()).asScala()).flatMap((Function1)new Serializable(sqlConfs){
            public static final long serialVersionUID = 0L;
            private final SQLConf sqlConfs$1;

            public final Iterable<Tuple2<String, String>> apply(Tuple2<String, DeltaConfig<?>> x0$2) {
                Tuple2<String, DeltaConfig<?>> tuple2 = x0$2;
                if (tuple2 != null) {
                    Iterable iterable;
                    DeltaConfig config = (DeltaConfig)tuple2._2();
                    String sqlConfKey = new StringBuilder().append((Object)DeltaConfigs$.MODULE$.sqlConfPrefix()).append((Object)new StringOps(Predef$.MODULE$.augmentString(config.key())).stripPrefix("delta.")).toString();
                    Option option = Option$.MODULE$.apply((Object)this.sqlConfs$1.getConfString(sqlConfKey, null));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String string = (String)some.x();
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some(config.apply(string)));
                    } else {
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    Iterable iterable2 = iterable;
                    return iterable2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sqlConfs$1 = sqlConfs$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        Map updatedConf = globalConfs.toMap(Predef$.MODULE$.$conforms()).$plus$plus(tableConf);
        this.verifyProtocolVersionRequirements((Map<String, String>)updatedConf, protocol);
        return updatedConf;
    }

    public Seq<String> normalizeConfigKeys(Seq<String> propKeys) {
        return (Seq)propKeys.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x0$3) {
                String string = x0$3;
                String string2 = string.toLowerCase(Locale.ROOT).startsWith("delta.") ? (String)Option$.MODULE$.apply(DeltaConfigs$.MODULE$.org$apache$spark$sql$delta$DeltaConfigs$$entries().get(new StringOps(Predef$.MODULE$.augmentString(string.toLowerCase(Locale.ROOT))).stripPrefix("delta."))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(DeltaConfig<Object> x$2) {
                        return x$2.key();
                    }
                }).getOrElse((Function0)new Serializable(this, string){
                    public static final long serialVersionUID = 0L;
                    private final String x1$1;

                    public final String apply() {
                        return this.x1$1;
                    }
                    {
                        this.x1$1 = x1$1;
                    }
                }) : string;
                return string2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> normalizeConfigKey(Option<String> propKey) {
        return propKey.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x0$4) {
                String string = x0$4;
                String string2 = string.toLowerCase(Locale.ROOT).startsWith("delta.") ? (String)Option$.MODULE$.apply(DeltaConfigs$.MODULE$.org$apache$spark$sql$delta$DeltaConfigs$$entries().get(new StringOps(Predef$.MODULE$.augmentString(string.toLowerCase(Locale.ROOT))).stripPrefix("delta."))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(DeltaConfig<Object> x$3) {
                        return x$3.key();
                    }
                }).getOrElse((Function0)new Serializable(this, string){
                    public static final long serialVersionUID = 0L;
                    private final String x1$2;

                    public final String apply() {
                        return this.x1$2;
                    }
                    {
                        this.x1$2 = x1$2;
                    }
                }) : string;
                return string2;
            }
        });
    }

    public DeltaConfig<CalendarInterval> LOG_RETENTION() {
        return this.LOG_RETENTION;
    }

    public DeltaConfig<CalendarInterval> SAMPLE_RETENTION() {
        return this.SAMPLE_RETENTION;
    }

    public DeltaConfig<CalendarInterval> CHECKPOINT_RETENTION_DURATION() {
        return this.CHECKPOINT_RETENTION_DURATION;
    }

    public DeltaConfig<Object> CHECKPOINT_INTERVAL() {
        return this.CHECKPOINT_INTERVAL;
    }

    public DeltaConfig<Object> ENABLE_EXPIRED_LOG_CLEANUP() {
        return this.ENABLE_EXPIRED_LOG_CLEANUP;
    }

    public DeltaConfig<Object> ENABLE_FULL_RETENTION_ROLLBACK() {
        return this.ENABLE_FULL_RETENTION_ROLLBACK;
    }

    public DeltaConfig<CalendarInterval> TOMBSTONE_RETENTION() {
        return this.TOMBSTONE_RETENTION;
    }

    public DeltaConfig<Object> RANDOMIZE_FILE_PREFIXES() {
        return this.RANDOMIZE_FILE_PREFIXES;
    }

    public DeltaConfig<Object> RANDOM_PREFIX_LENGTH() {
        return this.RANDOM_PREFIX_LENGTH;
    }

    public DeltaConfig<Object> IS_APPEND_ONLY() {
        return this.IS_APPEND_ONLY;
    }

    public DeltaConfig<Object> AUTO_OPTIMIZE() {
        return this.AUTO_OPTIMIZE;
    }

    public DeltaConfig<Object> DATA_SKIPPING_NUM_INDEXED_COLS() {
        return this.DATA_SKIPPING_NUM_INDEXED_COLS;
    }

    private DeltaConfigs$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        DeltaProgressReporter$class.$init$(this);
        DatabricksLogging$class.$init$(this);
        DeltaLogging$class.$init$(this);
        this.sqlConfPrefix = "spark.databricks.delta.properties.defaults.";
        this.org$apache$spark$sql$delta$DeltaConfigs$$entries = new HashMap();
        this.LOG_RETENTION = this.buildConfig("logRetentionDuration", "interval 30 days", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CalendarInterval apply(String s) {
                return DeltaConfigs$.MODULE$.parseCalendarInterval(s);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CalendarInterval i) {
                return i.microseconds > 0L && i.months == 0;
            }
        }, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", this.buildConfig$default$6());
        this.SAMPLE_RETENTION = this.buildConfig("sampleRetentionDuration", "interval 7 days", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CalendarInterval apply(String s) {
                return DeltaConfigs$.MODULE$.parseCalendarInterval(s);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CalendarInterval i) {
                return i.microseconds > 0L && i.months == 0;
            }
        }, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", this.buildConfig$default$6());
        this.CHECKPOINT_RETENTION_DURATION = this.buildConfig("checkpointRetentionDuration", "interval 2 days", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CalendarInterval apply(String s) {
                return DeltaConfigs$.MODULE$.parseCalendarInterval(s);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CalendarInterval i) {
                return i.microseconds > 0L && i.months == 0;
            }
        }, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", this.buildConfig$default$6());
        this.CHECKPOINT_INTERVAL = this.buildConfig("checkpointInterval", "10", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$5) {
                return this.apply$mcZI$sp(x$5);
            }

            public boolean apply$mcZI$sp(int x$5) {
                return x$5 > 0;
            }
        }, "needs to be a positive integer.", this.buildConfig$default$6());
        this.ENABLE_EXPIRED_LOG_CLEANUP = this.buildConfig("enableExpiredLogCleanup", "true", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$7) {
                return true;
            }
        }, "needs to be a boolean.", this.buildConfig$default$6());
        this.ENABLE_FULL_RETENTION_ROLLBACK = this.buildConfig("enableFullRetentionRollback", "true", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$8) {
                return new StringOps(Predef$.MODULE$.augmentString(x$8)).toBoolean();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$9) {
                return true;
            }
        }, "needs to be a boolean.", this.buildConfig$default$6());
        this.TOMBSTONE_RETENTION = this.buildConfig("deletedFileRetentionDuration", "interval 1 week", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CalendarInterval apply(String s) {
                return DeltaConfigs$.MODULE$.parseCalendarInterval(s);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CalendarInterval i) {
                return i.microseconds > 0L && i.months == 0;
            }
        }, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", this.buildConfig$default$6());
        this.RANDOMIZE_FILE_PREFIXES = this.buildConfig("randomizeFilePrefixes", "false", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$10) {
                return new StringOps(Predef$.MODULE$.augmentString(x$10)).toBoolean();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$11) {
                return true;
            }
        }, "needs to be a boolean.", this.buildConfig$default$6());
        this.RANDOM_PREFIX_LENGTH = this.buildConfig("randomPrefixLength", "2", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$12) {
                return new StringOps(Predef$.MODULE$.augmentString(x$12)).toInt();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int a) {
                return this.apply$mcZI$sp(a);
            }

            public boolean apply$mcZI$sp(int a) {
                return a > 0;
            }
        }, "needs to be greater than 0.", this.buildConfig$default$6());
        this.IS_APPEND_ONLY = this.buildConfig("appendOnly", "false", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$13) {
                return new StringOps(Predef$.MODULE$.augmentString(x$13)).toBoolean();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$14) {
                return true;
            }
        }, "needs to be a boolean.", (Option<Protocol>)new Some((Object)new Protocol(0, 2)));
        this.AUTO_OPTIMIZE = this.buildConfig("autoOptimize", "false", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$15) {
                return new StringOps(Predef$.MODULE$.augmentString(x$15)).toBoolean();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$16) {
                return true;
            }
        }, "needs to be a boolean.", this.buildConfig$default$6());
        this.DATA_SKIPPING_NUM_INDEXED_COLS = this.buildConfig("dataSkippingNumIndexedCols", "32", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$17) {
                return new StringOps(Predef$.MODULE$.augmentString(x$17)).toInt();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int a) {
                return this.apply$mcZI$sp(a);
            }

            public boolean apply$mcZI$sp(int a) {
                return a >= -1;
            }
        }, "needs to be larger than or equal to -1.", this.buildConfig$default$6());
    }
}

