/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging$class;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.sql.Timestamp;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaHistoryManager$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitInfo$;
import org.apache.spark.sql.delta.actions.CommitMarker;
import org.apache.spark.sql.delta.actions.JobInfo;
import org.apache.spark.sql.delta.actions.NotebookInfo;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.metering.DeltaLogging$class;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter$class;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class DeltaHistoryManager$
implements DeltaLogging {
    public static final DeltaHistoryManager$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaHistoryManager$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging$class.recordDeltaEvent(this, deltaLog, opType, tags, data);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging$class.recordDeltaOperation(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging$class.recordDeltaOperation$default$3(this);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging$class.recordDeltaEvent$default$3(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging$class.recordDeltaEvent$default$4(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging$class.logConsole(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging$class.recordUsage(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging$class.recordEvent(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging$class.recordOperation(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging$class.recordUsage$default$3(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging$class.recordUsage$default$4(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging$class.recordUsage$default$5(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging$class.recordUsage$default$6(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging$class.recordUsage$default$7(this);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging$class.recordEvent$default$2(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging$class.recordEvent$default$3(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging$class.recordEvent$default$4(this);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging$class.recordOperation$default$2(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging$class.recordOperation$default$4(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging$class.recordOperation$default$5(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging$class.recordOperation$default$6(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging$class.recordOperation$default$7(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging$class.recordOperation$default$8(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging$class.recordOperation$default$9(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter$class.withStatusCode(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter$class.withStatusCode$default$3(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public CommitInfo org$apache$spark$sql$delta$DeltaHistoryManager$$getCommitInfo(LogStore logStore, Path basePath, long version) {
        CommitInfo commitInfo;
        Option info = logStore.read(FileNames$.MODULE$.deltaFile(basePath, version)).iterator().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Action apply(String json) {
                return Action$.MODULE$.fromJson(json);
            }
        }).collectFirst((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CommitInfo) {
                    CommitInfo commitInfo = (CommitInfo)A1;
                    object = commitInfo;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Action x1) {
                Action action = x1;
                boolean bl = action instanceof CommitInfo;
                return bl;
            }
        });
        if (info.isEmpty()) {
            commitInfo = CommitInfo$.MODULE$.empty((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)version)));
        } else {
            CommitInfo qual$1 = (CommitInfo)Option$.MODULE$.option2Iterable(info).head();
            Some x$3 = new Some((Object)BoxesRunTime.boxToLong((long)version));
            Timestamp x$4 = qual$1.copy$default$2();
            Option<String> x$5 = qual$1.copy$default$3();
            Option<String> x$6 = qual$1.copy$default$4();
            String x$7 = qual$1.copy$default$5();
            Map<String, String> x$8 = qual$1.copy$default$6();
            Option<JobInfo> x$9 = qual$1.copy$default$7();
            Option<NotebookInfo> x$10 = qual$1.copy$default$8();
            Option<String> x$11 = qual$1.copy$default$9();
            Option<Object> x$12 = qual$1.copy$default$10();
            Option<String> x$13 = qual$1.copy$default$11();
            Option<Object> x$14 = qual$1.copy$default$12();
            commitInfo = qual$1.copy((Option<Object>)x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14);
        }
        return commitInfo;
    }

    public DeltaHistoryManager.Commit[] getCommits(LogStore logStore, Path logPath, long start, Option<Object> end) {
        long until = BoxesRunTime.unboxToLong((Object)end.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Long.MAX_VALUE;
            }
        }));
        Iterator commits = logStore.listFrom(FileNames$.MODULE$.deltaFile(logPath, start)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus f) {
                return FileNames$.MODULE$.isDeltaFile(f.getPath());
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DeltaHistoryManager.Commit apply(FileStatus fileStatus) {
                return new DeltaHistoryManager.Commit(FileNames$.MODULE$.deltaVersion(fileStatus.getPath()), fileStatus.getModificationTime());
            }
        }).takeWhile((Function1)new Serializable(until){
            public static final long serialVersionUID = 0L;
            private final long until$1;

            public final boolean apply(DeltaHistoryManager.Commit x$1) {
                return x$1.version() < this.until$1;
            }
            {
                this.until$1 = until$1;
            }
        });
        return (DeltaHistoryManager.Commit[])this.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps((CommitMarker[])commits.toArray(ClassTag$.MODULE$.apply(DeltaHistoryManager.Commit.class)));
    }

    public Option<Object> getCommits$default$4() {
        return None$.MODULE$;
    }

    public <T extends CommitMarker> T[] org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps(T[] commits) {
        IntRef i = IntRef.create((int)0);
        int length = commits.length;
        while (i.elem < length - 1) {
            long prevTimestamp = commits[i.elem].getTimestamp();
            Predef$.MODULE$.assert(commits[i.elem].getVersion() < commits[i.elem + 1].getVersion(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Unordered commits provided.";
                }
            });
            if (prevTimestamp >= commits[i.elem + 1].getTimestamp()) {
                this.logWarning((Function0<String>)new Serializable((CommitMarker[])commits, i, prevTimestamp){
                    public static final long serialVersionUID = 0L;
                    private final CommitMarker[] commits$1;
                    private final IntRef i$1;
                    private final long prevTimestamp$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found Delta commit ", " with a timestamp ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.commits$1[this.i$1.elem].getVersion()), BoxesRunTime.boxToLong((long)this.prevTimestamp$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which is greater than the next commit timestamp ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.commits$1[this.i$1.elem + 1].getTimestamp())}))).toString();
                    }
                    {
                        this.commits$1 = commits$1;
                        this.i$1 = i$1;
                        this.prevTimestamp$1 = prevTimestamp$1;
                    }
                });
                commits[i.elem + 1] = commits[i.elem + 1].withTimestamp(prevTimestamp + 1L);
            }
            ++i.elem;
        }
        return commits;
    }

    public DeltaHistoryManager.Commit org$apache$spark$sql$delta$DeltaHistoryManager$$parallelSearch0(SparkSession spark, SerializableConfiguration conf, String logPath, long time, long start, long end, long step) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.DeltaHistoryManager.Commit").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator8$1() {
            }
        }
        DeltaHistoryManager.Commit[] possibleCommits = (DeltaHistoryManager.Commit[])spark.range(start, end, step).mapPartitions((Function1)new Serializable(conf, logPath, time, end, step){
            public static final long serialVersionUID = 0L;
            private final SerializableConfiguration conf$2;
            private final String logPath$2;
            public final long time$2;
            public final long end$1;
            public final long step$1;

            public final Iterator<DeltaHistoryManager.Commit> apply(Iterator<Long> startVersions) {
                LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), this.conf$2.value());
                Path basePath = new Path(this.logPath$2);
                return startVersions.map((Function1)new Serializable(this, logStore, basePath){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.16 $outer;
                    private final LogStore logStore$2;
                    private final Path basePath$2;

                    public final DeltaHistoryManager.Commit apply(Long startVersion) {
                        DeltaHistoryManager.Commit[] commits = DeltaHistoryManager$.MODULE$.getCommits(this.logStore$2, this.basePath$2, Predef$.MODULE$.Long2long(startVersion), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.min(Predef$.MODULE$.Long2long(startVersion) + this.$outer.step$1, this.$outer.end$1))));
                        return (DeltaHistoryManager.Commit)DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<DeltaHistoryManager.Commit>)Predef$.MODULE$.wrapRefArray((Object[])commits), this.$outer.time$2).getOrElse((Function0)new Serializable(this, commits){
                            public static final long serialVersionUID = 0L;
                            private final DeltaHistoryManager.Commit[] commits$3;

                            public final DeltaHistoryManager.Commit apply() {
                                return (DeltaHistoryManager.Commit)Predef$.MODULE$.refArrayOps((Object[])this.commits$3).head();
                            }
                            {
                                this.commits$3 = commits$3;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.logStore$2 = logStore$2;
                        this.basePath$2 = basePath$2;
                    }
                });
            }
            {
                this.conf$2 = conf$2;
                this.logPath$2 = logPath$2;
                this.time$2 = time$2;
                this.end$1 = end$1;
                this.step$1 = step$1;
            }
        }, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator8$1()))).collect();
        DeltaHistoryManager.Commit[] commitList = (DeltaHistoryManager.Commit[])this.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps(possibleCommits);
        return (DeltaHistoryManager.Commit)this.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<DeltaHistoryManager.Commit>)Predef$.MODULE$.wrapRefArray((Object[])commitList), time).getOrElse((Function0)new Serializable(commitList){
            public static final long serialVersionUID = 0L;
            private final DeltaHistoryManager.Commit[] commitList$1;

            public final DeltaHistoryManager.Commit apply() {
                return (DeltaHistoryManager.Commit)Predef$.MODULE$.refArrayOps((Object[])this.commitList$1).head();
            }
            {
                this.commitList$1 = commitList$1;
            }
        });
    }

    public Option<DeltaHistoryManager.Commit> org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp(Seq<DeltaHistoryManager.Commit> commits, long time) {
        int i = commits.lastIndexWhere((Function1)new Serializable(time){
            public static final long serialVersionUID = 0L;
            private final long time$1;

            public final boolean apply(DeltaHistoryManager.Commit x$2) {
                return x$2.timestamp() <= this.time$1;
            }
            {
                this.time$1 = time$1;
            }
        });
        return i < 0 ? None$.MODULE$ : new Some(commits.apply(i));
    }

    public int $lessinit$greater$default$2() {
        return 1000;
    }

    private DeltaHistoryManager$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        DeltaProgressReporter$class.$init$(this);
        DatabricksLogging$class.$init$(this);
        DeltaLogging$class.$init$(this);
    }
}

