/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging$class;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import com.databricks.spark.util.TagDefinitions$TAG_TAHOE_PATH$;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AnalysisHelper$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaLog$$anon$3$;
import org.apache.spark.sql.delta.DeltaLog$$anonfun$rewritePartitionFilters$1$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.metering.DeltaLogging$class;
import org.apache.spark.sql.delta.util.DeltaProgressReporter$class;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class DeltaLog$
implements DeltaLogging {
    public static final DeltaLog$ MODULE$;
    private ExecutionContextExecutorService deltaLogAsyncUpdateThreadPool;
    private final Cache<Path, DeltaLog> deltaLogCache;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new DeltaLog$();
    }

    private ExecutionContextExecutorService deltaLogAsyncUpdateThreadPool$lzycompute() {
        DeltaLog$ deltaLog$ = this;
        synchronized (deltaLog$) {
            if (!this.bitmap$0) {
                ThreadPoolExecutor tpe = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("delta-state-update", 8, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
                this.deltaLogAsyncUpdateThreadPool = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)tpe);
                this.bitmap$0 = true;
            }
            return this.deltaLogAsyncUpdateThreadPool;
        }
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging$class.recordDeltaEvent(this, deltaLog, opType, tags, data);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging$class.recordDeltaOperation(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging$class.recordDeltaOperation$default$3(this);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging$class.recordDeltaEvent$default$3(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging$class.recordDeltaEvent$default$4(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging$class.logConsole(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging$class.recordUsage(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging$class.recordEvent(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging$class.recordOperation(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging$class.recordUsage$default$3(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging$class.recordUsage$default$4(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging$class.recordUsage$default$5(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging$class.recordUsage$default$6(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging$class.recordUsage$default$7(this);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging$class.recordEvent$default$2(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging$class.recordEvent$default$3(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging$class.recordEvent$default$4(this);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging$class.recordOperation$default$2(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging$class.recordOperation$default$4(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging$class.recordOperation$default$5(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging$class.recordOperation$default$6(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging$class.recordOperation$default$7(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging$class.recordOperation$default$8(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging$class.recordOperation$default$9(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter$class.withStatusCode(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter$class.withStatusCode$default$3(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public ExecutionContextExecutorService deltaLogAsyncUpdateThreadPool() {
        return this.bitmap$0 ? this.deltaLogAsyncUpdateThreadPool : this.deltaLogAsyncUpdateThreadPool$lzycompute();
    }

    private Cache<Path, DeltaLog> deltaLogCache() {
        return this.deltaLogCache;
    }

    public DeltaLog forTable(SparkSession spark, String dataPath) {
        return this.apply(spark, new Path(dataPath, "_delta_log"), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, File dataPath) {
        return this.apply(spark, new Path(dataPath.getAbsolutePath(), "_delta_log"), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, Path dataPath) {
        return this.apply(spark, new Path(dataPath, "_delta_log"), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, String dataPath, Clock clock) {
        return this.apply(spark, new Path(dataPath, "_delta_log"), clock);
    }

    public DeltaLog forTable(SparkSession spark, File dataPath, Clock clock) {
        return this.apply(spark, new Path(dataPath.getAbsolutePath(), "_delta_log"), clock);
    }

    public DeltaLog forTable(SparkSession spark, Path dataPath, Clock clock) {
        return this.apply(spark, new Path(dataPath, "_delta_log"), clock);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeltaLog apply(SparkSession spark, Path rawPath, Clock clock) {
        while (true) {
            FileSystem fs = rawPath.getFileSystem(spark.sessionState().newHadoopConf());
            Path path = fs.makeQualified(rawPath);
            try {
                DeltaLog cached = (DeltaLog)this.deltaLogCache().get((Object)path, (Callable)new Callable<DeltaLog>(clock, path){
                    public final Clock clock$1;
                    public final Path path$1;

                    public DeltaLog call() {
                        return (DeltaLog)DeltaLog$.MODULE$.recordDeltaOperation((DeltaLog)null, "delta.log.create", (Map<TagDefinition, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TagDefinitions$TAG_TAHOE_PATH$.MODULE$), (Object)this.path$1.getParent().toString())}))), new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.3 $outer;

                            public final DeltaLog apply() {
                                return (DeltaLog)AnalysisHelper$.MODULE$.allowInvokingTransformsInAnalyzer((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anon$3$$anonfun$call$1 $outer;

                                    public final DeltaLog apply() {
                                        return new DeltaLog(this.$outer.org$apache$spark$sql$delta$DeltaLog$$anon$$anonfun$$$outer().path$1, this.$outer.org$apache$spark$sql$delta$DeltaLog$$anon$$anonfun$$$outer().path$1.getParent(), this.$outer.org$apache$spark$sql$delta$DeltaLog$$anon$$anonfun$$$outer().clock$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }

                            public /* synthetic */ anon.3 org$apache$spark$sql$delta$DeltaLog$$anon$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.clock$1 = clock$1;
                        this.path$1 = path$1;
                    }
                });
                if (cached.snapshot().version() == -1L || cached.isValid()) {
                    return cached;
                }
            }
            catch (UncheckedExecutionException uncheckedExecutionException) {
                throw uncheckedExecutionException.getCause();
            }
            this.deltaLogCache().invalidate((Object)path);
            clock = this.apply$default$3();
            rawPath = path;
        }
    }

    public Clock apply$default$3() {
        return new SystemClock();
    }

    public void invalidateCache(SparkSession spark, Path dataPath) {
        try {
            Path rawPath = new Path(dataPath, "_delta_log");
            FileSystem fs = rawPath.getFileSystem(spark.sessionState().newHadoopConf());
            Path path = fs.makeQualified(rawPath);
            this.deltaLogCache().invalidate((Object)path);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)new Serializable(e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final String apply() {
                    return this.e$1.getMessage();
                }
                {
                    this.e$1 = e$1;
                }
            }, e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void clearCache() {
        this.deltaLogCache().invalidateAll();
    }

    public Dataset<Row> filterFileList(Seq<String> partitionColumns, Dataset<Row> files, Seq<Expression> partitionFilters, Seq<String> partitionColumnPrefixes) {
        Seq<Expression> rewrittenFilters = this.rewritePartitionFilters(partitionColumns, (Function2<String, String, Object>)files.sparkSession().sessionState().conf().resolver(), partitionFilters, partitionColumnPrefixes);
        Column columnFilter = new Column((Expression)rewrittenFilters.reduceLeftOption((Function2)And$.MODULE$).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Literal apply() {
                return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }));
        return files.filter(columnFilter);
    }

    public Seq<String> filterFileList$default$4() {
        return Nil$.MODULE$;
    }

    public Seq<Expression> rewritePartitionFilters(Seq<String> partitionColumns, Function2<String, String, Object> resolver, Seq<Expression> partitionFilters, Seq<String> partitionColumnPrefixes) {
        return (Seq)partitionFilters.map((Function1)new Serializable(partitionColumns, resolver, partitionColumnPrefixes){
            public static final long serialVersionUID = 0L;
            public final Seq partitionColumns$1;
            public final Function2 resolver$1;
            public final Seq partitionColumnPrefixes$1;

            public final Expression apply(Expression x$13) {
                return (Expression)x$13.transform((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.rewritePartitionFilters.1 $outer;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof Attribute) {
                            Attribute attribute = (Attribute)A1;
                            String colName = (String)this.$outer.partitionColumns$1.find((Function1)new Serializable(this, attribute){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$rewritePartitionFilters$1$$anonfun$apply$2 $outer;
                                private final Attribute x2$1;

                                public final boolean apply(String x$14) {
                                    return BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$spark$sql$delta$DeltaLog$$anonfun$$anonfun$$$outer().resolver$1.apply((Object)x$14, (Object)this.x2$1.name()));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x2$1 = x2$1;
                                }
                            }).getOrElse((Function0)new Serializable(this, attribute){
                                public static final long serialVersionUID = 0L;
                                private final Attribute x2$1;

                                public final String apply() {
                                    return this.x2$1.name();
                                }
                                {
                                    this.x2$1 = x2$1;
                                }
                            });
                            object = new UnresolvedAttribute((Seq)this.$outer.partitionColumnPrefixes$1.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionValues", colName})), Seq$.MODULE$.canBuildFrom()));
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Expression x2) {
                        Expression expression = x2;
                        boolean bl = expression instanceof Attribute;
                        return bl;
                    }

                    public /* synthetic */ anonfun.rewritePartitionFilters.1 org$apache$spark$sql$delta$DeltaLog$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).transform((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x3;
                        if (A1 instanceof InSet) {
                            InSet inSet = (InSet)A1;
                            Expression a = inSet.child();
                            Set set = inSet.hset();
                            object = new In(a, (Seq)set.toSeq().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Literal apply(Object x$15) {
                                    return Literal$.MODULE$.apply(x$15);
                                }
                            }, Seq$.MODULE$.canBuildFrom()));
                        } else {
                            object = function1.apply(x3);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Expression x3) {
                        Expression expression = x3;
                        boolean bl = expression instanceof InSet;
                        return bl;
                    }
                });
            }
            {
                this.partitionColumns$1 = partitionColumns$1;
                this.resolver$1 = resolver$1;
                this.partitionColumnPrefixes$1 = partitionColumnPrefixes$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> rewritePartitionFilters$default$4() {
        return Nil$.MODULE$;
    }

    private DeltaLog$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        DeltaProgressReporter$class.$init$(this);
        DatabricksLogging$class.$init$(this);
        DeltaLogging$class.$init$(this);
        CacheBuilder builder = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<Path, DeltaLog>(){

            public void onRemoval(RemovalNotification<Path, DeltaLog> removalNotification) {
                DeltaLog log = (DeltaLog)removalNotification.getValue();
                try {
                    log.snapshot().uncache();
                }
                catch (NullPointerException nullPointerException) {}
            }
        });
        package$.MODULE$.props().get("delta.log.cacheSize").flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(String v) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, v){
                    public static final long serialVersionUID = 0L;
                    private final String v$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.v$1)).toLong();
                    }
                    {
                        this.v$1 = v$1;
                    }
                }).toOption();
            }
        }).foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final CacheBuilder builder$1;

            public final CacheBuilder<Path, DeltaLog> apply(long x$1) {
                return this.builder$1.maximumSize(x$1);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        this.deltaLogCache = builder.build();
    }
}

