/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class DeltaTimeTravelSpec$
implements Serializable {
    public static final DeltaTimeTravelSpec$ MODULE$;
    private final Regex VERSION_URI_FOR_TIME_TRAVEL;
    private final String TIMESTAMP_FORMAT;
    private final int TIMESTAMP_FORMAT_LENGTH;
    private final Regex TIMESTAMP_URI_FOR_TIME_TRAVEL;

    static {
        new DeltaTimeTravelSpec$();
    }

    private Regex VERSION_URI_FOR_TIME_TRAVEL() {
        return this.VERSION_URI_FOR_TIME_TRAVEL;
    }

    private String TIMESTAMP_FORMAT() {
        return this.TIMESTAMP_FORMAT;
    }

    private int TIMESTAMP_FORMAT_LENGTH() {
        return this.TIMESTAMP_FORMAT_LENGTH;
    }

    private Regex TIMESTAMP_URI_FOR_TIME_TRAVEL() {
        return this.TIMESTAMP_URI_FOR_TIME_TRAVEL;
    }

    public boolean isApplicable(SQLConf conf, String identifier) {
        return BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.RESOLVE_TIME_TRAVEL_ON_IDENTIFIER())) && this.identifierContainsTimeTravel(identifier);
    }

    private boolean identifierContainsTimeTravel(String identifier) {
        Option option;
        String string = identifier;
        Option option2 = this.TIMESTAMP_URI_FOR_TIME_TRAVEL().unapplySeq((CharSequence)string);
        boolean bl = !option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0 ? true : !(option = this.VERSION_URI_FOR_TIME_TRAVEL().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0;
        return bl;
    }

    public Tuple2<DeltaTimeTravelSpec, String> addTimeTravelNode(SQLConf conf, String identifier) {
        String string;
        block4: {
            Tuple2 tuple2;
            block3: {
                block2: {
                    string = identifier;
                    Option option = this.TIMESTAMP_URI_FOR_TIME_TRAVEL().unapplySeq((CharSequence)string);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block2;
                    String ts = (String)((LinearSeqOptimized)option.get()).apply(0);
                    Expression timestamp = this.parseTimestamp(ts, conf.sessionLocalTimeZone());
                    String realIdentifier = (String)new StringOps(Predef$.MODULE$.augmentString(identifier)).dropRight(this.TIMESTAMP_FORMAT_LENGTH() + 1);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new DeltaTimeTravelSpec((Option<Expression>)new Some((Object)timestamp), (Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)"atSyntax.path"))), (Object)realIdentifier);
                    break block3;
                }
                Option option = this.VERSION_URI_FOR_TIME_TRAVEL().unapplySeq((CharSequence)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block4;
                String v = (String)((LinearSeqOptimized)option.get()).apply(0);
                String realIdentifier = (String)new StringOps(Predef$.MODULE$.augmentString(identifier)).dropRight(v.length() + 2);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new DeltaTimeTravelSpec((Option<Expression>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(v)).toLong())), (Option<String>)new Some((Object)"atSyntax.path"))), (Object)realIdentifier);
            }
            return tuple2;
        }
        throw new MatchError((Object)string);
    }

    private Expression parseTimestamp(String ts, String timeZone) {
        FastDateFormat format = FastDateFormat.getInstance((String)this.TIMESTAMP_FORMAT(), (TimeZone)DateTimeUtils$.MODULE$.getTimeZone(timeZone));
        try {
            long sqlTs = DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(format.parse(ts).getTime()));
            return new PreciseTimestampConversion((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)sqlTs)), (DataType)LongType$.MODULE$, (DataType)TimestampType$.MODULE$);
        }
        catch (ParseException parseException) {
            String x$2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The provided timestamp ", " doesn't match the expected syntax ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ts, this.TIMESTAMP_FORMAT()}));
            Some x$3 = new Some((Object)parseException);
            Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
            Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
            Option x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
            throw new AnalysisException(x$2, x$4, x$5, x$6, (Option)x$3);
        }
    }

    public DeltaTimeTravelSpec apply(Option<Expression> timestamp, Option<Object> version, Option<String> creationSource) {
        return new DeltaTimeTravelSpec(timestamp, version, creationSource);
    }

    public Option<Tuple3<Option<Expression>, Option<Object>, Option<String>>> unapply(DeltaTimeTravelSpec x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3(x$0.timestamp(), x$0.version(), x$0.creationSource()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DeltaTimeTravelSpec$() {
        MODULE$ = this;
        this.VERSION_URI_FOR_TIME_TRAVEL = new StringOps(Predef$.MODULE$.augmentString(".*@[vV](\\d+)$")).r();
        this.TIMESTAMP_FORMAT = "yyyyMMddHHmmssSSS";
        this.TIMESTAMP_FORMAT_LENGTH = this.TIMESTAMP_FORMAT().length();
        this.TIMESTAMP_URI_FOR_TIME_TRAVEL = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".*@(\\\\d{", "})$"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.TIMESTAMP_FORMAT_LENGTH())})))).r();
    }
}

