/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.MetadataCleanup$;
import org.apache.spark.sql.delta.util.FileNames$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public abstract class MetadataCleanup$class {
    public static boolean enableExpiredLogCleanup(DeltaLog $this) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_EXPIRED_LOG_CLEANUP().fromMetaData($this.metadata()));
    }

    public static long deltaRetentionMillis(DeltaLog $this) {
        return DeltaConfigs$.MODULE$.LOG_RETENTION().fromMetaData($this.metadata()).milliseconds();
    }

    public static void doLogCleanup(DeltaLog $this) {
        if ($this.enableExpiredLogCleanup()) {
            $this.cleanUpExpiredLogs();
        }
    }

    public static void cleanUpExpiredLogs(DeltaLog $this) {
        $this.recordDeltaOperation($this, "delta.log.cleanup", $this.recordDeltaOperation$default$3(), new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaLog $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Date fileCutOffTime = this.$outer.truncateDay(this.$outer.clock().getTimeMillis() - this.$outer.deltaRetentionMillis()).getTime();
                String formattedDate = fileCutOffTime.toGMTString();
                this.$outer.logInfo((Function0<String>)new Serializable(this, formattedDate){
                    public static final long serialVersionUID = 0L;
                    private final String formattedDate$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting the deletion of log files older than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formattedDate$1}));
                    }
                    {
                        this.formattedDate$1 = formattedDate$1;
                    }
                });
                IntRef numDeleted = IntRef.create((int)0);
                MetadataCleanup$class.org$apache$spark$sql$delta$MetadataCleanup$$listExpiredDeltaLogs(this.$outer, fileCutOffTime.getTime()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(FileStatus x$1) {
                        return x$1.getPath();
                    }
                }).foreach((Function1)new Serializable(this, numDeleted){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MetadataCleanup$.anonfun.cleanUpExpiredLogs.1 $outer;
                    private final IntRef numDeleted$1;

                    public final void apply(Path path) {
                        if (this.$outer.org$apache$spark$sql$delta$MetadataCleanup$$anonfun$$$outer().fs().delete(path, false)) {
                            ++this.numDeleted$1.elem;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numDeleted$1 = numDeleted$1;
                    }
                });
                this.$outer.logInfo((Function0<String>)new Serializable(this, formattedDate, numDeleted){
                    public static final long serialVersionUID = 0L;
                    private final String formattedDate$1;
                    private final IntRef numDeleted$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " log files older than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numDeleted$1.elem), this.formattedDate$1}));
                    }
                    {
                        this.formattedDate$1 = formattedDate$1;
                        this.numDeleted$1 = numDeleted$1;
                    }
                });
            }

            public /* synthetic */ DeltaLog org$apache$spark$sql$delta$MetadataCleanup$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Iterator org$apache$spark$sql$delta$MetadataCleanup$$listExpiredDeltaLogs(DeltaLog $this, long fileCutOffTime) {
        Option<CheckpointMetaData> latestCheckpoint = $this.lastCheckpoint();
        if (latestCheckpoint.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        long threshold = ((CheckpointMetaData)latestCheckpoint.get()).version() - 1L;
        Iterator files = $this.store().listFrom(FileNames$.MODULE$.deltaFile($this.logPath(), 0L)).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus f) {
                return FileNames$.MODULE$.isCheckpointFile(f.getPath()) || FileNames$.MODULE$.isDeltaFile(f.getPath());
            }
        });
        return new DeltaHistoryManager.BufferingLogDeletionIterator((Iterator<FileStatus>)files, fileCutOffTime, threshold, (Function1<Path, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaLog $outer;

            public final long apply(Path filePath) {
                return MetadataCleanup$class.getVersion$1(this.$outer, filePath);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Calendar truncateDay(DeltaLog $this, long timeMillis) {
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.setTimeInMillis(timeMillis);
        return DateUtils.truncate((Calendar)date, (int)5);
    }

    public static final long getVersion$1(DeltaLog $this, Path filePath) {
        return FileNames$.MODULE$.isCheckpointFile(filePath) ? FileNames$.MODULE$.checkpointVersion(filePath) : FileNames$.MODULE$.deltaVersion(filePath);
    }

    public static void $init$(DeltaLog $this) {
    }
}

