/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.TagDefinition;
import com.fasterxml.jackson.module.scala.experimental.ScalaObjectMapper;
import java.io.FileNotFoundException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.VersionChecksum;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public abstract class VerifyChecksum$class {
    public static void validateChecksum(DeltaLog $this, Snapshot snapshot) {
        Some content;
        Some some;
        long version = snapshot.version();
        Path checksumFile = FileNames$.MODULE$.checksumFile($this.logPath(), version);
        None$ exception = None$.MODULE$;
        try {
            some = new Some($this.store().read(checksumFile));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (!(e instanceof FileNotFoundException)) {
                exception = new Some((Object)Utils$.MODULE$.exceptionString(e));
            }
            None$ none$ = None$.MODULE$;
            some = content = none$;
        }
        if (content.isEmpty()) {
            DeltaLog x$2 = $this;
            String x$3 = "delta.checksum.error.missing";
            Map x$4 = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToLong((long)version))}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(exception.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(String x$1) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)x$1);
                }
            })));
            Map<TagDefinition, String> x$5 = $this.recordDeltaEvent$default$3();
            $this.recordDeltaEvent(x$2, x$3, x$5, x$4);
            return;
        }
        Seq checksumData = (Seq)content.get();
        if (checksumData.isEmpty()) {
            DeltaLog x$6 = $this;
            String x$7 = "delta.checksum.error.empty";
            Map x$8 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToLong((long)version))}));
            Map<TagDefinition, String> x$9 = $this.recordDeltaEvent$default$3();
            $this.recordDeltaEvent(x$6, x$7, x$9, x$8);
            return;
        }
        None$ mismatchStringOpt = None$.MODULE$;
        try {
            VersionChecksum checksum = (VersionChecksum)((ScalaObjectMapper)JsonUtils$.MODULE$.mapper()).readValue((String)checksumData.head(), ManifestFactory$.MODULE$.classType(VersionChecksum.class));
            mismatchStringOpt = VerifyChecksum$class.checkMismatch($this, checksum, snapshot);
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            DeltaLog x$10 = $this;
            String x$11 = "delta.checksum.error.parsing";
            Map x$12 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)Utils$.MODULE$.exceptionString(e))}));
            Map<TagDefinition, String> x$13 = $this.recordDeltaEvent$default$3();
            $this.recordDeltaEvent(x$10, x$11, x$13, x$12);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (mismatchStringOpt.isDefined()) {
            DeltaLog x$14 = $this;
            String x$15 = "delta.checksum.invalid";
            Map x$16 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), mismatchStringOpt.get())}));
            Map<TagDefinition, String> x$17 = $this.recordDeltaEvent$default$3();
            $this.recordDeltaEvent(x$14, x$15, x$17, x$16);
            SparkSession spark = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalStateException("Active SparkSession not set.");
                }
            });
            ConfigEntry<Object> conf = DeltaSQLConf$.MODULE$.DELTA_STATE_CORRUPTION_IS_FATAL();
            if (BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(conf))) {
                throw new IllegalStateException(new StringBuilder().append((Object)"The transaction log has failed integrity checks. We recommend you contact ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Databricks support for assistance. To disable this check, set ", " to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"false. Failed verification of:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mismatchStringOpt.get()}))).toString());
            }
        }
    }

    private static Option checkMismatch(DeltaLog $this, VersionChecksum checksum, Snapshot snapshot) {
        ArrayBuffer result = new ArrayBuffer();
        VerifyChecksum$class.compare$1($this, checksum.tableSizeBytes(), snapshot.sizeInBytes(), "Table size (bytes)", result);
        VerifyChecksum$class.compare$1($this, checksum.numFiles(), snapshot.numOfFiles(), "Number of files", result);
        VerifyChecksum$class.compare$1($this, checksum.numMetadata(), snapshot.numOfMetadata(), "Metadata updates", result);
        VerifyChecksum$class.compare$1($this, checksum.numProtocol(), snapshot.numOfProtocol(), "Protocol updates", result);
        VerifyChecksum$class.compare$1($this, checksum.numTransactions(), snapshot.numOfSetTransactions(), "Transactions", result);
        return result.isEmpty() ? None$.MODULE$ : new Some((Object)result.mkString("\n"));
    }

    private static final void compare$1(DeltaLog $this, long expected, long found, String title, ArrayBuffer result$1) {
        if (expected != found) {
            result$1.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - Expected: ", " Computed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{title, BoxesRunTime.boxToLong((long)expected), BoxesRunTime.boxToLong((long)found)})));
        }
    }

    public static void $init$(DeltaLog $this) {
    }
}

