/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.DeltaCommand$;
import org.apache.spark.sql.delta.commands.DeltaCommand$$anonfun$verifyPartitionPredicates$1$;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class DeltaCommand$class {
    public static Seq parsePartitionPredicates(DeltaCommand $this, SparkSession spark, String predicate) {
        try {
            Expression expression = spark.sessionState().sqlParser().parseExpression(predicate);
            return Nil$.MODULE$.$colon$colon((Object)expression);
        }
        catch (ParseException parseException) {
            String x$3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot recognize the predicate '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{predicate}));
            Some x$4 = new Some((Object)parseException);
            Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
            Option x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
            Option x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
            throw new AnalysisException(x$3, x$5, x$6, x$7, (Option)x$4);
        }
    }

    public static void verifyPartitionPredicates(DeltaCommand $this, SparkSession spark, Seq partitionColumns, Seq predicates) {
        predicates.foreach((Function1)new Serializable($this, spark, partitionColumns){
            public static final long serialVersionUID = 0L;
            public final SparkSession spark$1;
            public final Seq partitionColumns$1;

            public final void apply(Expression pred) {
                if (SubqueryExpression$.MODULE$.hasSubquery(pred)) {
                    throw new AnalysisException("Subquery is not supported in partition predicates.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                pred.references().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DeltaCommand$.anonfun.verifyPartitionPredicates.1 $outer;

                    public final String apply(Attribute col) {
                        Function2 nameEquality = this.$outer.spark$1.sessionState().conf().resolver();
                        return (String)this.$outer.partitionColumns$1.find((Function1)new Serializable(this, nameEquality, col){
                            public static final long serialVersionUID = 0L;
                            private final Function2 nameEquality$1;
                            private final Attribute col$1;

                            public final boolean apply(String f) {
                                return BoxesRunTime.unboxToBoolean((Object)this.nameEquality$1.apply((Object)f, (Object)this.col$1.name()));
                            }
                            {
                                this.nameEquality$1 = nameEquality$1;
                                this.col$1 = col$1;
                            }
                        }).getOrElse((Function0)new Serializable(this, col){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DeltaCommand$$anonfun$verifyPartitionPredicates$1$.anonfun.apply.1 $outer;
                            private final Attribute col$1;

                            public final Nothing$ apply() {
                                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Predicate references non-partition column '", "'. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col$1.name()}))).append((Object)"Only the partition columns may be referenced: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$delta$commands$DeltaCommand$$anonfun$$anonfun$$$outer().partitionColumns$1.mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.col$1 = col$1;
                            }
                        });
                    }

                    public /* synthetic */ DeltaCommand$.anonfun.verifyPartitionPredicates.1 org$apache$spark$sql$delta$commands$DeltaCommand$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.spark$1 = spark$1;
                this.partitionColumns$1 = partitionColumns$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Map generateCandidateFileMap(DeltaCommand $this, Path basePath, Seq candidateFiles) {
        void var3_3;
        Map nameToAddFileMap = ((TraversableOnce)candidateFiles.map((Function1)new Serializable($this, basePath){
            public static final long serialVersionUID = 0L;
            private final Path basePath$1;

            public final Tuple2<String, AddFile> apply(AddFile add) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaFileOperations$.MODULE$.absolutePath(this.basePath$1.toString(), add.path()).toString()), (Object)add);
            }
            {
                this.basePath$1 = basePath$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Predef$.MODULE$.assert(nameToAddFileMap.size() == candidateFiles.length(), (Function0)new Serializable($this, candidateFiles){
            public static final long serialVersionUID = 0L;
            private final Seq candidateFiles$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File name collisions found among:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.candidateFiles$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AddFile x$2) {
                        return x$2.path();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("\n")}));
            }
            {
                this.candidateFiles$1 = candidateFiles$1;
            }
        });
        return var3_3;
    }

    public static Seq removeFilesFromPaths(DeltaCommand $this, DeltaLog deltaLog, Map nameToAddFileMap, Seq filesToRewrite, long operationTimestamp) {
        return (Seq)filesToRewrite.map((Function1)new Serializable($this, deltaLog, nameToAddFileMap, operationTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaCommand $outer;
            private final DeltaLog deltaLog$1;
            private final Map nameToAddFileMap$1;
            private final long operationTimestamp$1;

            public final RemoveFile apply(String absolutePath) {
                AddFile addFile = this.$outer.getTouchedFile(this.deltaLog$1.dataPath(), absolutePath, (Map<String, AddFile>)this.nameToAddFileMap$1);
                return addFile.removeWithTimestamp(this.operationTimestamp$1, addFile.removeWithTimestamp$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deltaLog$1 = deltaLog$1;
                this.nameToAddFileMap$1 = nameToAddFileMap$1;
                this.operationTimestamp$1 = operationTimestamp$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static HadoopFsRelation buildBaseRelation(DeltaCommand $this, SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq inputLeafFiles, Map nameToAddFileMap) {
        DeltaLog deltaLog = txn.deltaLog();
        Seq scannedFiles = (Seq)inputLeafFiles.map((Function1)new Serializable($this, rootPath, nameToAddFileMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaCommand $outer;
            private final Path rootPath$1;
            private final Map nameToAddFileMap$2;

            public final AddFile apply(String f) {
                return this.$outer.getTouchedFile(this.rootPath$1, f, (Map<String, AddFile>)this.nameToAddFileMap$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rootPath$1 = rootPath$1;
                this.nameToAddFileMap$2 = nameToAddFileMap$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        TahoeBatchFileIndex fileIndex = new TahoeBatchFileIndex(spark, actionType, (Seq<AddFile>)scannedFiles, deltaLog, rootPath, txn.snapshot());
        return new HadoopFsRelation((FileIndex)fileIndex, txn.metadata().partitionSchema(), txn.metadata().schema(), (Option)None$.MODULE$, deltaLog.snapshot().fileFormat(), txn.metadata().format().options(), spark);
    }

    public static AddFile getTouchedFile(DeltaCommand $this, Path basePath, String filePath, Map nameToAddFileMap) {
        String absolutePath = DeltaFileOperations$.MODULE$.absolutePath(basePath.toUri().toString(), filePath).toString();
        return (AddFile)nameToAddFileMap.getOrElse((Object)absolutePath, (Function0)new Serializable($this, absolutePath, nameToAddFileMap){
            public static final long serialVersionUID = 0L;
            private final String absolutePath$1;
            private final Map nameToAddFileMap$3;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File (", ") to be rewritten not found "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.absolutePath$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"among candidate files:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nameToAddFileMap$3.keys().mkString("\n")}))).toString());
            }
            {
                this.absolutePath$1 = absolutePath$1;
                this.nameToAddFileMap$3 = nameToAddFileMap$3;
            }
        });
    }

    public static void $init$(DeltaCommand $this) {
    }
}

