/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.schema;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.MetadataMismatchErrorBuilder;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Metadata$;
import org.apache.spark.sql.delta.schema.ImplicitMetadataOperation;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public abstract class ImplicitMetadataOperation$class {
    private static Seq normalizePartitionColumns(ImplicitMetadataOperation $this, SparkSession spark, Seq partitionCols, StructType schema2) {
        return (Seq)partitionCols.map((Function1)new Serializable($this, schema2){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final String apply(String columnName) {
                Seq colMatches = (Seq)this.schema$1.filter((Function1)new Serializable(this, columnName){
                    public static final long serialVersionUID = 0L;
                    private final String columnName$1;

                    public final boolean apply(StructField s) {
                        return BoxesRunTime.unboxToBoolean((Object)SchemaUtils$.MODULE$.DELTA_COL_RESOLVER().apply((Object)s.name(), (Object)this.columnName$1));
                    }
                    {
                        this.columnName$1 = columnName$1;
                    }
                });
                if (colMatches.length() > 1) {
                    throw DeltaErrors$.MODULE$.ambiguousPartitionColumnException(columnName, (Seq<StructField>)colMatches);
                }
                if (colMatches.isEmpty()) {
                    throw DeltaErrors$.MODULE$.partitionColumnNotFoundException(columnName, (Seq<Attribute>)this.schema$1.toAttributes());
                }
                return ((StructField)colMatches.head()).name();
            }
            {
                this.schema$1 = schema$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final void updateMetadata(ImplicitMetadataOperation $this, OptimisticTransaction txn, Dataset data, Seq partitionColumns, Map configuration, boolean isOverwriteMode) {
        StructType dataSchema2 = data.schema().asNullable();
        StructType mergedSchema = isOverwriteMode && $this.canOverwriteSchema() ? dataSchema2 : SchemaUtils$.MODULE$.mergeSchemas(txn.metadata().schema(), dataSchema2);
        Seq normalizedPartitionCols = ImplicitMetadataOperation$class.normalizePartitionColumns($this, data.sparkSession(), partitionColumns, dataSchema2);
        PartitionUtils$.MODULE$.validatePartitionColumn(mergedSchema, (Seq<String>)normalizedPartitionCols, false);
        if (txn.readVersion() == -1L) {
            if (dataSchema2.isEmpty()) {
                throw DeltaErrors$.MODULE$.emptyDataException();
            }
            $this.recordDeltaEvent(txn.deltaLog(), "delta.ddl.initializeSchema", $this.recordDeltaEvent$default$3(), $this.recordDeltaEvent$default$4());
            String x$1 = dataSchema2.json();
            Seq x$2 = normalizedPartitionCols;
            Map x$3 = configuration;
            String x$4 = Metadata$.MODULE$.apply$default$1();
            String x$5 = Metadata$.MODULE$.apply$default$2();
            String x$6 = Metadata$.MODULE$.apply$default$3();
            Format x$7 = Metadata$.MODULE$.apply$default$4();
            Option<Object> x$8 = Metadata$.MODULE$.apply$default$8();
            txn.updateMetadata(new Metadata(x$4, x$5, x$6, x$7, x$1, (Seq<String>)x$2, (Map<String, String>)x$3, x$8));
        } else if (isOverwriteMode && $this.canOverwriteSchema() && (ImplicitMetadataOperation$class.isNewSchema$1($this, mergedSchema, txn) || ImplicitMetadataOperation$class.isNewPartitioning$1($this, normalizedPartitionCols, txn))) {
            Metadata qual$1 = txn.metadata();
            String x$9 = dataSchema2.json();
            Seq x$10 = normalizedPartitionCols;
            String x$11 = qual$1.copy$default$1();
            String x$12 = qual$1.copy$default$2();
            String x$13 = qual$1.copy$default$3();
            Format x$14 = qual$1.copy$default$4();
            Map<String, String> x$15 = qual$1.copy$default$7();
            Option<Object> x$16 = qual$1.copy$default$8();
            Metadata newMetadata = qual$1.copy(x$11, x$12, x$13, x$14, x$9, (Seq<String>)x$10, x$15, x$16);
            $this.recordDeltaEvent(txn.deltaLog(), "delta.ddl.overwriteSchema", $this.recordDeltaEvent$default$3(), $this.recordDeltaEvent$default$4());
            txn.updateMetadata(newMetadata);
        } else if (ImplicitMetadataOperation$class.isNewSchema$1($this, mergedSchema, txn) && $this.canMergeSchema() && !ImplicitMetadataOperation$class.isNewPartitioning$1($this, normalizedPartitionCols, txn)) {
            $this.logInfo((Function0)new Serializable($this, mergedSchema){
                public static final long serialVersionUID = 0L;
                private final StructType mergedSchema$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New merged schema: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.mergedSchema$1.treeString()}));
                }
                {
                    this.mergedSchema$1 = mergedSchema$1;
                }
            });
            $this.recordDeltaEvent(txn.deltaLog(), "delta.ddl.mergeSchema", $this.recordDeltaEvent$default$3(), $this.recordDeltaEvent$default$4());
            Metadata qual$2 = txn.metadata();
            String x$17 = mergedSchema.json();
            String x$18 = qual$2.copy$default$1();
            String x$19 = qual$2.copy$default$2();
            String x$20 = qual$2.copy$default$3();
            Format x$21 = qual$2.copy$default$4();
            Seq<String> x$22 = qual$2.copy$default$6();
            Map<String, String> x$23 = qual$2.copy$default$7();
            Option<Object> x$24 = qual$2.copy$default$8();
            txn.updateMetadata(qual$2.copy(x$18, x$19, x$20, x$21, x$17, x$22, x$23, x$24));
        } else if (ImplicitMetadataOperation$class.isNewSchema$1($this, mergedSchema, txn) || ImplicitMetadataOperation$class.isNewPartitioning$1($this, normalizedPartitionCols, txn)) {
            $this.recordDeltaEvent(txn.deltaLog(), "delta.schemaValidation.failure", $this.recordDeltaEvent$default$3(), $this.recordDeltaEvent$default$4());
            MetadataMismatchErrorBuilder errorBuilder = new MetadataMismatchErrorBuilder();
            if (ImplicitMetadataOperation$class.isNewSchema$1($this, mergedSchema, txn)) {
                errorBuilder.addSchemaMismatch(txn.metadata().schema(), dataSchema2);
            }
            if (ImplicitMetadataOperation$class.isNewPartitioning$1($this, normalizedPartitionCols, txn)) {
                errorBuilder.addPartitioningMismatch(txn.metadata().partitionColumns(), (Seq<String>)normalizedPartitionCols);
            }
            if (isOverwriteMode) {
                errorBuilder.addOverwriteBit();
            }
            errorBuilder.finalizeAndThrow();
        }
    }

    private static final boolean isNewSchema$1(ImplicitMetadataOperation $this, StructType mergedSchema$1, OptimisticTransaction txn$1) {
        StructType structType = txn$1.metadata().schema();
        StructType structType2 = mergedSchema$1;
        return structType != null ? !structType.equals(structType2) : structType2 != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNewPartitioning$1(ImplicitMetadataOperation $this, Seq normalizedPartitionCols$1, OptimisticTransaction txn$1) {
        if (!normalizedPartitionCols$1.nonEmpty()) return false;
        Seq<String> seq = txn$1.metadata().partitionColumns();
        Seq seq2 = normalizedPartitionCols$1;
        if (seq == null) {
            if (seq2 == null) return false;
            return true;
        } else if (seq.equals((Object)seq2)) return false;
        return true;
    }

    public static void $init$(ImplicitMetadataOperation $this) {
    }
}

