/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.schema;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.schema.SchemaUtils$$anonfun$org$apache$spark$sql$delta$schema$SchemaUtils$;
import org.apache.spark.sql.delta.schema.SchemaUtils$$anonfun$transformColumns$1$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$;
    private final Function2<String, String, Object> DELTA_COL_RESOLVER;

    static {
        new SchemaUtils$();
    }

    public Function2<String, String, Object> DELTA_COL_RESOLVER() {
        return this.DELTA_COL_RESOLVER;
    }

    public Seq<Tuple2<Seq<String>, StructField>> filterRecursively(StructType schema2, boolean checkComplexTypes, Function1<StructField, Object> f) {
        return this.org$apache$spark$sql$delta$schema$SchemaUtils$$recurseIntoComplexTypes$1((DataType)schema2, (Seq)Nil$.MODULE$, checkComplexTypes, f);
    }

    public boolean typeExistsRecursively(DataType dt, Function1<DataType, Object> f) {
        boolean bl;
        block5: {
            DataType dataType;
            while (true) {
                if ((dataType = dt) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    bl = BoxesRunTime.unboxToBoolean((Object)f.apply((Object)structType)) || Predef$.MODULE$.refArrayOps((Object[])structType.fields()).exists((Function1)new Serializable(f){
                        public static final long serialVersionUID = 0L;
                        private final Function1 f$2;

                        public final boolean apply(StructField field) {
                            return SchemaUtils$.MODULE$.typeExistsRecursively(field.dataType(), (Function1<DataType, Object>)this.f$2);
                        }
                        {
                            this.f$2 = f$2;
                        }
                    });
                    break block5;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    if (BoxesRunTime.unboxToBoolean((Object)f.apply((Object)arrayType))) {
                        bl = true;
                        break block5;
                    }
                    dt = arrayType.elementType();
                    continue;
                }
                if (!(dataType instanceof MapType)) break;
                MapType mapType = (MapType)dataType;
                if (BoxesRunTime.unboxToBoolean((Object)f.apply((Object)mapType)) || this.typeExistsRecursively(mapType.keyType(), f)) {
                    bl = true;
                    break block5;
                }
                dt = mapType.valueType();
            }
            bl = BoxesRunTime.unboxToBoolean((Object)f.apply((Object)dataType));
        }
        return bl;
    }

    public Dataset<Row> dropNullTypeColumns(Dataset<Row> df) {
        StructType schema2 = df.schema();
        if (this.typeExistsRecursively((DataType)schema2, (Function1<DataType, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DataType x$1) {
                return x$1 instanceof NullType;
            }
        })) {
            Seq selectExprs = (Seq)schema2.flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<Column> apply(StructField f) {
                    return f.dataType() instanceof NullType ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$generateSelectExpr$1(f, (Seq)Nil$.MODULE$)));
                }
            }, Seq$.MODULE$.canBuildFrom());
            return df.select(selectExprs);
        }
        return df;
    }

    public Seq<String> explodeNestedFieldNames(StructType schema2) {
        return (Seq)this.org$apache$spark$sql$delta$schema$SchemaUtils$$explode$1(schema2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Seq<String> x$7) {
                return new UnresolvedAttribute(x$7).name();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void checkColumnNameDuplication(StructType schema2, String colType) {
        Seq<String> columnNames = this.explodeNestedFieldNames(schema2);
        Seq names = (Seq)columnNames.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$8) {
                return x$8.toLowerCase();
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (((SeqLike)names.distinct()).length() != names.length()) {
            scala.collection.immutable.Iterable duplicateColumns = (scala.collection.immutable.Iterable)names.groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    return (String)Predef$.MODULE$.identity((Object)x);
                }
            }).collect((PartialFunction)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            object = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x}));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                    Seq ys;
                    Tuple2<String, Seq<String>> tuple2 = x1;
                    boolean bl = tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                    return bl;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found duplicate column(s) ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{colType, duplicateColumns.mkString(", ")})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public Dataset<Row> normalizeColumnNames(StructType baseSchema, Dataset<?> data) {
        Dataset dataset;
        scala.collection.immutable.Set tableFields;
        StructType dataSchema2 = data.schema();
        scala.collection.immutable.Set dataFields = this.explodeNestedFieldNames(dataSchema2).toSet();
        if (dataFields.subsetOf((GenSet)(tableFields = this.explodeNestedFieldNames(baseSchema).toSet()))) {
            dataset = data.toDF();
        } else {
            scala.collection.immutable.Set topLevelDataFields = (scala.collection.immutable.Set)dataFields.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$9) {
                    return (String)UnresolvedAttribute$.MODULE$.parseAttributeName(x$9).head();
                }
            }, Set$.MODULE$.canBuildFrom());
            if (topLevelDataFields.subsetOf((GenSet)tableFields)) {
                scala.collection.immutable.Set columnsThatNeedRenaming = (scala.collection.immutable.Set)dataFields.$minus$minus((GenTraversableOnce)tableFields);
                throw new AnalysisException(new StringBuilder().append((Object)"Nested fields need renaming to avoid data loss. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fields:\\n", ".\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnsThatNeedRenaming.mkString("[", ", ", "]")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Original schema:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseSchema.treeString()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            Map<String, StructField> baseFields = this.toFieldMap((Seq<StructField>)baseSchema);
            Seq aliasExpressions = (Seq)dataSchema2.map((Function1)new Serializable(baseSchema, baseFields){
                public static final long serialVersionUID = 0L;
                public final StructType baseSchema$1;
                private final Map baseFields$1;

                public final Column apply(StructField field) {
                    StructField originalCase = (StructField)this.baseFields$1.get((Object)field.name()).getOrElse((Function0)new Serializable(this, field){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.7 $outer;
                        private final StructField field$1;

                        public final Nothing$ apply() {
                            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't resolve column ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.field$1.name(), this.$outer.baseSchema$1.treeString()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.field$1 = field$1;
                        }
                    });
                    String string = originalCase.name();
                    String string2 = field.name();
                    return !(string != null ? !string.equals(string2) : string2 != null) ? functions$.MODULE$.col(field.name()) : functions$.MODULE$.col(field.name()).as(originalCase.name());
                }
                {
                    this.baseSchema$1 = baseSchema$1;
                    this.baseFields$1 = baseFields$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            dataset = data.select(aliasExpressions);
        }
        return dataset;
    }

    public boolean isReadCompatible(StructType existingSchema, StructType readSchema) {
        Map<String, StructField> existing = this.toFieldMap((Seq<StructField>)existingSchema);
        scala.collection.immutable.Set existingFieldNames = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])existingSchema.fieldNames()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$10) {
                return x$10.toLowerCase();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        Predef$.MODULE$.assert(existingFieldNames.size() == existingSchema.length(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Delta tables don't allow field names that only differ by case";
            }
        });
        scala.collection.immutable.Set newFields = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])readSchema.fieldNames()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$11) {
                return x$11.toLowerCase();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        Predef$.MODULE$.assert(newFields.size() == readSchema.length(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Delta tables don't allow field names that only differ by case";
            }
        });
        if (existingFieldNames.subsetOf((GenSet)newFields)) {
            return readSchema.forall((Function1)new Serializable(existing){
                public static final long serialVersionUID = 0L;
                private final Map existing$1;

                public final boolean apply(StructField newField) {
                    Option option;
                    block8: {
                        boolean bl;
                        block7: {
                            block2: {
                                Tuple2 tuple2;
                                block6: {
                                    boolean bl2;
                                    boolean nullabilityConstraintMet;
                                    block4: {
                                        block5: {
                                            ArrayType arrayType;
                                            DataType n;
                                            ArrayType arrayType2;
                                            DataType e;
                                            block3: {
                                                option = this.existing$1.get((Object)newField.name());
                                                if (!(option instanceof Some)) break block2;
                                                Some some = (Some)option;
                                                StructField existingField = (StructField)some.x();
                                                nullabilityConstraintMet = existingField.nullable() ? true : !newField.nullable();
                                                tuple2 = new Tuple2((Object)existingField.dataType(), (Object)newField.dataType());
                                                if (tuple2 == null) break block3;
                                                DataType e2 = (DataType)tuple2._1();
                                                DataType n2 = (DataType)tuple2._2();
                                                if (!(e2 instanceof StructType)) break block3;
                                                StructType structType = (StructType)e2;
                                                if (!(n2 instanceof StructType)) break block3;
                                                StructType structType2 = (StructType)n2;
                                                bl2 = SchemaUtils$.MODULE$.isReadCompatible(structType, structType2);
                                                break block4;
                                            }
                                            if (tuple2 == null) break block5;
                                            DataType dataType = (DataType)tuple2._1();
                                            DataType dataType2 = (DataType)tuple2._2();
                                            if (!(dataType instanceof ArrayType) || !((e = (arrayType2 = (ArrayType)dataType).elementType()) instanceof StructType)) break block5;
                                            StructType structType = (StructType)e;
                                            if (!(dataType2 instanceof ArrayType) || !((n = (arrayType = (ArrayType)dataType2).elementType()) instanceof StructType)) break block5;
                                            StructType structType3 = (StructType)n;
                                            bl2 = SchemaUtils$.MODULE$.isReadCompatible(structType, structType3);
                                            break block4;
                                        }
                                        if (tuple2 == null) break block6;
                                        DataType a = (DataType)tuple2._1();
                                        DataType b = (DataType)tuple2._2();
                                        DataType dataType = a;
                                        DataType dataType3 = b;
                                        bl2 = !(dataType != null ? !dataType.equals(dataType3) : dataType3 != null);
                                    }
                                    boolean dataTypeMatched = bl2;
                                    bl = dataTypeMatched && nullabilityConstraintMet;
                                    break block7;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                            if (!None$.MODULE$.equals(option)) break block8;
                            bl = true;
                        }
                        return bl;
                    }
                    throw new MatchError((Object)option);
                }
                {
                    this.existing$1 = existing$1;
                }
            });
        }
        return false;
    }

    public Tuple2<Seq<Object>, Object> findColumnPosition(Seq<String> column, StructType schema2, Function2<String, String, Object> resolver) {
        try {
            return this.find$1(column, schema2, (Seq)Nil$.MODULE$, resolver);
        }
        catch (AnalysisException analysisException) {
            throw new AnalysisException(new StringBuilder().append((Object)analysisException.getMessage()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{":\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema2.treeString()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find column ", " in:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indexOutOfBoundsException.getMessage(), schema2.treeString()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public Function2<String, String, Object> findColumnPosition$default$3() {
        return this.DELTA_COL_RESOLVER();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StructType addColumn(StructType schema2, StructField column, Seq<Object> position) {
        StructType structType;
        Predef$.MODULE$.require(position.nonEmpty(), (Function0)new Serializable(column){
            public static final long serialVersionUID = 0L;
            private final StructField column$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Don't know where to add the column ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.column$1}));
            }
            {
                this.column$1 = column$1;
            }
        });
        int slicePosition = BoxesRunTime.unboxToInt((Object)position.head());
        if (slicePosition < 0) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " to add column ", " is lower than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)slicePosition), column})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        int length = schema2.length();
        if (slicePosition > length) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " to add column ", " is larger than struct length: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)slicePosition), column, BoxesRunTime.boxToInteger((int)length)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (slicePosition == length) {
            if (position.length() <= 1) return StructType$.MODULE$.apply((Seq)schema2.$colon$plus((Object)column, Seq$.MODULE$.canBuildFrom()));
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Struct not found at position ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)slicePosition)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Seq pre = (Seq)schema2.take(slicePosition);
        if (position.length() > 1) {
            StructField structField;
            StructField structField2 = schema2.apply(slicePosition);
            if (structField2 == null) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can only add nested columns to StructType. Found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{structField2})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            String name = structField2.name();
            DataType f = structField2.dataType();
            boolean nullable = structField2.nullable();
            Metadata metadata2 = structField2.metadata();
            if (!(f instanceof StructType)) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can only add nested columns to StructType. Found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{structField2})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            StructType structType2 = (StructType)f;
            if (!column.nullable() && nullable) {
                throw new AnalysisException("A non-nullable nested field can't be added to a nullable parent. Please set the nullability of the parent column accordingly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            StructField mid = structField = new StructField(name, (DataType)this.addColumn(structType2, column, (Seq<Object>)((Seq)position.tail())), nullable, metadata2);
            structType = StructType$.MODULE$.apply((Seq)((TraversableLike)pre.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{mid})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)schema2.slice(slicePosition + 1, length), Seq$.MODULE$.canBuildFrom()));
            return structType;
        } else {
            structType = StructType$.MODULE$.apply((Seq)((TraversableLike)pre.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{column})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)schema2.slice(slicePosition, length), Seq$.MODULE$.canBuildFrom()));
        }
        return structType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<StructType, StructField> dropColumn(StructType schema2, Seq<Object> position) {
        Tuple2 tuple2;
        Predef$.MODULE$.require(position.nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Don't know where to drop the column";
            }
        });
        int slicePosition = BoxesRunTime.unboxToInt((Object)position.head());
        if (slicePosition < 0) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " to drop column is lower than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)slicePosition)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        int length = schema2.length();
        if (slicePosition >= length) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " to drop column equals to or is larger than struct length: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)slicePosition), BoxesRunTime.boxToInteger((int)length)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Seq pre = (Seq)schema2.take(slicePosition);
        if (position.length() > 1) {
            Tuple2 tuple22;
            StructField original;
            StructField original2;
            StructField structField = schema2.apply(slicePosition);
            if (structField == null) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can only drop nested columns from StructType. Found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{structField})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            String name = structField.name();
            DataType f = structField.dataType();
            boolean nullable = structField.nullable();
            Metadata metadata2 = structField.metadata();
            if (!(f instanceof StructType)) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can only drop nested columns from StructType. Found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{structField})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            StructType structType = (StructType)f;
            Tuple2<StructType, StructField> tuple23 = this.dropColumn(structType, (Seq<Object>)((Seq)position.tail()));
            if (tuple23 == null) throw new MatchError(tuple23);
            StructType dropped = (StructType)tuple23._1();
            Tuple2 tuple24 = new Tuple2((Object)dropped, (Object)(original2 = (StructField)tuple23._2()));
            Tuple2 tuple25 = tuple24;
            StructType dropped2 = (StructType)tuple25._1();
            Tuple2 tuple26 = new Tuple2((Object)new StructField(name, (DataType)dropped2, nullable, metadata2), (Object)(original = (StructField)tuple25._2()));
            Tuple2 tuple27 = tuple26;
            if (tuple27 == null) throw new MatchError((Object)tuple27);
            StructField mid = (StructField)tuple27._1();
            StructField original3 = (StructField)tuple27._2();
            Tuple2 tuple28 = tuple22 = new Tuple2((Object)mid, (Object)original3);
            StructField mid2 = (StructField)tuple28._1();
            StructField original4 = (StructField)tuple28._2();
            tuple2 = new Tuple2((Object)StructType$.MODULE$.apply((Seq)((TraversableLike)pre.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{mid2})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)schema2.slice(slicePosition + 1, length), Seq$.MODULE$.canBuildFrom())), (Object)original4);
            return tuple2;
        } else {
            tuple2 = new Tuple2((Object)StructType$.MODULE$.apply((Seq)pre.$plus$plus((GenTraversableOnce)schema2.slice(slicePosition + 1, length), Seq$.MODULE$.canBuildFrom())), (Object)schema2.apply(slicePosition));
        }
        return tuple2;
    }

    public Option<String> canChangeDataType(DataType from, DataType to, Function2<String, String, Object> resolver, Seq<String> columnPath) {
        Some some;
        try {
            this.org$apache$spark$sql$delta$schema$SchemaUtils$$check$1(from, to, columnPath, resolver);
            some = None$.MODULE$;
        }
        catch (AnalysisException analysisException) {
            some = new Some((Object)analysisException.message());
        }
        return some;
    }

    public Seq<String> canChangeDataType$default$4() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public DataType changeDataType(DataType from, DataType to, Function2<String, String, Object> resolver) {
        Tuple2 tuple2;
        block6: {
            DataType dataType;
            block3: {
                DataType toDataType;
                block5: {
                    block4: {
                        block2: {
                            tuple2 = new Tuple2((Object)from, (Object)to);
                            if (tuple2 == null) break block2;
                            DataType dataType2 = (DataType)tuple2._1();
                            DataType dataType3 = (DataType)tuple2._2();
                            if (!(dataType2 instanceof ArrayType)) break block2;
                            ArrayType arrayType = (ArrayType)dataType2;
                            DataType fromElement = arrayType.elementType();
                            boolean fn = arrayType.containsNull();
                            if (!(dataType3 instanceof ArrayType)) break block2;
                            ArrayType arrayType2 = (ArrayType)dataType3;
                            DataType toElement = arrayType2.elementType();
                            dataType = new ArrayType(this.changeDataType(fromElement, toElement, resolver), fn);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        DataType dataType4 = (DataType)tuple2._1();
                        DataType dataType5 = (DataType)tuple2._2();
                        if (!(dataType4 instanceof MapType)) break block4;
                        MapType mapType = (MapType)dataType4;
                        DataType fromKey = mapType.keyType();
                        DataType fromValue = mapType.valueType();
                        boolean fn = mapType.valueContainsNull();
                        if (!(dataType5 instanceof MapType)) break block4;
                        MapType mapType2 = (MapType)dataType5;
                        DataType toKey = mapType2.keyType();
                        DataType toValue = mapType2.valueType();
                        dataType = new MapType(this.changeDataType(fromKey, toKey, resolver), this.changeDataType(fromValue, toValue, resolver), fn);
                        break block3;
                    }
                    if (tuple2 == null) break block5;
                    DataType dataType6 = (DataType)tuple2._1();
                    DataType dataType7 = (DataType)tuple2._2();
                    if (!(dataType6 instanceof StructType)) break block5;
                    StructType structType = (StructType)dataType6;
                    StructField[] fromFields = structType.fields();
                    if (!(dataType7 instanceof StructType)) break block5;
                    StructType structType2 = (StructType)dataType7;
                    StructField[] toFields = structType2.fields();
                    dataType = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])toFields).map((Function1)new Serializable(resolver, fromFields){
                        public static final long serialVersionUID = 0L;
                        public final Function2 resolver$3;
                        private final StructField[] fromFields$2;

                        public final StructField apply(StructField toField) {
                            return (StructField)Predef$.MODULE$.refArrayOps((Object[])this.fromFields$2).find((Function1)new Serializable(this, toField){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.changeDataType.1 $outer;
                                private final StructField toField$2;

                                public final boolean apply(StructField field) {
                                    return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$3.apply((Object)field.name(), (Object)this.toField$2.name()));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.toField$2 = toField$2;
                                }
                            }).map((Function1)new Serializable(this, toField){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.changeDataType.1 $outer;
                                private final StructField toField$2;

                                public final StructField apply(StructField fromField) {
                                    StructField qual$1 = (StructField)this.toField$2.getComment().map((Function1)new Serializable(this, fromField){
                                        public static final long serialVersionUID = 0L;
                                        private final StructField fromField$1;

                                        public final StructField apply(String comment) {
                                            return this.fromField$1.withComment(comment);
                                        }
                                        {
                                            this.fromField$1 = fromField$1;
                                        }
                                    }).getOrElse((Function0)new Serializable(this, fromField){
                                        public static final long serialVersionUID = 0L;
                                        private final StructField fromField$1;

                                        public final StructField apply() {
                                            return this.fromField$1;
                                        }
                                        {
                                            this.fromField$1 = fromField$1;
                                        }
                                    });
                                    DataType x$21 = SchemaUtils$.MODULE$.changeDataType(fromField.dataType(), this.toField$2.dataType(), (Function2<String, String, Object>)this.$outer.resolver$3);
                                    boolean x$22 = this.toField$2.nullable();
                                    String x$23 = qual$1.copy$default$1();
                                    Metadata x$24 = qual$1.copy$default$4();
                                    return qual$1.copy(x$23, x$21, x$22, x$24);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.toField$2 = toField$2;
                                }
                            }).getOrElse((Function0)new Serializable(this, toField){
                                public static final long serialVersionUID = 0L;
                                private final StructField toField$2;

                                public final StructField apply() {
                                    return this.toField$2;
                                }
                                {
                                    this.toField$2 = toField$2;
                                }
                            });
                        }
                        {
                            this.resolver$3 = resolver$3;
                            this.fromFields$2 = fromFields$2;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                    break block3;
                }
                if (tuple2 == null) break block6;
                dataType = toDataType = (DataType)tuple2._2();
            }
            return dataType;
        }
        throw new MatchError((Object)tuple2);
    }

    public StructType mergeSchemas(StructType tableSchema, StructType dataSchema2) {
        this.checkColumnNameDuplication(dataSchema2, "in the data to save");
        return (StructType)this.org$apache$spark$sql$delta$schema$SchemaUtils$$merge$1((DataType)tableSchema, (DataType)dataSchema2);
    }

    private Map<String, StructField> toFieldMap(Seq<StructField> fields) {
        return CaseInsensitiveMap$.MODULE$.apply(((TraversableOnce)fields.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, StructField> apply(StructField field) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)field);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public StructType transformColumns(StructType schema2, Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField> tf) {
        return (StructType)this.org$apache$spark$sql$delta$schema$SchemaUtils$$transform$1((Seq)Seq$.MODULE$.empty(), (DataType)schema2, tf);
    }

    public <E> StructType transformColumns(StructType schema2, Seq<Tuple2<Seq<String>, E>> input, Function3<Seq<String>, StructField, Seq<Tuple2<Seq<String>, E>>, StructField> tf) {
        Map inputLookup = input.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<Seq<String>, E> x$16) {
                return (Seq)((TraversableLike)x$16._1()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$17) {
                        return x$17.toLowerCase();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        });
        return this.transformColumns(schema2, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)new Serializable(tf, inputLookup){
            public static final long serialVersionUID = 0L;
            private final Function3 tf$2;
            private final Map inputLookup$1;

            public final StructField apply(Seq<String> path, StructField field, Function2<String, String, Object> resolver) {
                Seq fullPath = (Seq)path.$colon$plus((Object)field.name(), Seq$.MODULE$.canBuildFrom());
                Seq normalizedFullPath = (Seq)fullPath.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$18) {
                        return x$18.toLowerCase();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq matches = (Seq)Option$.MODULE$.option2Iterable(this.inputLookup$1.get((Object)normalizedFullPath)).toSeq().flatMap((Function1)new Serializable(this, fullPath, resolver){
                    public static final long serialVersionUID = 0L;
                    public final Seq fullPath$1;
                    public final Function2 resolver$4;

                    public final Seq<Tuple2<Seq<String>, E>> apply(Seq<Tuple2<Seq<String>, E>> x$19) {
                        return (Seq)x$19.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$transformColumns$1$$anonfun$20 $outer;

                            public final boolean apply(Tuple2<Seq<String>, E> x$20) {
                                return ((IterableLike)((IterableLike)x$20._1()).zip((GenIterable)this.$outer.fullPath$1, Seq$.MODULE$.canBuildFrom())).forall(this.$outer.resolver$4.tupled());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.fullPath$1 = fullPath$1;
                        this.resolver$4 = resolver$4;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return matches.nonEmpty() ? (StructField)this.tf$2.apply(path, (Object)field, (Object)matches) : field;
            }
            {
                this.tf$2 = tf$2;
                this.inputLookup$1 = inputLookup$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Seq org$apache$spark$sql$delta$schema$SchemaUtils$$recurseIntoComplexTypes$1(DataType complexType, Seq columnStack, boolean checkComplexTypes$1, Function1 f$1) {
        DataType dataType;
        while (true) {
            if ((dataType = complexType) instanceof StructType) {
                StructType structType = (StructType)dataType;
                return (Seq)Predef$.MODULE$.refArrayOps((Object[])structType.fields()).flatMap((Function1)new Serializable(checkComplexTypes$1, f$1, columnStack){
                    public static final long serialVersionUID = 0L;
                    private final boolean checkComplexTypes$1;
                    private final Function1 f$1;
                    private final Seq columnStack$1;

                    public final Seq<Tuple2<Seq<String>, StructField>> apply(StructField sf) {
                        Nil$ includeLevel = BoxesRunTime.unboxToBoolean((Object)this.f$1.apply((Object)sf)) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.columnStack$1, (Object)sf)})) : Nil$.MODULE$;
                        return (Seq)includeLevel.$plus$plus((GenTraversableOnce)SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$recurseIntoComplexTypes$1(sf.dataType(), (Seq)this.columnStack$1.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom()), this.checkComplexTypes$1, this.f$1), Seq$.MODULE$.canBuildFrom());
                    }
                    {
                        this.checkComplexTypes$1 = checkComplexTypes$1;
                        this.f$1 = f$1;
                        this.columnStack$1 = columnStack$1;
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            if (!checkComplexTypes$1) break;
            complexType = arrayType.elementType();
        }
        if (!(dataType instanceof MapType)) return Nil$.MODULE$;
        MapType mapType = (MapType)dataType;
        if (!checkComplexTypes$1) return Nil$.MODULE$;
        return (Seq)this.org$apache$spark$sql$delta$schema$SchemaUtils$$recurseIntoComplexTypes$1(mapType.keyType(), (Seq)columnStack.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), checkComplexTypes$1, f$1).$plus$plus((GenTraversableOnce)this.org$apache$spark$sql$delta$schema$SchemaUtils$$recurseIntoComplexTypes$1(mapType.valueType(), (Seq)columnStack.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom()), checkComplexTypes$1, f$1), Seq$.MODULE$.canBuildFrom());
    }

    public final Column org$apache$spark$sql$delta$schema$SchemaUtils$$generateSelectExpr$1(StructField sf, Seq nameStack) {
        Column column;
        DataType dataType = sf.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Column[] nested = (Column[])Predef$.MODULE$.refArrayOps((Object[])structType.fields()).flatMap((Function1)new Serializable(sf, nameStack){
                public static final long serialVersionUID = 0L;
                private final StructField sf$1;
                private final Seq nameStack$1;

                public final Iterable<Column> apply(StructField f) {
                    return f.dataType() instanceof NullType ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$generateSelectExpr$1(f, (Seq)this.nameStack$1.$colon$plus((Object)this.sf$1.name(), Seq$.MODULE$.canBuildFrom()))));
                }
                {
                    this.sf$1 = sf$1;
                    this.nameStack$1 = nameStack$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            column = functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])nested)).alias(sf.name());
        } else {
            MapType mapType;
            ArrayType arrayType;
            if (dataType instanceof ArrayType && this.typeExistsRecursively((DataType)(arrayType = (ArrayType)dataType), (Function1<DataType, Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(DataType x$2) {
                    return x$2 instanceof NullType;
                }
            })) {
                String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom())).name();
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found nested NullType in column ", " which is of ArrayType. Delta doesn't "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{colName}))).append((Object)"support writing NullType in complex types.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            if (dataType instanceof MapType && this.typeExistsRecursively((DataType)(mapType = (MapType)dataType), (Function1<DataType, Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(DataType x$3) {
                    return x$3 instanceof NullType;
                }
            })) {
                String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom())).name();
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found nested NullType in column ", " which is of MapType. Delta doesn't "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{colName}))).append((Object)"support writing NullType in complex types.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom())).name();
            column = functions$.MODULE$.col(colName).alias(sf.name());
        }
        return column;
    }

    public final Seq org$apache$spark$sql$delta$schema$SchemaUtils$$recurseIntoComplexTypes$2(DataType complexType) {
        Seq seq;
        block4: {
            DataType dataType;
            while (true) {
                if ((dataType = complexType) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    seq = this.org$apache$spark$sql$delta$schema$SchemaUtils$$explode$1(structType);
                    break block4;
                }
                if (!(dataType instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType;
                complexType = arrayType.elementType();
            }
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                seq = (Seq)((TraversableLike)this.org$apache$spark$sql$delta$schema$SchemaUtils$$recurseIntoComplexTypes$2(mapType.keyType()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(Seq<String> x$4) {
                        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))).$plus$plus(x$4, Seq$.MODULE$.canBuildFrom());
                    }
                }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.org$apache$spark$sql$delta$schema$SchemaUtils$$recurseIntoComplexTypes$2(mapType.valueType()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(Seq<String> x$5) {
                        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$plus$plus(x$5, Seq$.MODULE$.canBuildFrom());
                    }
                }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            } else {
                seq = Nil$.MODULE$;
            }
        }
        return seq;
    }

    public final Seq org$apache$spark$sql$delta$schema$SchemaUtils$$explode$1(StructType schema2) {
        return (Seq)schema2.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Seq<Seq<String>> apply(StructField x0$1) {
                StructField structField = x0$1;
                if (structField != null) {
                    String name = structField.name();
                    DataType s = structField.dataType();
                    if (s instanceof StructType) {
                        StructType structType = (StructType)s;
                        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))}))).$plus$plus((GenTraversableOnce)SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$explode$1(structType).map((Function1)new Serializable(this, name){
                            public static final long serialVersionUID = 0L;
                            private final String name$1;

                            public final Seq<String> apply(Seq<String> nested) {
                                return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.name$1}))).$plus$plus(nested, Seq$.MODULE$.canBuildFrom());
                            }
                            {
                                this.name$1 = name$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    }
                }
                if (structField != null) {
                    String name = structField.name();
                    DataType a = structField.dataType();
                    if (a instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)a;
                        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))}))).$plus$plus((GenTraversableOnce)SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$recurseIntoComplexTypes$2((DataType)arrayType).map((Function1)new Serializable(this, name){
                            public static final long serialVersionUID = 0L;
                            private final String name$2;

                            public final Seq<String> apply(Seq<String> nested) {
                                return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.name$2}))).$plus$plus(nested, Seq$.MODULE$.canBuildFrom());
                            }
                            {
                                this.name$2 = name$2;
                            }
                        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    }
                }
                if (structField != null) {
                    String name = structField.name();
                    DataType m = structField.dataType();
                    if (m instanceof MapType) {
                        MapType mapType = (MapType)m;
                        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))}))).$plus$plus((GenTraversableOnce)SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$recurseIntoComplexTypes$2((DataType)mapType).map((Function1)new Serializable(this, name){
                            public static final long serialVersionUID = 0L;
                            private final String name$3;

                            public final Seq<String> apply(Seq<String> nested) {
                                return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.name$3}))).$plus$plus(nested, Seq$.MODULE$.canBuildFrom());
                            }
                            {
                                this.name$3 = name$3;
                            }
                        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    }
                }
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{structField.name()}));
                return Nil$.MODULE$.$colon$colon((Object)seq);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final String columnPath$lzycompute$1(Seq stack$1, String thisCol$1, ObjectRef columnPath$lzy$1, VolatileByteRef bitmap$0$1) {
        SchemaUtils$ schemaUtils$ = this;
        synchronized (schemaUtils$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                columnPath$lzy$1.elem = new UnresolvedAttribute((Seq)stack$1.$colon$plus((Object)thisCol$1, Seq$.MODULE$.canBuildFrom())).name();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)columnPath$lzy$1.elem;
        }
    }

    private final String columnPath$1(Seq stack$1, String thisCol$1, ObjectRef columnPath$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.columnPath$lzycompute$1(stack$1, thisCol$1, columnPath$lzy$1, bitmap$0$1) : (String)columnPath$lzy$1.elem;
    }

    private final Tuple2 find$1(Seq column, StructType schema2, Seq stack, Function2 resolver$1) {
        ArrayType arrayType;
        DataType s;
        Tuple2 tuple2;
        ObjectRef columnPath$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        if (column.isEmpty()) {
            return new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)schema2.size()));
        }
        String thisCol = (String)column.head();
        int pos = schema2.indexWhere((Function1)new Serializable(resolver$1, thisCol){
            public static final long serialVersionUID = 0L;
            private final Function2 resolver$1;
            private final String thisCol$1;

            public final boolean apply(StructField f) {
                return BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)f.name(), (Object)this.thisCol$1));
            }
            {
                this.resolver$1 = resolver$1;
                this.thisCol$1 = thisCol$1;
            }
        });
        if (pos == -1) {
            throw new IndexOutOfBoundsException(this.columnPath$1(stack, thisCol, columnPath$lzy, bitmap$0));
        }
        DataType dataType = schema2.apply(pos).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            tuple2 = this.find$1((Seq)column.tail(), structType, (Seq)stack.$colon$plus((Object)thisCol, Seq$.MODULE$.canBuildFrom()), resolver$1);
        } else if (dataType instanceof ArrayType && (s = (arrayType = (ArrayType)dataType).elementType()) instanceof StructType) {
            StructType structType = (StructType)s;
            tuple2 = this.find$1((Seq)column.tail(), structType, (Seq)stack.$colon$plus((Object)thisCol, Seq$.MODULE$.canBuildFrom()), resolver$1);
        } else {
            if (column.length() > 1) {
                throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be a nested data type, but found ", ". Was looking for the\n                 |index of ", " in a nested field\n              "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnPath$1(stack, thisCol, columnPath$lzy, bitmap$0), dataType, new UnresolvedAttribute(column).name()})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            tuple2 = new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 != null) {
            Tuple2 tuple23;
            Seq children = (Seq)tuple22._1();
            int lastSize = tuple22._2$mcI$sp();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)children, (Object)BoxesRunTime.boxToInteger((int)lastSize));
            Seq children2 = (Seq)tuple24._1();
            int lastSize2 = tuple24._2$mcI$sp();
            return new Tuple2(((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{pos}))).$plus$plus((GenTraversableOnce)children2, Seq$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToInteger((int)lastSize2));
        }
        throw new MatchError((Object)tuple22);
    }

    public final void org$apache$spark$sql$delta$schema$SchemaUtils$$verify$1(boolean cond, Function0 err) {
        if (cond) {
            return;
        }
        throw new AnalysisException((String)err.apply(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public final void org$apache$spark$sql$delta$schema$SchemaUtils$$verifyNullability$1(boolean fn, boolean tn, Seq columnPath) {
        this.org$apache$spark$sql$delta$schema$SchemaUtils$$verify$1(tn || !fn, (Function0)new Serializable(columnPath){
            public static final long serialVersionUID = 0L;
            private final Seq columnPath$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tightening nullability of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UnresolvedAttribute(this.columnPath$2).name()}));
            }
            {
                this.columnPath$2 = columnPath$2;
            }
        });
    }

    public final void org$apache$spark$sql$delta$schema$SchemaUtils$$check$1(DataType fromDt, DataType toDt, Seq columnPath, Function2 resolver$2) {
        Tuple2 tuple2;
        block9: {
            block8: {
                block7: {
                    while (true) {
                        if ((tuple2 = new Tuple2((Object)fromDt, (Object)toDt)) != null) {
                            DataType dataType = (DataType)tuple2._1();
                            DataType dataType2 = (DataType)tuple2._2();
                            if (dataType instanceof ArrayType) {
                                ArrayType arrayType = (ArrayType)dataType;
                                DataType fromElement = arrayType.elementType();
                                boolean fn = arrayType.containsNull();
                                if (dataType2 instanceof ArrayType) {
                                    ArrayType arrayType2 = (ArrayType)dataType2;
                                    DataType toElement = arrayType2.elementType();
                                    boolean tn = arrayType2.containsNull();
                                    this.org$apache$spark$sql$delta$schema$SchemaUtils$$verifyNullability$1(fn, tn, columnPath);
                                    toDt = toElement;
                                    fromDt = fromElement;
                                    continue;
                                }
                            }
                        }
                        if (tuple2 == null) break;
                        DataType dataType = (DataType)tuple2._1();
                        DataType dataType3 = (DataType)tuple2._2();
                        if (!(dataType instanceof MapType)) break;
                        MapType mapType = (MapType)dataType;
                        DataType fromKey = mapType.keyType();
                        DataType fromValue = mapType.valueType();
                        boolean fn = mapType.valueContainsNull();
                        if (!(dataType3 instanceof MapType)) break;
                        MapType mapType2 = (MapType)dataType3;
                        DataType toKey = mapType2.keyType();
                        DataType toValue = mapType2.valueType();
                        boolean tn = mapType2.valueContainsNull();
                        this.org$apache$spark$sql$delta$schema$SchemaUtils$$verifyNullability$1(fn, tn, columnPath);
                        this.org$apache$spark$sql$delta$schema$SchemaUtils$$check$1(fromKey, toKey, (Seq)columnPath.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), resolver$2);
                        columnPath = (Seq)columnPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom());
                        toDt = toValue;
                        fromDt = fromValue;
                    }
                    if (tuple2 == null) break block7;
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType4 = (DataType)tuple2._2();
                    if (!(dataType instanceof StructType)) break block7;
                    StructType structType = (StructType)dataType;
                    StructField[] fromFields = structType.fields();
                    if (!(dataType4 instanceof StructType)) break block7;
                    StructType structType2 = (StructType)dataType4;
                    StructField[] toFields = structType2.fields();
                    Set remainingFields = (Set)Predef$.MODULE$.refArrayOps((Object[])fromFields).to(scala.collection.mutable.Set$.MODULE$.canBuildFrom());
                    Predef$.MODULE$.refArrayOps((Object[])toFields).foreach((Function1)new Serializable(resolver$2, columnPath, fromFields, remainingFields){
                        public static final long serialVersionUID = 0L;
                        public final Function2 resolver$2;
                        public final Seq columnPath$3;
                        private final StructField[] fromFields$1;
                        private final Set remainingFields$1;

                        public final void apply(StructField toField) {
                            Option option;
                            block4: {
                                block3: {
                                    block2: {
                                        option = Predef$.MODULE$.refArrayOps((Object[])this.fromFields$1).find((Function1)new Serializable(this, toField){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$org$apache$spark$sql$delta$schema$SchemaUtils$$check$1$1 $outer;
                                            private final StructField toField$1;

                                            public final boolean apply(StructField field) {
                                                return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$2.apply((Object)field.name(), (Object)this.toField$1.name()));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.toField$1 = toField$1;
                                            }
                                        });
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        StructField fromField = (StructField)some.x();
                                        this.remainingFields$1.$minus$eq((Object)fromField);
                                        Seq newPath = (Seq)this.columnPath$3.$colon$plus((Object)fromField.name(), Seq$.MODULE$.canBuildFrom());
                                        SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$verifyNullability$1(fromField.nullable(), toField.nullable(), newPath);
                                        SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$check$1(fromField.dataType(), toField.dataType(), newPath, this.resolver$2);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block4;
                                    SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$verify$1(toField.nullable(), (Function0)new Serializable(this, toField){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$org$apache$spark$sql$delta$schema$SchemaUtils$$check$1$1 $outer;
                                        private final StructField toField$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"adding non-nullable column ").append((Object)new UnresolvedAttribute((Seq)this.$outer.columnPath$3.$colon$plus((Object)this.toField$1.name(), Seq$.MODULE$.canBuildFrom())).name()).toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.toField$1 = toField$1;
                                        }
                                    });
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                return;
                            }
                            throw new MatchError((Object)option);
                        }
                        {
                            this.resolver$2 = resolver$2;
                            this.columnPath$3 = columnPath$3;
                            this.fromFields$1 = fromFields$1;
                            this.remainingFields$1 = remainingFields$1;
                        }
                    });
                    this.org$apache$spark$sql$delta$schema$SchemaUtils$$verify$1(remainingFields.isEmpty(), (Function0)new Serializable(columnPath, remainingFields){
                        public static final long serialVersionUID = 0L;
                        private final Seq columnPath$3;
                        private final Set remainingFields$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dropping column(s) [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.remainingFields$1.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(StructField x$15) {
                                    return x$15.name();
                                }
                            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(", ")}))).append((Object)(this.columnPath$3.nonEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UnresolvedAttribute(this.columnPath$3).name()})) : "")).toString();
                        }
                        {
                            this.columnPath$3 = columnPath$3;
                            this.remainingFields$1 = remainingFields$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block8;
                }
                if (tuple2 == null) break block9;
                DataType fromDataType = (DataType)tuple2._1();
                DataType toDataType = (DataType)tuple2._2();
                DataType dataType = fromDataType;
                DataType dataType5 = toDataType;
                this.org$apache$spark$sql$delta$schema$SchemaUtils$$verify$1(!(dataType != null ? !dataType.equals(dataType5) : dataType5 != null), (Function0)new Serializable(columnPath, fromDataType, toDataType){
                    public static final long serialVersionUID = 0L;
                    private final Seq columnPath$3;
                    private final DataType fromDataType$1;
                    private final DataType toDataType$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"changing data type of ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UnresolvedAttribute(this.columnPath$3).name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fromDataType$1, this.toDataType$1}))).toString();
                    }
                    {
                        this.columnPath$3 = columnPath$3;
                        this.fromDataType$1 = fromDataType$1;
                        this.toDataType$1 = toDataType$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public final DataType org$apache$spark$sql$delta$schema$SchemaUtils$$merge$1(DataType current, DataType update2) {
        block19: {
            DataType dataType;
            block6: {
                DataType dataType2;
                Tuple2 tuple2;
                block18: {
                    DataType dataType3;
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block9: {
                                                    int rightScale;
                                                    int rightPrecision;
                                                    int leftScale;
                                                    int leftPrecision;
                                                    block10: {
                                                        DecimalType decimalType;
                                                        Option option;
                                                        DecimalType decimalType2;
                                                        Option option2;
                                                        block8: {
                                                            block7: {
                                                                block5: {
                                                                    tuple2 = new Tuple2((Object)current, (Object)update2);
                                                                    if (tuple2 == null) break block5;
                                                                    DataType dataType4 = (DataType)tuple2._1();
                                                                    DataType dataType5 = (DataType)tuple2._2();
                                                                    if (!(dataType4 instanceof StructType)) break block5;
                                                                    StructType structType = (StructType)dataType4;
                                                                    StructField[] currentFields = structType.fields();
                                                                    if (!(dataType5 instanceof StructType)) break block5;
                                                                    StructType structType2 = (StructType)dataType5;
                                                                    StructField[] updateFields = structType2.fields();
                                                                    Map<String, StructField> updateFieldMap = this.toFieldMap((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])updateFields));
                                                                    StructField[] updatedCurrentFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])currentFields).map((Function1)new Serializable(updateFieldMap){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final Map updateFieldMap$1;

                                                                        /*
                                                                         * Enabled aggressive block sorting
                                                                         * Enabled unnecessary exception pruning
                                                                         * Enabled aggressive exception aggregation
                                                                         */
                                                                        public final StructField apply(StructField currentField) {
                                                                            Option option = this.updateFieldMap$1.get((Object)currentField.name());
                                                                            if (!(option instanceof Some)) {
                                                                                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                                                                return currentField;
                                                                            }
                                                                            Some some = (Some)option;
                                                                            StructField updateField = (StructField)some.x();
                                                                            try {
                                                                                return new StructField(currentField.name(), SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$merge$1(currentField.dataType(), updateField.dataType()), currentField.nullable(), currentField.metadata());
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                Throwable throwable2 = throwable;
                                                                                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                                                                                if (option2.isEmpty()) {
                                                                                    throw throwable;
                                                                                }
                                                                                Throwable e = (Throwable)option2.get();
                                                                                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to merge fields '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentField.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and '", "'. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updateField.name()}))).append((Object)e.getMessage()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                                                            }
                                                                        }
                                                                        {
                                                                            this.updateFieldMap$1 = updateFieldMap$1;
                                                                        }
                                                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
                                                                    Map<String, StructField> nameToFieldMap = this.toFieldMap((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])currentFields));
                                                                    StructField[] newFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])updateFields).filterNot((Function1)new Serializable(nameToFieldMap){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final Map nameToFieldMap$1;

                                                                        public final boolean apply(StructField f) {
                                                                            return this.nameToFieldMap$1.contains((Object)f.name());
                                                                        }
                                                                        {
                                                                            this.nameToFieldMap$1 = nameToFieldMap$1;
                                                                        }
                                                                    });
                                                                    dataType = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])updatedCurrentFields).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])newFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                                                                    break block6;
                                                                }
                                                                if (tuple2 == null) break block7;
                                                                DataType dataType6 = (DataType)tuple2._1();
                                                                DataType dataType7 = (DataType)tuple2._2();
                                                                if (!(dataType6 instanceof ArrayType)) break block7;
                                                                ArrayType arrayType = (ArrayType)dataType6;
                                                                DataType currentElementType = arrayType.elementType();
                                                                boolean currentContainsNull = arrayType.containsNull();
                                                                if (!(dataType7 instanceof ArrayType)) break block7;
                                                                ArrayType arrayType2 = (ArrayType)dataType7;
                                                                DataType updateElementType = arrayType2.elementType();
                                                                dataType = new ArrayType(this.org$apache$spark$sql$delta$schema$SchemaUtils$$merge$1(currentElementType, updateElementType), currentContainsNull);
                                                                break block6;
                                                            }
                                                            if (tuple2 == null) break block8;
                                                            DataType dataType8 = (DataType)tuple2._1();
                                                            DataType dataType9 = (DataType)tuple2._2();
                                                            if (!(dataType8 instanceof MapType)) break block8;
                                                            MapType mapType = (MapType)dataType8;
                                                            DataType currentKeyType = mapType.keyType();
                                                            DataType currentElementType = mapType.valueType();
                                                            boolean currentContainsNull = mapType.valueContainsNull();
                                                            if (!(dataType9 instanceof MapType)) break block8;
                                                            MapType mapType2 = (MapType)dataType9;
                                                            DataType updateKeyType = mapType2.keyType();
                                                            DataType updateElementType = mapType2.valueType();
                                                            dataType = new MapType(this.org$apache$spark$sql$delta$schema$SchemaUtils$$merge$1(currentKeyType, updateKeyType), this.org$apache$spark$sql$delta$schema$SchemaUtils$$merge$1(currentElementType, updateElementType), currentContainsNull);
                                                            break block6;
                                                        }
                                                        if (tuple2 == null) break block9;
                                                        DataType dataType10 = (DataType)tuple2._1();
                                                        DataType dataType11 = (DataType)tuple2._2();
                                                        if (!(dataType10 instanceof DecimalType) || (option2 = DecimalType.Fixed$.MODULE$.unapply(decimalType2 = (DecimalType)dataType10)).isEmpty()) break block9;
                                                        leftPrecision = ((Tuple2)option2.get())._1$mcI$sp();
                                                        leftScale = ((Tuple2)option2.get())._2$mcI$sp();
                                                        if (!(dataType11 instanceof DecimalType) || (option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType11)).isEmpty()) break block9;
                                                        rightPrecision = ((Tuple2)option.get())._1$mcI$sp();
                                                        rightScale = ((Tuple2)option.get())._2$mcI$sp();
                                                        if (leftPrecision != rightPrecision || leftScale != rightScale) break block10;
                                                        dataType = current;
                                                        break block6;
                                                    }
                                                    if (leftPrecision != rightPrecision && leftScale != rightScale) {
                                                        throw new AnalysisException(new StringBuilder().append((Object)"Failed to merge decimal types with incompatible ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"precision ", " and ", " & scale ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leftPrecision), BoxesRunTime.boxToInteger((int)rightPrecision), BoxesRunTime.boxToInteger((int)leftScale), BoxesRunTime.boxToInteger((int)rightScale)}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                                    }
                                                    if (leftPrecision != rightPrecision) {
                                                        throw new AnalysisException(new StringBuilder().append((Object)"Failed to merge decimal types with incompatible ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"precision ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leftPrecision), BoxesRunTime.boxToInteger((int)rightPrecision)}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                                    }
                                                    throw new AnalysisException(new StringBuilder().append((Object)"Failed to merge decimal types with incompatible ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scale ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leftScale), BoxesRunTime.boxToInteger((int)rightScale)}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                                }
                                                DataType dataType12 = current;
                                                DataType dataType13 = update2;
                                                if (dataType12 != null ? !dataType12.equals(dataType13) : dataType13 != null) break block11;
                                                dataType = current;
                                                break block6;
                                            }
                                            if (tuple2 == null) break block12;
                                            DataType dataType14 = (DataType)tuple2._1();
                                            DataType dataType15 = (DataType)tuple2._2();
                                            if (!ByteType$.MODULE$.equals(dataType14) || !ShortType$.MODULE$.equals(dataType15)) break block12;
                                            dataType = ShortType$.MODULE$;
                                            break block6;
                                        }
                                        if (tuple2 == null) break block13;
                                        DataType dataType16 = (DataType)tuple2._1();
                                        DataType dataType17 = (DataType)tuple2._2();
                                        if (!ByteType$.MODULE$.equals(dataType16) || !IntegerType$.MODULE$.equals(dataType17)) break block13;
                                        dataType = IntegerType$.MODULE$;
                                        break block6;
                                    }
                                    if (tuple2 == null) break block14;
                                    DataType dataType18 = (DataType)tuple2._1();
                                    DataType dataType19 = (DataType)tuple2._2();
                                    if (!ShortType$.MODULE$.equals(dataType18) || !ByteType$.MODULE$.equals(dataType19)) break block14;
                                    dataType = ShortType$.MODULE$;
                                    break block6;
                                }
                                if (tuple2 == null) break block15;
                                DataType dataType20 = (DataType)tuple2._1();
                                DataType dataType21 = (DataType)tuple2._2();
                                if (!ShortType$.MODULE$.equals(dataType20) || !IntegerType$.MODULE$.equals(dataType21)) break block15;
                                dataType = IntegerType$.MODULE$;
                                break block6;
                            }
                            if (tuple2 == null) break block16;
                            DataType dataType22 = (DataType)tuple2._1();
                            DataType dataType23 = (DataType)tuple2._2();
                            if (!IntegerType$.MODULE$.equals(dataType22) || !ShortType$.MODULE$.equals(dataType23)) break block16;
                            dataType = IntegerType$.MODULE$;
                            break block6;
                        }
                        if (tuple2 == null) break block17;
                        DataType dataType24 = (DataType)tuple2._1();
                        DataType dataType25 = (DataType)tuple2._2();
                        if (!IntegerType$.MODULE$.equals(dataType24) || !ByteType$.MODULE$.equals(dataType25)) break block17;
                        dataType = IntegerType$.MODULE$;
                        break block6;
                    }
                    if (tuple2 == null || !NullType$.MODULE$.equals(dataType3 = (DataType)tuple2._1())) break block18;
                    dataType = update2;
                    break block6;
                }
                if (tuple2 == null || !NullType$.MODULE$.equals(dataType2 = (DataType)tuple2._2())) break block19;
                dataType = current;
            }
            return dataType;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to merge incompatible data types ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{current, update2})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public final DataType org$apache$spark$sql$delta$schema$SchemaUtils$$transform$1(Seq path, DataType dt, Function3 tf$1) {
        DataType dataType;
        DataType dataType2 = dt;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            dataType = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(tf$1, path){
                public static final long serialVersionUID = 0L;
                private final Function3 tf$1;
                private final Seq path$1;

                public final StructField apply(StructField field) {
                    StructField newField = (StructField)this.tf$1.apply((Object)this.path$1, (Object)field, SchemaUtils$.MODULE$.DELTA_COL_RESOLVER());
                    DataType x$25 = SchemaUtils$.MODULE$.org$apache$spark$sql$delta$schema$SchemaUtils$$transform$1((Seq)this.path$1.$colon$plus((Object)newField.name(), Seq$.MODULE$.canBuildFrom()), newField.dataType(), this.tf$1);
                    String x$26 = newField.copy$default$1();
                    boolean x$27 = newField.copy$default$3();
                    Metadata x$28 = newField.copy$default$4();
                    return newField.copy(x$26, x$25, x$27, x$28);
                }
                {
                    this.tf$1 = tf$1;
                    this.path$1 = path$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            dataType = new ArrayType(this.org$apache$spark$sql$delta$schema$SchemaUtils$$transform$1(path, elementType, tf$1), containsNull);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            dataType = new MapType(this.org$apache$spark$sql$delta$schema$SchemaUtils$$transform$1((Seq)path.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), keyType, tf$1), this.org$apache$spark$sql$delta$schema$SchemaUtils$$transform$1((Seq)path.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom()), valueType, tf$1), valueContainsNull);
        } else {
            dataType = dataType2;
        }
        DataType newDt = dataType;
        return newDt;
    }

    private SchemaUtils$() {
        MODULE$ = this;
        this.DELTA_COL_RESOLVER = package$.MODULE$.caseInsensitiveResolution();
    }
}

