/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.delta.DeltaTable$;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.sources.DeltaDataSource;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;

public final class DeltaDataSource$ {
    public static final DeltaDataSource$ MODULE$;
    private final Formats formats;
    private final String TIME_TRAVEL_SOURCE_KEY;
    private final String TIME_TRAVEL_TIMESTAMP_KEY;
    private final String TIME_TRAVEL_VERSION_KEY;

    static {
        new DeltaDataSource$();
    }

    private Formats formats() {
        return this.formats;
    }

    public final String TIME_TRAVEL_SOURCE_KEY() {
        return "__time_travel_source__";
    }

    public final String TIME_TRAVEL_TIMESTAMP_KEY() {
        return "timestampAsOf";
    }

    public final String TIME_TRAVEL_VERSION_KEY() {
        return "versionAsOf";
    }

    public String encodePartitioningColumns(Seq<String> columns) {
        return Serialization$.MODULE$.write(columns, this.formats());
    }

    public Seq<String> decodePartitioningColumns(String str) {
        return (Seq)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    public Option<String> extractDeltaPath(Dataset<?> dataset) {
        None$ none$;
        if (dataset.isStreaming()) {
            None$ none$2;
            LogicalPlan logicalPlan = dataset.queryExecution().logical();
            if (logicalPlan instanceof StreamingRelation) {
                StreamingRelation streamingRelation = (StreamingRelation)logicalPlan;
                Class clazz = streamingRelation.dataSource().providingClass();
                Class<DeltaDataSource> clazz2 = DeltaDataSource.class;
                none$2 = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? CaseInsensitiveMap$.MODULE$.apply(streamingRelation.dataSource().options()).get("path") : None$.MODULE$;
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else {
            LogicalRelation logicalRelation;
            Option<TahoeFileIndex> option;
            SubqueryAlias subqueryAlias;
            LogicalPlan logicalPlan;
            None$ none$3;
            LogicalRelation logicalRelation2;
            Option<TahoeFileIndex> option2;
            LogicalPlan logicalPlan2 = dataset.queryExecution().analyzed();
            if (logicalPlan2 instanceof LogicalRelation && !(option2 = DeltaTable$.MODULE$.unapply(logicalRelation2 = (LogicalRelation)logicalPlan2)).isEmpty()) {
                TahoeFileIndex tahoeFileIndex = (TahoeFileIndex)option2.get();
                none$3 = new Some((Object)tahoeFileIndex.path().toString());
            } else if (logicalPlan2 instanceof SubqueryAlias && (logicalPlan = (subqueryAlias = (SubqueryAlias)logicalPlan2).child()) instanceof LogicalRelation && !(option = DeltaTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan)).isEmpty()) {
                TahoeFileIndex tahoeFileIndex = (TahoeFileIndex)option.get();
                none$3 = new Some((Object)tahoeFileIndex.path().toString());
            } else {
                none$3 = None$.MODULE$;
            }
            none$ = none$3;
        }
        return none$;
    }

    private DeltaDataSource$() {
        MODULE$ = this;
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

