/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$class;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!B\u0001\u0003\u0003\u0003y!\u0001\u0007%bI>|\u0007OR5mKNK8\u000f^3n\u0019><7\u000b^8sK*\u00111\u0001B\u0001\bgR|'/Y4f\u0015\t)a!A\u0003eK2$\u0018M\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u0005!aunZ*u_J,\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0013M\u0004\u0018M]6D_:4\u0007CA\u000f\u001f\u001b\u0005A\u0011BA\u0010\t\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nAaY8oM*\u0011qEC\u0001\u0007Q\u0006$wn\u001c9\n\u0005%\"#!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0004[9z\u0003CA\f\u0001\u0011\u0015Y\"\u00061\u0001\u001d\u0011\u0015\t#\u00061\u0001#\u0011\u0015Y\u0003\u0001\"\u00012)\ti#\u0007C\u00034a\u0001\u0007A'\u0001\u0002tGB\u0011Q$N\u0005\u0003m!\u0011Ab\u00159be.\u001cuN\u001c;fqRDQ\u0001\u000f\u0001\u0005\u0012e\nacZ3u\u0011\u0006$wn\u001c9D_:4\u0017nZ;sCRLwN\\\u000b\u0002E!)1\b\u0001C!y\u0005!!/Z1e)\ti\u0004\u000bE\u0002?\r&s!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\ts\u0011A\u0002\u001fs_>$h(C\u0001\u0014\u0013\t)%#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%aA*fc*\u0011QI\u0005\t\u0003\u00156s!!E&\n\u00051\u0013\u0012A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001\u0014\n\t\u000bES\u0004\u0019\u0001*\u0002\tA\fG\u000f\u001b\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u001a\n!AZ:\n\u0005]#&\u0001\u0002)bi\"DQ!\u0017\u0001\u0005Bi\u000b\u0001\u0002\\5ti\u001a\u0013x.\u001c\u000b\u00037\u0006\u00042A\u0010/_\u0013\ti\u0006J\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\t\u0019v,\u0003\u0002a)\nQa)\u001b7f'R\fG/^:\t\u000bEC\u0006\u0019\u0001*\t\u000b\r\u0004A\u0011\t3\u00029I,7o\u001c7wKB\u000bG\u000f[(o!\"L8/[2bYN#xN]1hKR\u0011!+\u001a\u0005\u0006#\n\u0004\rA\u0015\u0005\u0006O\u0002!\t\u0002[\u0001\u0010oJLG/Z,ji\"\u0014VM\\1nKR!\u0011\u000e\\7q!\t\t\".\u0003\u0002l%\t!QK\\5u\u0011\u0015\tf\r1\u0001S\u0011\u0015qg\r1\u0001p\u0003\u001d\t7\r^5p]N\u00042A\u0010/J\u0011\u001d\th\r%AA\u0002I\f\u0011b\u001c<fe^\u0014\u0018\u000e^3\u0011\u0005E\u0019\u0018B\u0001;\u0013\u0005\u001d\u0011un\u001c7fC:DQA\u001e\u0001\u0005\u0012]\fab\u0019:fCR,G+Z7q!\u0006$\b\u000e\u0006\u0002Sq\")\u0011+\u001ea\u0001%\")!\u0010\u0001C!w\u0006y\u0011N\u001c<bY&$\u0017\r^3DC\u000eDW\rF\u0001j\u0011\u001di\b!%A\u0005\u0012y\f\u0011d\u001e:ji\u0016<\u0016\u000e\u001e5SK:\fW.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\tqPK\u0002s\u0003\u0003Y#!a\u0001\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b\u0011\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011CA\u0004\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public abstract class HadoopFileSystemLogStore
implements LogStore {
    public final Configuration org$apache$spark$sql$delta$storage$HadoopFileSystemLogStore$$hadoopConf;

    @Override
    public final Seq<String> read(String path) {
        return LogStore$class.read(this, path);
    }

    @Override
    public final void write(String path, Iterator<String> actions) {
        LogStore$class.write(this, path, actions);
    }

    @Override
    public final Iterator<FileStatus> listFrom(String path) {
        return LogStore$class.listFrom(this, path);
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return LogStore$class.isPartialWriteVisible(this, path);
    }

    @Override
    public boolean write$default$3() {
        return LogStore$class.write$default$3(this);
    }

    public Configuration getHadoopConfiguration() {
        return (Configuration)SparkSession$.MODULE$.getActiveSession().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Configuration apply(SparkSession x$1) {
                return x$1.sessionState().newHadoopConf();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HadoopFileSystemLogStore $outer;

            public final Configuration apply() {
                return this.$outer.org$apache$spark$sql$delta$storage$HadoopFileSystemLogStore$$hadoopConf;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<String> read(Path path) {
        Seq seq;
        FileSystem fs = path.getFileSystem(this.getHadoopConfiguration());
        FSDataInputStream stream = fs.open(path);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
            seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((Reader)reader)).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$2) {
                    return x$2.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        stream.close();
        return seq;
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        FileSystem fs = path.getFileSystem(this.getHadoopConfiguration());
        if (fs.exists(path.getParent())) {
            FileStatus[] files = fs.listStatus(path.getParent());
            return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).filter((Function1)new Serializable(this, path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final boolean apply(FileStatus x$3) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$3.getPath().getName())).$greater$eq((Object)this.path$1.getName());
                }
                {
                    this.path$1 = path$1;
                }
            })).sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus x$4) {
                    return x$4.getPath().getName();
                }
            }, (Ordering)Ordering.String$.MODULE$)).iterator();
        }
        throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No such file or directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getParent()})));
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path) {
        return path.getFileSystem(this.getHadoopConfiguration()).makeQualified(path);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeWithRename(Path path, Iterator<String> actions, boolean overwrite) {
        FileSystem fs = path.getFileSystem(this.getHadoopConfiguration());
        if (!fs.exists(path.getParent())) {
            throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No such file or directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getParent()})));
        }
        if (overwrite) {
            FSDataOutputStream stream = fs.create(path, true);
            actions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$5) {
                    return new StringBuilder().append((Object)x$5).append((Object)"\n").toString();
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(String x$6) {
                    return x$6.getBytes(StandardCharsets.UTF_8);
                }
            }).foreach((Function1)new Serializable(this, stream){
                public static final long serialVersionUID = 0L;
                private final FSDataOutputStream stream$1;

                public final void apply(byte[] x$1) {
                    this.stream$1.write(x$1);
                }
                {
                    this.stream$1 = stream$1;
                }
            });
            stream.close();
            return;
        }
        if (fs.exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        Path tempPath = this.createTempPath(path);
        boolean streamClosed = false;
        boolean renameDone = false;
        FSDataOutputStream stream = fs.create(tempPath);
        try {
            block15: {
                actions.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$7) {
                        return new StringBuilder().append((Object)x$7).append((Object)"\n").toString();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte[] apply(String x$8) {
                        return x$8.getBytes(StandardCharsets.UTF_8);
                    }
                }).foreach((Function1)new Serializable(this, stream){
                    public static final long serialVersionUID = 0L;
                    private final FSDataOutputStream stream$2;

                    public final void apply(byte[] x$1) {
                        this.stream$2.write(x$1);
                    }
                    {
                        this.stream$2 = stream$2;
                    }
                });
                stream.close();
                streamClosed = true;
                try {
                    if (!fs.rename(tempPath, path)) break block15;
                    renameDone = true;
                    return;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    throw new java.nio.file.FileAlreadyExistsException(path.toString());
                }
            }
            if (fs.exists(path)) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot rename ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempPath, path})));
            catch (Throwable throwable) {
                void var5_5;
                var5_5.close();
                throw throwable;
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!renameDone) {
                fs.delete(tempPath, false);
            }
        }
    }

    public boolean writeWithRename$default$3() {
        return false;
    }

    public Path createTempPath(Path path) {
        return new Path(path.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getName(), UUID.randomUUID()})));
    }

    @Override
    public void invalidateCache() {
    }

    public HadoopFileSystemLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        this.org$apache$spark$sql$delta$storage$HadoopFileSystemLogStore$$hadoopConf = hadoopConf;
        LogStore$class.$init$(this);
    }

    public HadoopFileSystemLogStore(SparkContext sc) {
        this(sc.getConf(), sc.hadoopConfiguration());
    }
}

