/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import com.google.common.io.CountingOutputStream;
import java.io.FileNotFoundException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.delta.storage.FileMetadata;
import org.apache.spark.sql.delta.storage.HadoopFileSystemLogStore;
import org.apache.spark.sql.delta.storage.S3SingleDriverLogStore$;
import org.apache.spark.sql.delta.util.FileNames$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001=\u0011acU\u001aTS:<G.\u001a#sSZ,'\u000fT8h'R|'/\u001a\u0006\u0003\u0007\u0011\tqa\u001d;pe\u0006<WM\u0003\u0002\u0006\r\u0005)A-\u001a7uC*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001\u0004S1e_>\u0004h)\u001b7f'f\u001cH/Z7M_\u001e\u001cFo\u001c:f\u0011!)\u0002A!A!\u0002\u00131\u0012!C:qCJ\\7i\u001c8g!\t9\u0002$D\u0001\t\u0013\tI\u0002BA\u0005Ta\u0006\u00148nQ8oM\"A1\u0004\u0001B\u0001B\u0003%A$\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t\r|gN\u001a\u0006\u0003C)\ta\u0001[1e_>\u0004\u0018BA\u0012\u001f\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"2a\n\u0015*!\t\t\u0002\u0001C\u0003\u0016I\u0001\u0007a\u0003C\u0003\u001cI\u0001\u0007A\u0004C\u0003,\u0001\u0011%A&\u0001\u0005sKN|GN^3e)\tiC\b\u0005\u0003/cMJT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\rQ+\b\u000f\\33!\t!t'D\u00016\u0015\t1\u0004%\u0001\u0002gg&\u0011\u0001(\u000e\u0002\u000b\r&dWmU=ti\u0016l\u0007C\u0001\u001b;\u0013\tYTG\u0001\u0003QCRD\u0007\"B\u001f+\u0001\u0004I\u0014\u0001\u00029bi\"DQa\u0010\u0001\u0005\n\u0001\u000b!bZ3u!\u0006$\bnS3z)\tI\u0014\tC\u0003C}\u0001\u0007\u0011(\u0001\u0007sKN|GN^3e!\u0006$\b\u000eC\u0003E\u0001\u0011%Q)A\u0007tiJL\u0007/V:fe&sgm\u001c\u000b\u0003s\u0019CQ!P\"A\u0002eBQ\u0001\u0013\u0001\u0005\n%\u000b!#\\3sO\u00164\u0015\u000e\\3Ji\u0016\u0014\u0018\r^8sgR\u0019!*W.\u0011\u0007-\u001bfK\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011qJD\u0001\u0007yI|w\u000e\u001e \n\u0003AJ!AU\u0018\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\t\u0013R,'/\u0019;pe*\u0011!k\f\t\u0003i]K!\u0001W\u001b\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0003[\u000f\u0002\u0007!*\u0001\u0003ji\u0016\u0014\b\"\u0002/H\u0001\u0004Q\u0015AE5uKJ<\u0016\u000e\u001e5Qe\u0016\u001cW\rZ3oG\u0016DQA\u0018\u0001\u0005\n}\u000bQ\u0002\\5ti\u001a\u0013x.\\\"bG\",Gc\u00011fMB\u0019\u0011\r\u001a,\u000e\u0003\tT!aY\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002UE\")a'\u0018a\u0001g!)!)\u0018a\u0001s!)\u0001\u000e\u0001C\u0005S\u0006\u0001B.[:u\rJ|W.\u00138uKJt\u0017\r\u001c\u000b\u0005\u0015*\\G\u000eC\u00037O\u0002\u00071\u0007C\u0003CO\u0002\u0007\u0011\bC\u0004nOB\u0005\t\u0019\u00018\u0002\u0011U\u001cXmQ1dQ\u0016\u0004\"AL8\n\u0005A|#a\u0002\"p_2,\u0017M\u001c\u0005\u0006e\u0002!\te]\u0001\tY&\u001cHO\u0012:p[R\u0011!\n\u001e\u0005\u0006{E\u0004\r!\u000f\u0005\u0006m\u0002!Ia^\u0001\u0011SNLe.\u001b;jC24VM]:j_:$\"A\u001c=\t\u000bu*\b\u0019A\u001d\t\u000bi\u0004A\u0011B>\u0002\r\u0015D\u0018n\u001d;t)\rqG0 \u0005\u0006me\u0004\ra\r\u0005\u0006\u0005f\u0004\r!\u000f\u0005\u0007\u007f\u0002!\t%!\u0001\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0011\u0005\r\u0011\u0011BA\u0006\u0003?\u00012ALA\u0003\u0013\r\t9a\f\u0002\u0005+:LG\u000fC\u0003>}\u0002\u0007\u0011\bC\u0004\u0002\u000ey\u0004\r!a\u0004\u0002\u000f\u0005\u001cG/[8ogB!1jUA\t!\u0011\t\u0019\"!\u0007\u000f\u00079\n)\"C\u0002\u0002\u0018=\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000e\u0003;\u0011aa\u0015;sS:<'bAA\f_!A\u0011\u0011\u0005@\u0011\u0002\u0003\u0007a.A\u0005pm\u0016\u0014xO]5uK\"9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012!F5t!\u0006\u0014H/[1m/JLG/\u001a,jg&\u0014G.\u001a\u000b\u0004]\u0006%\u0002BB\u001f\u0002$\u0001\u0007\u0011\bC\u0004\u0002.\u0001!\t%a\f\u0002\u001f%tg/\u00197jI\u0006$XmQ1dQ\u0016$\"!a\u0001\t\u0013\u0005M\u0002!%A\u0005\n\u0005U\u0012A\u00077jgR4%o\\7J]R,'O\\1mI\u0011,g-Y;mi\u0012\u001aTCAA\u001cU\rq\u0017\u0011H\u0016\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0005v]\u000eDWmY6fI*\u0019\u0011QI\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002J\u0005}\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\n\u0001\u0012\u0002\u0013\u0005\u0013QG\u0001\u0010oJLG/\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u001d9\u0011\u0011\u000b\u0002\t\u0002\u0005M\u0013AF*4'&tw\r\\3Ee&4XM\u001d'pON#xN]3\u0011\u0007E\t)F\u0002\u0004\u0002\u0005!\u0005\u0011qK\n\u0005\u0003+\nI\u0006E\u0002/\u00037J1!!\u00180\u0005\u0019\te.\u001f*fM\"9Q%!\u0016\u0005\u0002\u0005\u0005DCAA*\u0011)\t)'!\u0016C\u0002\u0013%\u0011qM\u0001\ta\u0006$\b\u000eT8dWV\u0011\u0011\u0011\u000e\t\b\u0003W\nI(OA-\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014AC2p]\u000e,(O]3oi*!\u00111OA;\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0014\u0001\u00026bm\u0006LA!a\u001f\u0002n\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\t\u0013\u0005}\u0014Q\u000bQ\u0001\n\u0005%\u0014!\u00039bi\"dunY6!\u0011)\t\u0019)!\u0016C\u0002\u0013%\u0011QQ\u0001\u0011oJLG\u000f^3o!\u0006$\bnQ1dQ\u0016,\"!a\"\u0011\u000f\u0005%\u00151T\u001d\u0002 6\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)A\u0003dC\u000eDWM\u0003\u0003\u0002\u0012\u0006M\u0015AB2p[6|gN\u0003\u0003\u0002\u0016\u0006]\u0015AB4p_\u001edWM\u0003\u0002\u0002\u001a\u0006\u00191m\\7\n\t\u0005u\u00151\u0012\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0004#\u0005\u0005\u0016bAAR\u0005\taa)\u001b7f\u001b\u0016$\u0018\rZ1uC\"I\u0011qUA+A\u0003%\u0011qQ\u0001\u0012oJLG\u000f^3o!\u0006$\bnQ1dQ\u0016\u0004\u0003\u0002CAV\u0003+\"I!!,\u0002\u001fI,G.Z1tKB\u000bG\u000f\u001b'pG.$B!a\u0001\u00020\"1!)!+A\u0002eB\u0001\"a-\u0002V\u0011%\u0011QW\u0001\u0010C\u000e\fX/\u001b:f!\u0006$\b\u000eT8dWR!\u00111AA\\\u0011\u0019\u0011\u0015\u0011\u0017a\u0001s\u0001")
public class S3SingleDriverLogStore
extends HadoopFileSystemLogStore {
    private Tuple2<FileSystem, Path> resolved(Path path) {
        FileSystem fs = path.getFileSystem(this.getHadoopConfiguration());
        Path resolvedPath = this.stripUserInfo(fs.makeQualified(path));
        return new Tuple2((Object)fs, (Object)resolvedPath);
    }

    private Path getPathKey(Path resolvedPath) {
        return this.stripUserInfo(resolvedPath);
    }

    private Path stripUserInfo(Path path) {
        URI uri = path.toUri();
        URI newUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        return new Path(newUri);
    }

    private Iterator<FileStatus> mergeFileIterators(Iterator<FileStatus> iter, Iterator<FileStatus> iterWithPrecedence) {
        return ((IterableLike)iter.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Path, FileStatus> apply(FileStatus f) {
                return new Tuple2((Object)f.getPath(), (Object)f);
            }
        }).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)iterWithPrecedence.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Path, FileStatus> apply(FileStatus f) {
                return new Tuple2((Object)f.getPath(), (Object)f);
            }
        })).values().toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$1) {
                return x$1.getPath().getName();
            }
        }, (Ordering)Ordering.String$.MODULE$)).iterator();
    }

    private Iterator<FileStatus> listFromCache(FileSystem fs, Path resolvedPath) {
        Path pathKey = this.getPathKey(resolvedPath);
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().asMap()).asScala()).iterator().filter((Function1)new Serializable(this, pathKey){
            public static final long serialVersionUID = 0L;
            private final Path pathKey$1;

            public final boolean apply(Tuple2<Path, FileMetadata> x0$1) {
                Tuple2<Path, FileMetadata> tuple2 = x0$1;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    Path path2 = path.getParent();
                    Path path3 = this.pathKey$1.getParent();
                    boolean bl = !(path2 != null ? !path2.equals(path3) : path3 != null) && new StringOps(Predef$.MODULE$.augmentString(path.getName())).$greater$eq((Object)this.pathKey$1.getName());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pathKey$1 = pathKey$1;
            }
        }).map((Function1)new Serializable(this, fs){
            public static final long serialVersionUID = 0L;
            private final FileSystem fs$1;

            public final FileStatus apply(Tuple2<Path, FileMetadata> x0$2) {
                Tuple2<Path, FileMetadata> tuple2 = x0$2;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    FileMetadata fileMetadata = (FileMetadata)tuple2._2();
                    FileStatus fileStatus = new FileStatus(fileMetadata.length(), false, 1, this.fs$1.getDefaultBlockSize(path), fileMetadata.modificationTime(), path);
                    return fileStatus;
                }
                throw new MatchError(tuple2);
            }
            {
                this.fs$1 = fs$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private Iterator<FileStatus> listFromInternal(FileSystem fs, Path resolvedPath, boolean useCache) {
        void var4_4;
        Path parentPath = resolvedPath.getParent();
        if (fs.exists(parentPath)) {
            Iterator listedFromFs = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(parentPath)).filter((Function1)new Serializable(this, resolvedPath){
                public static final long serialVersionUID = 0L;
                private final Path resolvedPath$1;

                public final boolean apply(FileStatus x$2) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$2.getPath().getName())).$greater$eq((Object)this.resolvedPath$1.getName());
                }
                {
                    this.resolvedPath$1 = resolvedPath$1;
                }
            })).iterator();
            Iterator<FileStatus> listedFromCache = useCache ? this.listFromCache(fs, resolvedPath) : package$.MODULE$.Iterator().empty();
            return this.mergeFileIterators(listedFromCache, (Iterator<FileStatus>)listedFromFs);
        }
        throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No such file or directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4})));
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        Tuple2<FileSystem, Path> tuple2 = this.resolved(path);
        if (tuple2 != null) {
            Tuple2 tuple22;
            FileSystem fs = (FileSystem)tuple2._1();
            Path resolvedPath = (Path)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fs, (Object)resolvedPath);
            FileSystem fs2 = (FileSystem)tuple23._1();
            Path resolvedPath2 = (Path)tuple23._2();
            return this.listFromInternal(fs2, resolvedPath2, this.listFromInternal$default$3());
        }
        throw new MatchError(tuple2);
    }

    private boolean listFromInternal$default$3() {
        return true;
    }

    private boolean isInitialVersion(Path path) {
        return FileNames$.MODULE$.isDeltaFile(path) && FileNames$.MODULE$.deltaVersion(path) == 0L;
    }

    private boolean exists(FileSystem fs, Path resolvedPath) {
        return this.listFromInternal(fs, resolvedPath, !this.isInitialVersion(resolvedPath)).take(1).exists((Function1)new Serializable(this, resolvedPath){
            public static final long serialVersionUID = 0L;
            private final Path resolvedPath$2;

            public final boolean apply(FileStatus x$4) {
                String string = x$4.getPath().getName();
                String string2 = this.resolvedPath$2.getName();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.resolvedPath$2 = resolvedPath$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        Tuple2 tuple22;
        Tuple2<FileSystem, Path> tuple2 = this.resolved(path);
        if (tuple2 == null) throw new MatchError(tuple2);
        FileSystem fs = (FileSystem)tuple2._1();
        Path resolvedPath = (Path)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)fs, (Object)resolvedPath);
        FileSystem fs2 = (FileSystem)tuple23._1();
        Path resolvedPath2 = (Path)tuple23._2();
        Path lockedPath = this.getPathKey(resolvedPath2);
        FSDataOutputStream stream = null;
        S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$acquirePathLock(lockedPath);
        try {
            if (this.exists(fs2, resolvedPath2) && !overwrite) {
                throw new java.nio.file.FileAlreadyExistsException(resolvedPath2.toUri().toString());
            }
            CountingOutputStream countingStream = new CountingOutputStream(stream);
            FSDataOutputStream fSDataOutputStream = stream = fs2.create(resolvedPath2, overwrite);
            actions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$6) {
                    return new StringBuilder().append((Object)x$6).append((Object)"\n").toString();
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(String x$7) {
                    return x$7.getBytes(StandardCharsets.UTF_8);
                }
            }).foreach((Function1)new Serializable(this, fSDataOutputStream){
                public static final long serialVersionUID = 0L;
                private final FSDataOutputStream eta$0$1$1;

                public final void apply(byte[] x$1) {
                    this.eta$0$1$1.write(x$1);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            });
            stream.close();
            if (this.isInitialVersion(resolvedPath2)) {
                java.lang.Iterable obsoleteFiles = (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().asMap()).asScala()).keys().filter((Function1)new Serializable(this, lockedPath){
                    public static final long serialVersionUID = 0L;
                    private final Path lockedPath$1;

                    public final boolean apply(Path x$8) {
                        Path path = x$8.getParent();
                        Path path2 = this.lockedPath$1.getParent();
                        return !(path != null ? !path.equals(path2) : path2 != null);
                    }
                    {
                        this.lockedPath$1 = lockedPath$1;
                    }
                })).asJava();
                S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().invalidateAll(obsoleteFiles);
            }
            S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().put((Object)lockedPath, (Object)new FileMetadata(countingStream.getCount(), System.currentTimeMillis()));
            S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$releasePathLock(lockedPath);
            return;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            try {
                throw new java.nio.file.FileAlreadyExistsException(fileAlreadyExistsException.getMessage());
            }
            catch (Throwable throwable) {
                void var11_11;
                S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$releasePathLock((Path)var11_11);
                throw throwable;
            }
        }
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return false;
    }

    @Override
    public void invalidateCache() {
        S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().invalidateAll();
    }

    public S3SingleDriverLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        super(sparkConf, hadoopConf);
    }
}

