/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.apache.spark.sql.delta.util.DateFormatter;
import org.apache.spark.sql.delta.util.DateTimeFormatterHelper;
import org.apache.spark.sql.delta.util.DateTimeFormatterHelper$class;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001f\t!\u0012j]89mA\nD)\u0019;f\r>\u0014X.\u0019;uKJT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\tQ\u0001Z3mi\u0006T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00175A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u001b\u0011\u000bG/\u001a$pe6\fG\u000f^3s!\t92$\u0003\u0002\u001d\u0005\t9B)\u0019;f)&lWMR8s[\u0006$H/\u001a:IK2\u0004XM\u001d\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u00059\u0001/\u0019;uKJt\u0007C\u0001\u0011$\u001d\t\t\u0012%\u0003\u0002#%\u00051\u0001K]3eK\u001aL!\u0001J\u0013\u0003\rM#(/\u001b8h\u0015\t\u0011#\u0003\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0003\u0019awnY1mKB\u0011\u0011&L\u0007\u0002U)\u00111a\u000b\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq#F\u0001\u0004M_\u000e\fG.\u001a\u0005\u0006a\u0001!\t!M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\u001aD\u0007\u0005\u0002\u0018\u0001!)ad\fa\u0001?!)qe\fa\u0001Q!Aa\u0007\u0001EC\u0002\u0013%q'A\u0005g_Jl\u0017\r\u001e;feV\t\u0001\b\u0005\u0002:}5\t!H\u0003\u0002<y\u00051am\u001c:nCRT!!P\u0016\u0002\tQLW.Z\u0005\u0003\u007fi\u0012\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0011!\t\u0005\u0001#A!B\u0013A\u0014A\u00034pe6\fG\u000f^3sA!\u0012\u0001i\u0011\t\u0003#\u0011K!!\u0012\n\u0003\u0013Q\u0014\u0018M\\:jK:$\bbB$\u0001\u0005\u0004%I\u0001S\u0001\u0004+R\u001bU#A%\u0011\u0005)[U\"\u0001\u001f\n\u00051c$A\u0002.p]\u0016LE\r\u0003\u0004O\u0001\u0001\u0006I!S\u0001\u0005+R\u001b\u0005\u0005C\u0003Q\u0001\u0011%\u0011+A\u0005u_&s7\u000f^1oiR\u0011!+\u0016\t\u0003\u0015NK!\u0001\u0016\u001f\u0003\u000f%s7\u000f^1oi\")ak\u0014a\u0001?\u0005\t1\u000fC\u0003Y\u0001\u0011\u0005\u0013,A\u0003qCJ\u001cX\r\u0006\u0002[;B\u0011\u0011cW\u0005\u00039J\u00111!\u00138u\u0011\u00151v\u000b1\u0001 \u0011\u0015Y\u0004\u0001\"\u0011`)\ty\u0002\rC\u0003b=\u0002\u0007!,\u0001\u0003eCf\u001c\b")
public class Iso8601DateFormatter
implements DateFormatter,
DateTimeFormatterHelper {
    private final String pattern;
    private final Locale locale;
    private transient DateTimeFormatter formatter;
    private final ZoneId UTC;
    private volatile transient boolean bitmap$trans$0;

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601DateFormatter iso8601DateFormatter = this;
        synchronized (iso8601DateFormatter) {
            if (!this.bitmap$trans$0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale);
                this.bitmap$trans$0 = true;
            }
            return this.formatter;
        }
    }

    @Override
    public Instant toInstantWithZoneId(TemporalAccessor temporalAccessor, ZoneId zoneId) {
        return DateTimeFormatterHelper$class.toInstantWithZoneId(this, temporalAccessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale) {
        return DateTimeFormatterHelper$class.getOrCreateFormatter(this, pattern, locale);
    }

    private DateTimeFormatter formatter() {
        return this.bitmap$trans$0 ? this.formatter : this.formatter$lzycompute();
    }

    private ZoneId UTC() {
        return this.UTC;
    }

    private Instant toInstant(String s) {
        TemporalAccessor temporalAccessor = this.formatter().parse(s);
        return this.toInstantWithZoneId(temporalAccessor, this.UTC());
    }

    @Override
    public int parse(String s) {
        return DateTimeUtils$.MODULE$.instantToDays(this.toInstant(s));
    }

    @Override
    public String format(int days) {
        Instant instant = Instant.ofEpochSecond((long)days * DateTimeUtils$.MODULE$.SECONDS_PER_DAY());
        return this.formatter().withZone(this.UTC()).format(instant);
    }

    public Iso8601DateFormatter(String pattern, Locale locale) {
        this.pattern = pattern;
        this.locale = locale;
        DateTimeFormatterHelper$class.$init$(this);
        this.UTC = ZoneId.of("UTC");
    }
}

