/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.sql.delta.util.DateTimeFormatterHelper;
import org.apache.spark.sql.delta.util.DateTimeFormatterHelper$class;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001f\tI\u0012j]89mA\nD+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003\u0015!W\r\u001c;b\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001C\u0006\u000e\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\u0002$D\u0001\u0003\u0013\tI\"A\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\bCA\f\u001c\u0013\ta\"AA\fECR,G+[7f\r>\u0014X.\u0019;uKJDU\r\u001c9fe\"Aa\u0004\u0001B\u0001B\u0003%q$A\u0004qCR$XM\u001d8\u0011\u0005\u0001\u001acBA\t\"\u0013\t\u0011##\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0015\u0012aa\u0015;sS:<'B\u0001\u0012\u0013\u0011!9\u0003A!A!\u0002\u0013A\u0013\u0001\u0003;j[\u0016TvN\\3\u0011\u0005%jS\"\u0001\u0016\u000b\u0005\rY#\"\u0001\u0017\u0002\t)\fg/Y\u0005\u0003])\u0012\u0001\u0002V5nKj{g.\u001a\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u00051An\\2bY\u0016\u0004\"!\u000b\u001a\n\u0005MR#A\u0002'pG\u0006dW\rC\u00036\u0001\u0011\u0005a'\u0001\u0004=S:LGO\u0010\u000b\u0005oaJ$\b\u0005\u0002\u0018\u0001!)a\u0004\u000ea\u0001?!)q\u0005\u000ea\u0001Q!)\u0001\u0007\u000ea\u0001c!AA\b\u0001EC\u0002\u0013EQ(A\u0005g_Jl\u0017\r\u001e;feV\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u00061am\u001c:nCRT!aQ\u0016\u0002\tQLW.Z\u0005\u0003\u000b\u0002\u0013\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0011!9\u0005\u0001#A!B\u0013q\u0014A\u00034pe6\fG\u000f^3sA!\u0012a)\u0013\t\u0003#)K!a\u0013\n\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"B'\u0001\t\u0013q\u0015!\u0003;p\u0013:\u001cH/\u00198u)\ty5\u000b\u0005\u0002Q#6\t!)\u0003\u0002S\u0005\n9\u0011J\\:uC:$\b\"\u0002+M\u0001\u0004y\u0012!A:\t\u000bY\u0003A\u0011I,\u0002\u000bA\f'o]3\u0015\u0005a[\u0006CA\tZ\u0013\tQ&C\u0001\u0003M_:<\u0007\"\u0002+V\u0001\u0004y\u0002\"B!\u0001\t\u0003jFCA\u0010_\u0011\u0015yF\f1\u0001Y\u0003\t)8\u000f")
public class Iso8601TimestampFormatter
implements TimestampFormatter,
DateTimeFormatterHelper {
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private transient DateTimeFormatter formatter;
    private volatile transient boolean bitmap$trans$0;

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if (!this.bitmap$trans$0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale);
                this.bitmap$trans$0 = true;
            }
            return this.formatter;
        }
    }

    @Override
    public Instant toInstantWithZoneId(TemporalAccessor temporalAccessor, ZoneId zoneId) {
        return DateTimeFormatterHelper$class.toInstantWithZoneId(this, temporalAccessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale) {
        return DateTimeFormatterHelper$class.getOrCreateFormatter(this, pattern, locale);
    }

    public DateTimeFormatter formatter() {
        return this.bitmap$trans$0 ? this.formatter : this.formatter$lzycompute();
    }

    private Instant toInstant(String s) {
        TemporalAccessor temporalAccessor = this.formatter().parse(s);
        return temporalAccessor.query(TemporalQueries.offset()) == null ? this.toInstantWithZoneId(temporalAccessor, this.timeZone.toZoneId()) : Instant.from(temporalAccessor);
    }

    @Override
    public long parse(String s) {
        return DateTimeUtils$.MODULE$.instantToMicros(this.toInstant(s));
    }

    @Override
    public String format(long us) {
        Instant instant = DateTimeUtils$.MODULE$.microsToInstant(us);
        return this.formatter().withZone(this.timeZone.toZoneId()).format(instant);
    }

    public Iso8601TimestampFormatter(String pattern, TimeZone timeZone, Locale locale) {
        this.pattern = pattern;
        this.timeZone = timeZone;
        this.locale = locale;
        DateTimeFormatterHelper$class.$init$(this);
    }
}

