/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jersey.InstrumentedResourceMethodDispatchAdapter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.sun.jersey.api.core.ScanningResourceConfig;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.AbstractSubResourceLocator;
import com.sun.jersey.server.impl.modelapi.annotation.IntrospectionModeller;
import io.dropwizard.jersey.caching.CacheControlledResourceMethodDispatchAdapter;
import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import io.dropwizard.jersey.guava.OptionalQueryParamInjectableProvider;
import io.dropwizard.jersey.guava.OptionalResourceMethodDispatchAdapter;
import io.dropwizard.jersey.jackson.JsonProcessingExceptionMapper;
import io.dropwizard.jersey.validation.ConstraintViolationExceptionMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardResourceConfig
extends ScanningResourceConfig {
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardResourceConfig.class);
    private String urlPattern = "/*";

    public static DropwizardResourceConfig forTesting(MetricRegistry metricRegistry) {
        return new DropwizardResourceConfig(true, metricRegistry);
    }

    public DropwizardResourceConfig(MetricRegistry metricRegistry) {
        this(false, metricRegistry);
    }

    private DropwizardResourceConfig(boolean testOnly, MetricRegistry metricRegistry) {
        this.getFeatures().put("com.sun.jersey.config.feature.DisableWADL", Boolean.TRUE);
        if (!testOnly) {
            this.getSingletons().add(new LoggingExceptionMapper<Throwable>(){});
            this.getSingletons().add(new ConstraintViolationExceptionMapper());
            this.getSingletons().add(new JsonProcessingExceptionMapper());
        }
        this.getSingletons().add(new InstrumentedResourceMethodDispatchAdapter(metricRegistry));
        this.getClasses().add(CacheControlledResourceMethodDispatchAdapter.class);
        this.getClasses().add(OptionalResourceMethodDispatchAdapter.class);
        this.getClasses().add(OptionalQueryParamInjectableProvider.class);
    }

    public void validate() {
        super.validate();
        this.logResources();
        this.logProviders();
        this.logEndpoints();
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    private void logResources() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class klass : this.getClasses()) {
            if (!klass.isAnnotationPresent(Path.class)) continue;
            builder.add((Object)klass.getCanonicalName());
        }
        for (Object o : this.getSingletons()) {
            if (!o.getClass().isAnnotationPresent(Path.class)) continue;
            builder.add((Object)o.getClass().getCanonicalName());
        }
        for (Object o : this.getExplicitRootResources().values()) {
            if (o instanceof Class) {
                builder.add((Object)((Class)o).getCanonicalName());
                continue;
            }
            builder.add((Object)o.getClass().getCanonicalName());
        }
        LOGGER.debug("resources = {}", (Object)builder.build());
    }

    private void logProviders() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class klass : this.getClasses()) {
            if (!klass.isAnnotationPresent(Provider.class)) continue;
            builder.add((Object)klass.getCanonicalName());
        }
        for (Object o : this.getSingletons()) {
            if (!o.getClass().isAnnotationPresent(Provider.class)) continue;
            builder.add((Object)o.getClass().getCanonicalName());
        }
        LOGGER.debug("providers = {}", (Object)builder.build());
    }

    private void logEndpoints() {
        StringBuilder msg = new StringBuilder(1024);
        msg.append("The following paths were found for the configured resources:");
        msg.append(NEWLINE).append(NEWLINE);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object o : this.getSingletons()) {
            if (!o.getClass().isAnnotationPresent(Path.class)) continue;
            builder.add(o.getClass());
        }
        for (Class klass : this.getClasses()) {
            if (!klass.isAnnotationPresent(Path.class)) continue;
            builder.add((Object)klass);
        }
        String rootPath = this.urlPattern;
        if (rootPath.endsWith("/*")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        for (Class klass : builder.build()) {
            ArrayList endpoints = Lists.newArrayList();
            this.populateEndpoints(endpoints, rootPath, klass, false);
            for (String line : Ordering.natural().sortedCopy((Iterable)endpoints)) {
                msg.append(line).append(NEWLINE);
            }
        }
        for (Map.Entry entry : this.getExplicitRootResources().entrySet()) {
            Class<?> klass = entry.getValue() instanceof Class ? (Class<?>)entry.getValue() : entry.getValue().getClass();
            AbstractResource resource = new AbstractResource((String)entry.getKey(), IntrospectionModeller.createResource(klass));
            ArrayList endpoints = Lists.newArrayList();
            this.populateEndpoints(endpoints, rootPath, klass, false, resource);
            for (String line : Ordering.natural().sortedCopy((Iterable)endpoints)) {
                msg.append(line).append(NEWLINE);
            }
        }
        LOGGER.info(msg.toString());
    }

    private void populateEndpoints(List<String> endpoints, String basePath, Class<?> klass, boolean isLocator) {
        this.populateEndpoints(endpoints, basePath, klass, isLocator, IntrospectionModeller.createResource(klass));
    }

    private void populateEndpoints(List<String> endpoints, String basePath, Class<?> klass, boolean isLocator, AbstractResource resource) {
        String path;
        if (!isLocator) {
            basePath = this.normalizePath(basePath, resource.getPath().getValue());
        }
        for (AbstractResourceMethod method : resource.getResourceMethods()) {
            endpoints.add(this.formatEndpoint(method.getHttpMethod(), basePath, klass));
        }
        for (AbstractResourceMethod method : resource.getSubResourceMethods()) {
            path = this.normalizePath(basePath, method.getPath().getValue());
            endpoints.add(this.formatEndpoint(method.getHttpMethod(), path, klass));
        }
        for (AbstractSubResourceLocator locator : resource.getSubResourceLocators()) {
            path = this.normalizePath(basePath, locator.getPath().getValue());
            this.populateEndpoints(endpoints, path, locator.getMethod().getReturnType(), true);
        }
    }

    private String formatEndpoint(String method, String path, Class<?> klass) {
        return String.format("    %-7s %s (%s)", method, path, klass.getCanonicalName());
    }

    private String normalizePath(String basePath, String path) {
        if (basePath.endsWith("/")) {
            return path.startsWith("/") ? basePath + path.substring(1) : basePath + path;
        }
        return path.startsWith("/") ? basePath + path : basePath + "/" + path;
    }
}

