/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.sessions;

import io.dropwizard.jersey.sessions.Flash;
import io.dropwizard.jersey.sessions.FlashFactory;
import io.dropwizard.jersey.sessions.HttpSessionFactory;
import io.dropwizard.jersey.sessions.Session;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpSession;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;

@Singleton
public class SessionFactoryProvider
extends AbstractValueParamProvider {
    private final InjectionManager im;

    @Inject
    public SessionFactoryProvider(Provider<MultivaluedParameterExtractorProvider> extractorProvider, InjectionManager im) {
        super(extractorProvider, new Parameter.Source[]{Parameter.Source.UNKNOWN});
        this.im = im;
    }

    @Nullable
    protected Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        Class classType = parameter.getRawType();
        Session sessionAnnotation = (Session)parameter.getAnnotation(Session.class);
        if (sessionAnnotation == null) {
            return null;
        }
        if (classType.isAssignableFrom(HttpSession.class)) {
            return x -> ((HttpSessionFactory)this.im.createAndInitialize(HttpSessionFactory.class)).provide(sessionAnnotation.doNotCreate());
        }
        if (classType.isAssignableFrom(Flash.class)) {
            return x -> ((FlashFactory)this.im.createAndInitialize(FlashFactory.class)).provide(sessionAnnotation.doNotCreate());
        }
        return null;
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(SessionFactoryProvider.class).to(ValueParamProvider.class)).in(Singleton.class);
        }
    }
}

