/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebean.BackgroundExecutor;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebeaninternal.server.cache.DefaultServerCache;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;

final class DefaultServerCacheFactory
implements ServerCacheFactory {
    private final BackgroundExecutor executor;

    DefaultServerCacheFactory() {
        this.executor = null;
    }

    DefaultServerCacheFactory(BackgroundExecutor executor) {
        this.executor = executor;
    }

    public ServerCache createCache(ServerCacheConfig config) {
        DefaultServerCache cache = config.isQueryCache() ? new DefaultServerQueryCache(new DefaultServerCacheConfig(config)) : new DefaultServerCache(new DefaultServerCacheConfig(config));
        if (this.executor != null) {
            cache.periodicTrim(this.executor);
        }
        return config.tenantAware((ServerCache)cache);
    }

    public ServerCacheNotify createCacheNotify(ServerCacheNotify listener) {
        return new NoopServerCacheNotify();
    }

    private static class NoopServerCacheNotify
    implements ServerCacheNotify {
        private NoopServerCacheNotify() {
        }

        public void notify(ServerCacheNotification notification) {
        }
    }
}

