/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebeaninternal.api.BinaryReadContext;
import io.ebeaninternal.api.BinaryWritable;
import io.ebeaninternal.api.BinaryWriteContext;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class RemoteCacheEvent
implements BinaryWritable {
    private final boolean clearAll;
    private final List<String> clearCaches;

    public RemoteCacheEvent(boolean clearAll) {
        this.clearAll = clearAll;
        this.clearCaches = null;
    }

    public RemoteCacheEvent(Class<?> beanType) {
        this.clearAll = false;
        this.clearCaches = new ArrayList<String>(1);
        this.clearCaches.add(beanType.getName());
    }

    public RemoteCacheEvent(boolean clearAll, List<String> beanTypes) {
        this.clearAll = clearAll;
        this.clearCaches = beanTypes;
    }

    public boolean isClearAll() {
        return this.clearAll;
    }

    public List<String> getClearCaches() {
        return this.clearCaches;
    }

    public String toString() {
        return "CacheEvent[ clearAll:" + this.clearAll + " caches:" + this.clearCaches + "]";
    }

    public static RemoteCacheEvent readBinaryMessage(BinaryReadContext dataInput) throws IOException {
        boolean clearAll = dataInput.readBoolean();
        int size = dataInput.readInt();
        ArrayList<String> clearCache = null;
        if (size > 0) {
            clearCache = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                clearCache.add(dataInput.readUTF());
            }
        }
        return new RemoteCacheEvent(clearAll, clearCache);
    }

    @Override
    public void writeBinary(BinaryWriteContext out) throws IOException {
        DataOutputStream os = out.start(3);
        os.writeBoolean(this.clearAll);
        if (this.clearCaches == null) {
            os.writeInt(0);
        } else {
            os.writeInt(this.clearCaches.size());
            for (String cacheName : this.clearCaches) {
                os.writeUTF(cacheName);
            }
        }
    }
}

