/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.idgen;

import io.ebeaninternal.server.idgen.UuidV1RndIdGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class UuidV1IdGenerator
extends UuidV1RndIdGenerator {
    private static final Map<File, UuidV1IdGenerator> INSTANCES = new ConcurrentHashMap<File, UuidV1IdGenerator>();
    private final File stateFile;
    private byte[] nodeId;
    private boolean canSaveState = true;

    public static UuidV1IdGenerator getInstance(String file, String nodeId) {
        return UuidV1IdGenerator.getInstance(new File(file), nodeId);
    }

    public static UuidV1IdGenerator getInstance(File file, String nodeId) {
        return INSTANCES.computeIfAbsent(file, f -> new UuidV1IdGenerator((File)f, nodeId == null ? null : nodeId.toLowerCase()));
    }

    private static byte[] parseAlternativeNodeId(String altNodeId) {
        String[] components = altNodeId.split("-");
        if (components.length != 6) {
            throw new IllegalArgumentException(altNodeId + " is invalid. Expected format: xx-xx-xx-xx-xx-xx");
        }
        try {
            byte[] nodeId = new byte[6];
            for (int i = 0; i < 6; ++i) {
                nodeId[i] = (byte)Integer.parseInt(components[i], 16);
            }
            return nodeId;
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(altNodeId + " is invalid.", iae);
        }
    }

    private static byte[] getHardwareId() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        byte[] fallbackAddr = null;
        while (e.hasMoreElements()) {
            NetworkInterface network = e.nextElement();
            try {
                byte[] addr;
                log.trace("Probing interface {}", (Object)network);
                if (network.isLoopback() || !UuidV1IdGenerator.validAddr(addr = network.getHardwareAddress())) continue;
                if (network.isUp() && !network.isVirtual()) {
                    log.debug("Using interface {}", (Object)network);
                    return addr;
                }
                if (fallbackAddr != null) continue;
                log.debug("Using interface {} as fallback", (Object)network);
                fallbackAddr = addr;
            }
            catch (SocketException ex) {
                log.debug("Skipping {}", (Object)network, (Object)ex);
            }
        }
        return fallbackAddr;
    }

    private static boolean validAddr(byte[] addr) {
        if (addr != null && addr.length >= 6) {
            return addr[0] != 0 && addr[1] != 0 && addr[2] != 0 || addr[0] != 255 && addr[1] != 255 && addr[2] != 255;
        }
        return false;
    }

    private UuidV1IdGenerator(File stateFile, String altNodeId) {
        this.stateFile = stateFile;
        try {
            if (altNodeId == null) {
                this.tryHardwareId();
            } else if (altNodeId.equals("generate")) {
                this.tryGenerateMode();
            } else if (altNodeId.equals("random")) {
                this.useRandomMode();
            } else {
                this.nodeId = UuidV1IdGenerator.parseAlternativeNodeId(altNodeId);
                this.restoreState();
                log.info("Explicitly using ID {} to generate Type 1 UUIDs", (Object)this.getNodeIdentifier());
            }
            UUID uuid = this.nextId(null);
            long ts = this.timeStamp.get();
            ts -= 122192928000000000L;
            this.saveState();
            log.debug("Saved state: clockSeq {}, timestamp {}, uuid {}, stateFile: {})", new Object[]{this.clockSeq.get(), new Date(ts /= 10000L), uuid, stateFile});
        }
        catch (IOException e) {
            log.error("There was a problem while detecting the nodeId. Falling back to random mode. Try using to specify 'ebean.uuidNodeId' property", (Throwable)e);
            this.useRandomMode();
        }
    }

    private void tryHardwareId() throws IOException {
        try {
            this.nodeId = UuidV1IdGenerator.getHardwareId();
        }
        catch (IOException e) {
            log.error("Error while reading MAC address. Fall back to 'generate' mode", (Throwable)e);
            this.tryGenerateMode();
        }
        if (this.nodeId != null) {
            this.restoreState();
            log.info("Using MAC {} to generate Type 1 UUIDs", (Object)this.getNodeIdentifier());
            return;
        }
        log.warn("No suitable network interface found. Fall back to 'generate' mode");
        this.tryGenerateMode();
    }

    private void tryGenerateMode() throws IOException {
        if (this.restoreState()) {
            log.info("Using recently generated nodeId {} to generate Type 1 UUIDs", (Object)this.getNodeIdentifier());
        } else {
            this.nodeId = super.getNodeIdBytes();
            log.info("Using a newly generated nodeId {} to generate Type 1 UUIDs", (Object)this.getNodeIdentifier());
        }
    }

    private void useRandomMode() {
        this.canSaveState = false;
        this.nodeId = super.getNodeIdBytes();
        log.info("Explicitly using a new random ID {} to generate Type 1 UUIDs", (Object)this.getNodeIdentifier());
    }

    public String getNodeIdentifier() {
        if (this.nodeId == null) {
            return "none";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nodeId.length; ++i) {
            sb.append(String.format("%02X%s", this.nodeId[i], i < this.nodeId.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }

    private boolean restoreState() throws IOException {
        Properties prop = new Properties();
        if (!this.stateFile.exists()) {
            log.debug("State file '{}' does not exist", (Object)this.stateFile);
            return false;
        }
        try (FileInputStream is = new FileInputStream(this.stateFile);){
            prop.load(is);
        }
        String propNodeId = prop.getProperty("nodeId");
        if (propNodeId == null || propNodeId.isEmpty()) {
            log.warn("State file '{}' is incomplete", (Object)this.stateFile);
            return false;
        }
        try {
            if (this.nodeId == null) {
                this.nodeId = UuidV1IdGenerator.parseAlternativeNodeId(propNodeId);
            } else if (!this.getNodeIdentifier().equals(propNodeId)) {
                log.warn("The nodeId in the state file '{}' has changed from {} to {}. This can happen when MAC address changes or when two containers share the same state file", new Object[]{this.stateFile, propNodeId, this.getNodeIdentifier()});
                return false;
            }
            Integer seq = Integer.valueOf(prop.getProperty("clockSeq")) & 0x3FFF;
            Long ts = Long.valueOf(prop.getProperty("timeStamp"));
            this.clockSeq.set(seq);
            this.timeStamp.set(ts);
            log.debug("State successfully restored: {}", (Object)prop);
            return true;
        }
        catch (IllegalArgumentException nfe) {
            log.error("State file '{}' is corrupt", (Object)this.stateFile, (Object)nfe);
            return false;
        }
    }

    @Override
    protected void saveState() {
        if (!this.canSaveState) {
            return;
        }
        Properties prop = new Properties();
        prop.setProperty("nodeId", this.getNodeIdentifier());
        prop.setProperty("clockSeq", String.valueOf(this.clockSeq.get()));
        prop.setProperty("timeStamp", String.valueOf(this.timeStamp.get()));
        File dir = this.stateFile.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(this.stateFile);){
            prop.store(os, "ebean uuid state file");
            log.debug("Persisted state to '{}'", (Object)this.stateFile);
        }
        catch (IOException e) {
            log.error("Could not persist uuid state to '{}'", (Object)this.stateFile, (Object)e);
        }
    }

    @Override
    protected byte[] getNodeIdBytes() {
        return this.nodeId;
    }
}

