/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.type.EnumToDbIntegerMap;
import io.ebeaninternal.server.type.EnumToDbStringMap;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

abstract class EnumToDbValueMap<T> {
    final LinkedHashMap<Object, T> keyMap;
    final LinkedHashMap<T, Object> valueMap;
    final HashMap<Object, Object> nameMap;
    final boolean allowNulls;
    final boolean isIntegerType;

    static EnumToDbValueMap<?> create(boolean integerType) {
        return integerType ? new EnumToDbIntegerMap() : new EnumToDbStringMap();
    }

    EnumToDbValueMap() {
        this(false, false);
    }

    EnumToDbValueMap(boolean allowNulls, boolean isIntegerType) {
        this.allowNulls = allowNulls;
        this.isIntegerType = isIntegerType;
        this.keyMap = new LinkedHashMap();
        this.valueMap = new LinkedHashMap();
        this.nameMap = new HashMap();
    }

    boolean isIntegerType() {
        return this.isIntegerType;
    }

    public Iterator<T> dbValues() {
        return this.valueMap.keySet().iterator();
    }

    public abstract void bind(DataBinder var1, Object var2) throws SQLException;

    public abstract Object read(DataReader var1) throws SQLException;

    public abstract int getDbType();

    public abstract EnumToDbValueMap<T> add(Object var1, String var2, String var3);

    protected void addInternal(Object beanValue, T dbValue, String name) {
        this.keyMap.put(beanValue, dbValue);
        this.valueMap.put(dbValue, beanValue);
        this.nameMap.put(name, beanValue);
    }

    public T getDbValue(Object beanValue) {
        if (beanValue == null) {
            return null;
        }
        T dbValue = this.keyMap.get(beanValue);
        if (dbValue == null && !this.allowNulls) {
            String msg = "DB value for " + beanValue + " not found in " + this.keyMap;
            throw new IllegalArgumentException(msg);
        }
        return dbValue;
    }

    public Object getBeanValue(Object dbValue) {
        if (dbValue == null) {
            return null;
        }
        Object beanValue = this.valueMap.get(dbValue);
        if (beanValue == null) {
            beanValue = this.nameMap.get(dbValue);
        }
        if (beanValue == null && !this.allowNulls) {
            throw new IllegalArgumentException("Bean value for " + dbValue + " not found in " + this.valueMap);
        }
        return beanValue;
    }
}

