/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeaninternal.server.type.ScalarTypeBool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public final class ScalarTypeBoolean {

    public static abstract class BooleanBase
    extends ScalarTypeBase<Boolean>
    implements ScalarTypeBool {
        BooleanBase(boolean jdbcNative, int jdbcType) {
            super(Boolean.class, jdbcNative, jdbcType);
        }

        @Override
        public int getLogicalType() {
            return 16;
        }

        @Override
        public abstract String getDbFalseLiteral();

        @Override
        public abstract String getDbTrueLiteral();

        public String formatValue(Boolean t) {
            return t.toString();
        }

        public Boolean parse(String value) {
            return Boolean.valueOf(value);
        }

        public Boolean readData(DataInput dataInput) throws IOException {
            if (!dataInput.readBoolean()) {
                return null;
            }
            return dataInput.readBoolean();
        }

        public void writeData(DataOutput dataOutput, Boolean val) throws IOException {
            if (val == null) {
                dataOutput.writeBoolean(false);
            } else {
                dataOutput.writeBoolean(true);
                dataOutput.writeBoolean(val);
            }
        }

        public Boolean jsonRead(JsonParser parser) {
            return JsonToken.VALUE_TRUE == parser.getCurrentToken() ? Boolean.TRUE : Boolean.FALSE;
        }

        public void jsonWrite(JsonGenerator writer, Boolean value) throws IOException {
            writer.writeBoolean(value.booleanValue());
        }

        public DocPropertyType getDocType() {
            return DocPropertyType.BOOLEAN;
        }
    }

    static final class StringBoolean
    extends BooleanBase {
        private final String trueValue;
        private final String falseValue;

        StringBoolean(String trueValue, String falseValue) {
            super(false, 12);
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public String getDbFalseLiteral() {
            return "'" + this.falseValue + "'";
        }

        @Override
        public String getDbTrueLiteral() {
            return "'" + this.trueValue + "'";
        }

        public int getLength() {
            return Math.max(this.trueValue.length(), this.falseValue.length());
        }

        public void bind(DataBinder binder, Boolean value) throws SQLException {
            if (value == null) {
                binder.setNull(12);
            } else {
                binder.setString(this.toString(value));
            }
        }

        public Boolean read(DataReader reader) throws SQLException {
            String string = reader.getString();
            if (string == null) {
                return null;
            }
            if (string.equals(this.trueValue)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object toJdbcType(Object value) {
            return this.toString(value);
        }

        public String toString(Object value) {
            if (value == null) {
                return null;
            }
            Boolean b = (Boolean)value;
            return b != false ? this.trueValue : this.falseValue;
        }

        public Boolean toBeanType(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (this.trueValue.equals(value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    static final class IntBoolean
    extends BooleanBase {
        private final Integer trueValue;
        private final Integer falseValue;

        IntBoolean(Integer trueValue, Integer falseValue) {
            super(false, 4);
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public String getDbFalseLiteral() {
            return this.falseValue.toString();
        }

        @Override
        public String getDbTrueLiteral() {
            return this.trueValue.toString();
        }

        public int getLength() {
            return 1;
        }

        public void bind(DataBinder binder, Boolean value) throws SQLException {
            if (value == null) {
                binder.setNull(4);
            } else {
                binder.setInt(this.toInteger(value).intValue());
            }
        }

        public Boolean read(DataReader reader) throws SQLException {
            Integer i = reader.getInt();
            if (i == null) {
                return null;
            }
            if (i.equals(this.trueValue)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object toJdbcType(Object value) {
            return this.toInteger(value);
        }

        Integer toInteger(Object value) {
            if (value == null) {
                return null;
            }
            Boolean b = (Boolean)value;
            return b != false ? this.trueValue : this.falseValue;
        }

        public Boolean toBeanType(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (this.trueValue.equals(value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    static final class BitBoolean
    extends BooleanBase {
        BitBoolean() {
            super(true, -7);
        }

        @Override
        public String getDbFalseLiteral() {
            return "0";
        }

        @Override
        public String getDbTrueLiteral() {
            return "1";
        }

        public Boolean toBeanType(Object value) {
            return BasicTypeConverter.toBoolean(value);
        }

        public Object toJdbcType(Object value) {
            return BasicTypeConverter.toBoolean(value);
        }

        public void bind(DataBinder binder, Boolean value) throws SQLException {
            if (value == null) {
                binder.setNull(-7);
            } else {
                binder.setBoolean(value.booleanValue());
            }
        }

        public Boolean read(DataReader reader) throws SQLException {
            return reader.getBoolean();
        }
    }

    public static final class Native
    extends BooleanBase {
        public Native() {
            super(true, 16);
        }

        @Override
        public String getDbFalseLiteral() {
            return "false";
        }

        @Override
        public String getDbTrueLiteral() {
            return "true";
        }

        public Boolean toBeanType(Object value) {
            return BasicTypeConverter.toBoolean(value);
        }

        public Object toJdbcType(Object value) {
            return BasicTypeConverter.convert(value, this.jdbcType);
        }

        public void bind(DataBinder binder, Boolean value) throws SQLException {
            if (value == null) {
                binder.setNull(16);
            } else {
                binder.setBoolean(value.booleanValue());
            }
        }

        public Boolean read(DataReader reader) throws SQLException {
            return reader.getBoolean();
        }
    }
}

