/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DocPropertyType;
import io.ebean.text.TextException;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public abstract class ScalarTypeBytesBase
extends ScalarTypeBase<byte[]> {
    ScalarTypeBytesBase(boolean jdbcNative, int jdbcType) {
        super(byte[].class, jdbcNative, jdbcType);
    }

    public boolean isBinaryType() {
        return true;
    }

    public byte[] convertToBytes(Object value) {
        return (byte[])value;
    }

    public void bind(DataBinder binder, byte[] value) throws SQLException {
        if (value == null) {
            binder.setNull(this.jdbcType);
        } else {
            binder.setBytes(value);
        }
    }

    public Object toJdbcType(Object value) {
        return value;
    }

    public byte[] toBeanType(Object value) {
        return (byte[])value;
    }

    public String formatValue(byte[] t) {
        throw new TextException("Not supported");
    }

    public byte[] parse(String value) {
        throw new TextException("Not supported");
    }

    public byte[] readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        int len = dataInput.readInt();
        byte[] buf = new byte[len];
        dataInput.readFully(buf, 0, buf.length);
        return buf;
    }

    public void writeData(DataOutput dataOutput, byte[] v) throws IOException {
        if (v == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            byte[] bytes = this.convertToBytes(v);
            dataOutput.writeInt(bytes.length);
            dataOutput.write(bytes);
        }
    }

    public void jsonWrite(JsonGenerator writer, byte[] value) throws IOException {
        writer.writeBinary(value);
    }

    public byte[] jsonRead(JsonParser parser) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(500);
        parser.readBinaryValue((OutputStream)out);
        return out.toByteArray();
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.BINARY;
    }
}

