/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebeaninternal.dbmigration.migration.AddColumn;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AddTableComment;
import io.ebeaninternal.dbmigration.migration.AddUniqueConstraint;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.AlterForeignKey;
import io.ebeaninternal.dbmigration.migration.AlterTable;
import io.ebeaninternal.dbmigration.migration.ChangeSet;
import io.ebeaninternal.dbmigration.migration.ChangeSetType;
import io.ebeaninternal.dbmigration.migration.CreateIndex;
import io.ebeaninternal.dbmigration.migration.CreateSchema;
import io.ebeaninternal.dbmigration.migration.DropColumn;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropIndex;
import io.ebeaninternal.dbmigration.migration.Migration;
import io.ebeaninternal.dbmigration.model.MIndex;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.ModelContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelDiff {
    private final ModelContainer baseModel;
    private final List<Object> applyChanges = new ArrayList<Object>();
    private final List<Object> dropChanges = new ArrayList<Object>();

    public ModelDiff(ModelContainer baseModel) {
        this.baseModel = baseModel;
    }

    public ModelDiff() {
        this.baseModel = new ModelContainer();
    }

    public boolean isEmpty() {
        return this.applyChanges.isEmpty() && this.dropChanges.isEmpty();
    }

    public Migration getMigration() {
        Migration migration = new Migration();
        if (!this.applyChanges.isEmpty()) {
            migration.getChangeSet().add(this.getApplyChangeSet());
        }
        if (!this.dropChanges.isEmpty()) {
            migration.getChangeSet().add(this.getDropChangeSet());
        }
        return migration;
    }

    List<Object> getApplyChanges() {
        return this.applyChanges;
    }

    List<Object> getDropChanges() {
        return this.dropChanges;
    }

    public ChangeSet getApplyChangeSet() {
        ChangeSet applyChangeSet = new ChangeSet();
        applyChangeSet.setType(ChangeSetType.APPLY);
        applyChangeSet.getChangeSetChildren().addAll(this.applyChanges);
        return applyChangeSet;
    }

    ChangeSet getDropChangeSet() {
        ChangeSet createChangeSet = new ChangeSet();
        createChangeSet.setType(ChangeSetType.PENDING_DROPS);
        createChangeSet.getChangeSetChildren().addAll(this.dropChanges);
        return createChangeSet;
    }

    public void compareTo(ModelContainer newModel) {
        Set<String> baseSchemas = this.baseModel.getSchemas();
        for (String schema : newModel.getSchemas()) {
            if (baseSchemas.contains(schema)) continue;
            this.addCreateSchema(schema);
        }
        Map<String, MTable> newTables = newModel.getTables();
        for (MTable newTable : newTables.values()) {
            MTable currentTable = this.baseModel.getTable(newTable.getName());
            if (currentTable == null) {
                this.addNewTable(newTable);
                continue;
            }
            this.compareTables(currentTable, newTable);
        }
        for (MTable existingTable : this.baseModel.getTables().values()) {
            if (newTables.containsKey(existingTable.getName())) continue;
            this.addDropTable(existingTable);
        }
        for (MIndex newIndex : newModel.allIndexes()) {
            MIndex currentIndex = this.baseModel.getIndex(newIndex);
            if (currentIndex == null) {
                this.addCreateIndex(newIndex.createIndex());
                continue;
            }
            this.compareIndexes(currentIndex, newIndex);
        }
        for (MIndex existingIndex : this.baseModel.allIndexes()) {
            if (!newModel.dropIndex(existingIndex)) continue;
            this.addDropIndex(existingIndex.dropIndex());
        }
        this.baseModel.registerPendingHistoryDropColumns(newModel);
        if (!this.dropChanges.isEmpty()) {
            newModel.registerPendingHistoryDropColumns(this.getDropChangeSet());
        }
    }

    protected void addCreateSchema(String schema) {
        CreateSchema createSchema = new CreateSchema();
        createSchema.setName(schema);
        this.applyChanges.add(createSchema);
    }

    protected void addDropTable(MTable existingTable) {
        this.dropChanges.add(existingTable.dropTable());
    }

    protected void addNewTable(MTable newTable) {
        this.applyChanges.add(newTable.createTable());
    }

    protected void compareTables(MTable currentTable, MTable newTable) {
        currentTable.compare(this, newTable);
    }

    protected void compareIndexes(MIndex currentIndex, MIndex newIndex) {
        currentIndex.compare(this, newIndex);
    }

    public void addAlterColumn(AlterColumn alterColumn) {
        this.applyChanges.add(alterColumn);
    }

    public void addAddColumn(AddColumn addColumn) {
        this.applyChanges.add(addColumn);
    }

    public void addDropColumn(DropColumn dropColumn) {
        this.dropChanges.add(dropColumn);
    }

    public void addAddHistoryTable(AddHistoryTable addHistoryTable) {
        this.applyChanges.add(addHistoryTable);
    }

    public void addDropHistoryTable(DropHistoryTable dropHistoryTable) {
        this.dropChanges.add(dropHistoryTable);
    }

    public void addDropIndex(DropIndex dropIndex) {
        this.applyChanges.add(dropIndex);
    }

    public void addCreateIndex(CreateIndex createIndex) {
        this.applyChanges.add(createIndex);
    }

    public void addTableComment(AddTableComment addTableComment) {
        this.applyChanges.add(addTableComment);
    }

    public void addUniqueConstraint(AddUniqueConstraint addUniqueConstraint) {
        this.applyChanges.add(addUniqueConstraint);
    }

    public void addAlterForeignKey(AlterForeignKey alterForeignKey) {
        this.applyChanges.add(alterForeignKey);
    }

    public void addAlterTable(AlterTable alterTable) {
        this.applyChanges.add(alterTable);
    }
}

