/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.AwsSDKv1;
import io.ebean.test.containers.AwsSDKv2;
import io.ebean.test.containers.BaseBuilder;
import io.ebean.test.containers.BaseContainer;
import io.ebean.test.containers.LocalstackSdkV1;
import io.ebean.test.containers.LocalstackSdkV2;
import io.ebean.test.containers.TrimSplit;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Properties;

public class Localstack2Container
extends BaseContainer<Localstack2Container> {
    private final List<String> serviceNames;
    private final String services;
    private final String awsRegion;
    private final String startWeb;
    private final String healthUri;

    @Override
    public Localstack2Container start() {
        this.startOrThrow();
        return this;
    }

    public static Builder builder(String version) {
        return new Builder(version);
    }

    public Localstack2Container(Builder builder) {
        super(builder);
        this.services = builder.services;
        this.awsRegion = builder.awsRegion;
        this.startWeb = builder.startWeb;
        this.healthUri = builder.healthUri;
        this.serviceNames = TrimSplit.split(this.services);
    }

    private String healthUrl() {
        return String.format("http://%s:%s/%s", this.config.getHost(), this.config.getPort(), this.healthUri);
    }

    public AwsSDKv2 sdk() {
        return this.sdk2();
    }

    public AwsSDKv2 sdk2() {
        return new LocalstackSdkV2(this.awsRegion, this.endpoint());
    }

    public AwsSDKv1 sdk1() {
        return new LocalstackSdkV1(this.awsRegion, this.endpointUrl());
    }

    public URI endpoint() {
        return URI.create(this.endpointUrl());
    }

    public String endpointUrl() {
        return String.format("http://%s:%s/", this.config.getHost(), this.config.getPort());
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    @Override
    boolean checkConnectivity() {
        try {
            String content = this.readUrlContent(this.healthUrl());
            if (log.isLoggable(System.Logger.Level.TRACE)) {
                log.log(System.Logger.Level.TRACE, "checkConnectivity content: {0}", content);
            }
            return this.checkStatus(content);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean checkStatus(String content) {
        String[] serviceEntries = content.split(",");
        for (String serviceName : this.serviceNames) {
            if (this.isServiceReady(serviceName, serviceEntries)) continue;
            return false;
        }
        return true;
    }

    private boolean isServiceReady(String serviceName, String[] serviceEntries) {
        String key = "\"" + serviceName + "\":";
        for (String serviceEntry : serviceEntries) {
            if ((!serviceEntry.contains(key) || !serviceEntry.contains("\"running\"")) && !serviceEntry.contains("\"available\"")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        if (this.config.getAdminPort() > 0) {
            args.add("-p");
            args.add(this.config.getAdminPort() + ":" + this.config.getAdminInternalPort());
        }
        if (this.notEmpty(this.services)) {
            args.add("-e");
            args.add("LOCALSTACK_SERVICES=" + this.services);
        }
        if (this.notEmpty(this.awsRegion)) {
            args.add("-e");
            args.add("DEFAULT_REGION=" + this.awsRegion);
        }
        if (this.notEmpty(this.startWeb)) {
            args.add("-e");
            args.add("START_WEB=" + this.startWeb);
        }
        args.add("-e");
        args.add("DEBUG=1");
        args.add(this.config.image());
        return this.createProcessBuilder(args);
    }

    public static class Builder
    extends BaseBuilder<Localstack2Container, Builder> {
        private String services = "dynamodb";
        private String awsRegion = "ap-southeast-2";
        private String healthUri = "_localstack/health";
        private String startWeb;

        private Builder(String version) {
            super("localstack", 4566, 4566, version);
            this.image = "localstack/localstack:" + version;
        }

        @Override
        protected void extraProperties(Properties properties) {
            super.extraProperties(properties);
            this.services = this.prop(properties, "services", this.services);
            this.awsRegion = this.prop(properties, "awsRegion", this.awsRegion);
            this.startWeb = this.prop(properties, "startWeb", this.startWeb);
            this.healthUri = this.prop(properties, "healthUri", this.healthUri);
        }

        public Builder services(String services) {
            this.services = services;
            return (Builder)this.self();
        }

        public Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return (Builder)this.self();
        }

        public Builder startWeb(String startWeb) {
            this.startWeb = startWeb;
            return (Builder)this.self();
        }

        public Builder healthUri(String healthUri) {
            this.healthUri = healthUri;
            return (Builder)this.self();
        }

        @Override
        public Localstack2Container build() {
            return new Localstack2Container(this);
        }

        @Override
        public Localstack2Container start() {
            return this.build().start();
        }
    }
}

