/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.sftp;

import com.crashlytics.dependency.reloc.com.jcraft.jsch.JSch;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.JSchException;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.Proxy;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.ProxyHTTP;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.ProxySOCKS5;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.Session;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.UserInfo;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.util.Os;
import java.io.File;
import java.util.Properties;

public class SftpClientFactory {
    private static final String SSH_DIR_NAME = ".ssh";

    private SftpClientFactory() {
    }

    public static Session createConnection(String hostname, int port, char[] username, char[] password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        Session session;
        JSch jsch = new JSch();
        File sshDir = null;
        File knownHostsFile = SftpFileSystemConfigBuilder.getInstance().getKnownHosts(fileSystemOptions);
        File[] identities = SftpFileSystemConfigBuilder.getInstance().getIdentities(fileSystemOptions);
        if (knownHostsFile != null) {
            try {
                jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
            }
            catch (JSchException e) {
                throw new FileSystemException("vfs.provider.sftp/known-hosts.error", knownHostsFile.getAbsolutePath(), (Throwable)e);
            }
        }
        if (sshDir == null) {
            sshDir = SftpClientFactory.findSshDir();
        }
        if ((knownHostsFile = new File(sshDir, "known_hosts")).isFile() && knownHostsFile.canRead()) {
            try {
                jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
            }
            catch (JSchException e) {
                throw new FileSystemException("vfs.provider.sftp/known-hosts.error", knownHostsFile.getAbsolutePath(), (Throwable)e);
            }
        }
        if (identities != null) {
            for (int iterIdentities = 0; iterIdentities < identities.length; ++iterIdentities) {
                File privateKeyFile = identities[iterIdentities];
                try {
                    jsch.addIdentity(privateKeyFile.getAbsolutePath());
                    continue;
                }
                catch (JSchException e) {
                    throw new FileSystemException("vfs.provider.sftp/load-private-key.error", privateKeyFile, (Throwable)e);
                }
            }
        } else {
            File privateKeyFile;
            if (sshDir == null) {
                sshDir = SftpClientFactory.findSshDir();
            }
            if ((privateKeyFile = new File(sshDir, "id_rsa")).isFile() && privateKeyFile.canRead()) {
                try {
                    jsch.addIdentity(privateKeyFile.getAbsolutePath());
                }
                catch (JSchException e) {
                    throw new FileSystemException("vfs.provider.sftp/load-private-key.error", privateKeyFile, (Throwable)e);
                }
            }
        }
        try {
            String proxyHost;
            String compression;
            UserInfo userInfo;
            Integer timeout;
            session = jsch.getSession(new String(username), hostname, port);
            if (password != null) {
                session.setPassword(new String(password));
            }
            if ((timeout = SftpFileSystemConfigBuilder.getInstance().getTimeout(fileSystemOptions)) != null) {
                session.setTimeout(timeout);
            }
            if ((userInfo = SftpFileSystemConfigBuilder.getInstance().getUserInfo(fileSystemOptions)) != null) {
                session.setUserInfo(userInfo);
            }
            Properties config = new Properties();
            String strictHostKeyChecking = SftpFileSystemConfigBuilder.getInstance().getStrictHostKeyChecking(fileSystemOptions);
            if (strictHostKeyChecking != null) {
                config.setProperty("StrictHostKeyChecking", strictHostKeyChecking);
            }
            if ((compression = SftpFileSystemConfigBuilder.getInstance().getCompression(fileSystemOptions)) != null) {
                config.setProperty("compression.s2c", compression);
                config.setProperty("compression.c2s", compression);
            }
            if ((proxyHost = SftpFileSystemConfigBuilder.getInstance().getProxyHost(fileSystemOptions)) != null) {
                int proxyPort = SftpFileSystemConfigBuilder.getInstance().getProxyPort(fileSystemOptions);
                SftpFileSystemConfigBuilder.ProxyType proxyType = SftpFileSystemConfigBuilder.getInstance().getProxyType(fileSystemOptions);
                Proxy proxy = null;
                if (SftpFileSystemConfigBuilder.PROXY_HTTP.equals(proxyType)) {
                    proxy = proxyPort != 0 ? new ProxyHTTP(proxyHost, proxyPort) : new ProxyHTTP(proxyHost);
                } else if (SftpFileSystemConfigBuilder.PROXY_SOCKS5.equals(proxyType)) {
                    proxy = proxyPort != 0 ? new ProxySOCKS5(proxyHost, proxyPort) : new ProxySOCKS5(proxyHost);
                }
                if (proxy != null) {
                    session.setProxy(proxy);
                }
            }
            if (config.size() > 0) {
                session.setConfig(config);
            }
            session.connect();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", new Object[]{hostname}, (Throwable)exc);
        }
        return session;
    }

    private static File findSshDir() {
        File sshDir;
        String sshDirPath = System.getProperty("vfs.sftp.sshdir");
        if (sshDirPath != null && (sshDir = new File(sshDirPath)).exists()) {
            return sshDir;
        }
        sshDir = new File(System.getProperty("user.home"), SSH_DIR_NAME);
        if (sshDir.exists()) {
            return sshDir;
        }
        if (Os.isFamily(Os.OS_FAMILY_WINDOWS)) {
            String userName = System.getProperty("user.name");
            sshDir = new File("C:\\cygwin\\home\\" + userName + "\\" + SSH_DIR_NAME);
            if (sshDir.exists()) {
                return sshDir;
            }
        }
        return new File("");
    }
}

