/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.ant;

import com.crashlytics.reloc.org.apache.ivy.core.IvyContext;
import com.crashlytics.reloc.org.apache.ivy.core.IvyPatternHelper;
import com.crashlytics.reloc.org.apache.ivy.core.event.IvyEvent;
import com.crashlytics.reloc.org.apache.ivy.plugins.trigger.AbstractTrigger;
import com.crashlytics.reloc.org.apache.ivy.plugins.trigger.Trigger;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import com.crashlytics.reloc.org.apache.tools.ant.Project;
import com.crashlytics.reloc.org.apache.tools.ant.taskdefs.CallTarget;
import com.crashlytics.reloc.org.apache.tools.ant.taskdefs.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class AntCallTrigger
extends AbstractTrigger
implements Trigger {
    private boolean onlyonce = true;
    private String target = null;
    private Collection calls = new ArrayList();
    private String prefix;

    public void progress(IvyEvent event) {
        Project project = (Project)IvyContext.peekInContextStack("ant-project");
        if (project == null) {
            Message.info("ant call trigger can only be used from an ant build. Ignoring.");
            return;
        }
        if (this.onlyonce && this.isTriggered(event)) {
            Message.verbose("call already triggered for this event, skipping: " + event);
        } else {
            CallTarget call = new CallTarget();
            call.setProject(project);
            call.setTaskName("antcall");
            Map attributes = event.getAttributes();
            String target = IvyPatternHelper.substituteTokens(this.getTarget(), attributes);
            call.setTarget(target);
            Iterator iter = attributes.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)attributes.get(key);
                Property p = call.createParam();
                p.setName(this.prefix == null ? key : this.prefix + key);
                p.setValue(value == null ? "" : value);
            }
            Message.verbose("triggering ant call: target=" + target + " for " + event);
            call.execute();
            this.markTriggered(event);
            Message.debug("triggered ant call finished: target=" + target + " for " + event);
        }
    }

    private void markTriggered(IvyEvent event) {
        this.calls.add(event);
    }

    private boolean isTriggered(IvyEvent event) {
        return this.calls.contains(event);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isOnlyonce() {
        return this.onlyonce;
    }

    public void setOnlyonce(boolean onlyonce) {
        this.onlyonce = onlyonce;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        if (!prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }
}

