/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.ant;

import com.crashlytics.reloc.org.apache.ivy.ant.IvyDependencyArtifact;
import com.crashlytics.reloc.org.apache.ivy.ant.IvyDependencyConf;
import com.crashlytics.reloc.org.apache.ivy.ant.IvyDependencyExclude;
import com.crashlytics.reloc.org.apache.ivy.ant.IvyDependencyInclude;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultIncludeRule;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.core.settings.IvySettings;
import com.crashlytics.reloc.org.apache.tools.ant.BuildException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IvyDependency {
    private List confs = new ArrayList();
    private List artifacts = new ArrayList();
    private List excludes = new ArrayList();
    private List includes = new ArrayList();
    private String org;
    private String name;
    private String rev;
    private String branch;
    private String conf;
    private boolean changing;
    private boolean force;
    private boolean transitive = true;

    public IvyDependencyConf createConf() {
        IvyDependencyConf c = new IvyDependencyConf();
        this.confs.add(c);
        return c;
    }

    public IvyDependencyArtifact createArtifact() {
        IvyDependencyArtifact artifact = new IvyDependencyArtifact();
        this.artifacts.add(artifact);
        return artifact;
    }

    public IvyDependencyExclude createExclude() {
        IvyDependencyExclude exclude = new IvyDependencyExclude();
        this.excludes.add(exclude);
        return exclude;
    }

    public IvyDependencyInclude createInclude() {
        IvyDependencyInclude include = new IvyDependencyInclude();
        this.includes.add(include);
        return include;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public void setChanging(boolean changing) {
        this.changing = changing;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public void setTransitive(boolean transitive) {
        this.transitive = transitive;
    }

    DependencyDescriptor asDependencyDescriptor(ModuleDescriptor md, String masterConf, IvySettings settings) {
        if (this.org == null) {
            throw new BuildException("'org' is required on ");
        }
        if (this.name == null) {
            throw new BuildException("'name' is required when using inline mode");
        }
        ModuleRevisionId mrid = ModuleRevisionId.newInstance(this.org, this.name, this.branch, this.rev);
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(md, mrid, this.force, this.changing, this.transitive);
        if (this.conf != null) {
            dd.addDependencyConfiguration(masterConf, this.conf);
        } else {
            dd.addDependencyConfiguration(masterConf, "*");
        }
        Iterator itConfs = this.confs.iterator();
        while (itConfs.hasNext()) {
            IvyDependencyConf c = (IvyDependencyConf)itConfs.next();
            c.addConf(dd, masterConf);
        }
        Iterator itArtifacts = this.artifacts.iterator();
        while (itArtifacts.hasNext()) {
            IvyDependencyArtifact artifact = (IvyDependencyArtifact)itArtifacts.next();
            artifact.addArtifact(dd, masterConf);
        }
        Iterator itExcludes = this.excludes.iterator();
        while (itExcludes.hasNext()) {
            IvyDependencyExclude exclude = (IvyDependencyExclude)itExcludes.next();
            DefaultExcludeRule rule = exclude.asRule(settings);
            dd.addExcludeRule(masterConf, rule);
        }
        Iterator itIncludes = this.includes.iterator();
        while (itIncludes.hasNext()) {
            IvyDependencyInclude include = (IvyDependencyInclude)itIncludes.next();
            DefaultIncludeRule rule = include.asRule(settings);
            dd.addIncludeRule(masterConf, rule);
        }
        return dd;
    }
}

