/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.core;

import com.crashlytics.reloc.org.apache.ivy.core.IvyContext;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.osgi.util.Version;
import com.crashlytics.reloc.org.apache.ivy.plugins.latest.ArtifactInfo;
import com.crashlytics.reloc.org.apache.ivy.plugins.latest.ComparatorLatestStrategy;
import com.crashlytics.reloc.org.apache.ivy.plugins.version.VersionMatcher;
import java.text.ParseException;
import java.util.Comparator;

public class OsgiLatestStrategy
extends ComparatorLatestStrategy {
    private final Comparator mridComparator = new MridComparator();
    private final Comparator artifactInfoComparator = new ArtifactInfoComparator();

    public OsgiLatestStrategy() {
        this.setComparator(this.artifactInfoComparator);
        this.setName("latest-osgi");
    }

    final class ArtifactInfoComparator
    implements Comparator {
        ArtifactInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            return this.compare((ArtifactInfo)o1, (ArtifactInfo)o2);
        }

        public int compare(ArtifactInfo o1, ArtifactInfo o2) {
            String rev1 = o1.getRevision();
            String rev2 = o2.getRevision();
            VersionMatcher vmatcher = IvyContext.getContext().getSettings().getVersionMatcher();
            ModuleRevisionId mrid1 = ModuleRevisionId.newInstance("", "", rev1);
            ModuleRevisionId mrid2 = ModuleRevisionId.newInstance("", "", rev2);
            if (vmatcher.isDynamic(mrid1)) {
                int c = vmatcher.compare(mrid1, mrid2, OsgiLatestStrategy.this.mridComparator);
                return c >= 0 ? 1 : -1;
            }
            if (vmatcher.isDynamic(mrid2)) {
                int c = vmatcher.compare(mrid2, mrid1, OsgiLatestStrategy.this.mridComparator);
                return c >= 0 ? -1 : 1;
            }
            return OsgiLatestStrategy.this.mridComparator.compare(mrid1, mrid2);
        }
    }

    final class MridComparator
    implements Comparator {
        MridComparator() {
        }

        public int compare(Object o1, Object o2) {
            return this.compare((ModuleRevisionId)o1, (ModuleRevisionId)o2);
        }

        public int compare(ModuleRevisionId o1, ModuleRevisionId o2) {
            Version v2;
            Version v1;
            try {
                v1 = new Version(o1.getRevision());
                v2 = new Version(o2.getRevision());
            }
            catch (ParseException e) {
                throw new RuntimeException("Uncomparable versions:" + o1.getRevision() + " and " + o2.getRevision() + " (" + e.getMessage() + ")");
            }
            return v1.compareTo(v2);
        }
    }
}

