/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.repo;

import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.Artifact;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.Configuration;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.core.report.DownloadStatus;
import com.crashlytics.reloc.org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.IvyNode;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.ResolveData;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.ResolvedModuleRevision;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleInfoAdapter;
import com.crashlytics.reloc.org.apache.ivy.osgi.repo.BundleCapabilityAndLocation;
import com.crashlytics.reloc.org.apache.ivy.osgi.repo.RepoDescriptor;
import com.crashlytics.reloc.org.apache.ivy.osgi.util.Version;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.Resource;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.url.URLRepository;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.url.URLResource;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.BasicResolver;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.util.MDResolvedResource;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.util.ResolvedResource;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractOSGiResolver
extends BasicResolver {
    private static final String CAPABILITY_EXTRA_ATTR = "osgi_bundle";
    private RepoDescriptor repoDescriptor = null;
    private URLRepository repository = new URLRepository();
    private RequirementStrategy requirementStrategy = RequirementStrategy.noambiguity;

    public void setRequirementStrategy(RequirementStrategy importPackageStrategy) {
        this.requirementStrategy = importPackageStrategy;
    }

    public void setRequirementStrategy(String strategy) {
        this.setRequirementStrategy(RequirementStrategy.valueOf(strategy));
    }

    protected void setRepoDescriptor(RepoDescriptor repoDescriptor) {
        this.repoDescriptor = repoDescriptor;
    }

    public URLRepository getRepository() {
        return this.repository;
    }

    protected void ensureInit() {
        if (this.repoDescriptor == null) {
            this.init();
        }
    }

    protected abstract void init();

    private RepoDescriptor getRepoDescriptor() {
        this.ensureInit();
        return this.repoDescriptor;
    }

    public boolean isAllownomd() {
        return false;
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        String osgiType = mrid.getOrganisation();
        if (osgiType == null) {
            throw new RuntimeException("Unsupported OSGi module Id: " + mrid.getModuleId());
        }
        String id = mrid.getName();
        Set mds = this.getRepoDescriptor().findModule(osgiType, id);
        if (mds == null || mds.isEmpty()) {
            Message.verbose("\t " + id + " not found.");
            return null;
        }
        ResolvedResource[] ret = "bundle".equals(osgiType) ? this.findBundle(dd, data, mds) : this.findCapability(dd, data, mds);
        ResolvedResource found = this.findResource(ret, this.getDefaultRMDParser(dd.getDependencyId()), mrid, data.getDate());
        if (found == null) {
            Message.debug("\t" + this.getName() + ": no resource found for " + mrid);
        }
        return found;
    }

    public ResolvedResource[] findBundle(DependencyDescriptor dd, ResolveData data, Set mds) {
        ResolvedResource[] ret = new ResolvedResource[mds.size()];
        int i = 0;
        Iterator itMd = mds.iterator();
        while (itMd.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)itMd.next();
            MetadataArtifactDownloadReport report = new MetadataArtifactDownloadReport(null);
            report.setDownloadStatus(DownloadStatus.NO);
            report.setSearched(true);
            ResolvedModuleRevision rmr = new ResolvedModuleRevision(this, this, md, report);
            MDResolvedResource mdrr = new MDResolvedResource(null, md.getRevision(), rmr);
            ret[i++] = mdrr;
        }
        return ret;
    }

    public ResolvedResource[] findCapability(DependencyDescriptor dd, ResolveData data, Set mds) {
        ResolvedResource[] ret = new ResolvedResource[mds.size()];
        int i = 0;
        Iterator itMd = mds.iterator();
        while (itMd.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)itMd.next();
            IvyNode node = data.getNode(md.getModuleRevisionId());
            if (node != null && node.getDescriptor() != null) {
                return new ResolvedResource[]{this.buildResolvedCapabilityMd(dd, node.getDescriptor())};
            }
            ret[i++] = this.buildResolvedCapabilityMd(dd, md);
        }
        return ret;
    }

    private MDResolvedResource buildResolvedCapabilityMd(DependencyDescriptor dd, ModuleDescriptor md) {
        String org = dd.getDependencyRevisionId().getOrganisation();
        String name = dd.getDependencyRevisionId().getName();
        String rev = (String)md.getExtraInfo().get("_osgi_export_" + name);
        ModuleRevisionId capabilityRev = ModuleRevisionId.newInstance(org, name, rev, Collections.singletonMap(CAPABILITY_EXTRA_ATTR, md.getModuleRevisionId().toString()));
        DefaultModuleDescriptor capabilityMd = new DefaultModuleDescriptor(capabilityRev, "release", new Date());
        String useConf = "use_" + dd.getDependencyRevisionId().getName();
        capabilityMd.addConfiguration(BundleInfoAdapter.CONF_DEFAULT);
        capabilityMd.addConfiguration(BundleInfoAdapter.CONF_OPTIONAL);
        capabilityMd.addConfiguration(BundleInfoAdapter.CONF_TRANSITIVE_OPTIONAL);
        capabilityMd.addConfiguration(new Configuration(useConf));
        DefaultDependencyDescriptor capabilityDD = new DefaultDependencyDescriptor(md.getModuleRevisionId(), false);
        capabilityDD.addDependencyConfiguration("default", "default");
        capabilityDD.addDependencyConfiguration("optional", "optional");
        capabilityDD.addDependencyConfiguration("transitive-optional", "transitive-optional");
        capabilityDD.addDependencyConfiguration(useConf, useConf);
        capabilityMd.addDependency(capabilityDD);
        MetadataArtifactDownloadReport report = new MetadataArtifactDownloadReport(null);
        report.setDownloadStatus(DownloadStatus.NO);
        report.setSearched(true);
        ResolvedModuleRevision rmr = new ResolvedModuleRevision(this, this, capabilityMd, report);
        return new MDResolvedResource(null, capabilityMd.getRevision(), rmr);
    }

    public ResolvedResource findResource(ResolvedResource[] rress, ResourceMDParser rmdparser, ModuleRevisionId mrid, Date date) {
        ResolvedResource found = super.findResource(rress, rmdparser, mrid, date);
        String osgiType = mrid.getOrganisation();
        if (!"bundle".equals(osgiType)) {
            if (rress.length != 1) {
                HashMap<String, ArrayList<ResolvedResource>> matching = new HashMap<String, ArrayList<ResolvedResource>>();
                for (int i = 0; i < rress.length; ++i) {
                    String name = ((MDResolvedResource)rress[i]).getResolvedModuleRevision().getDescriptor().getExtraAttribute(CAPABILITY_EXTRA_ATTR);
                    ArrayList<ResolvedResource> list = (ArrayList<ResolvedResource>)matching.get(name);
                    if (list == null) {
                        list = new ArrayList<ResolvedResource>();
                        matching.put(name, list);
                    }
                    list.add(rress[i]);
                }
                if (matching.keySet().size() != 1) {
                    Iterator itB;
                    Map.Entry entry;
                    if (this.requirementStrategy == RequirementStrategy.first) {
                        Message.warn("Ambiguity for the '" + osgiType + "' requirement " + mrid.getName() + ";version=" + mrid.getRevision());
                        Iterator itMatching = matching.entrySet().iterator();
                        while (itMatching.hasNext()) {
                            entry = itMatching.next();
                            Message.warn("\t" + entry.getKey());
                            itB = ((List)entry.getValue()).iterator();
                            while (itB.hasNext()) {
                                MDResolvedResource c = (MDResolvedResource)itB.next();
                                Message.warn("\t\t" + c.getRevision() + (found == c ? " (selected)" : ""));
                            }
                        }
                    } else if (this.requirementStrategy == RequirementStrategy.noambiguity) {
                        Message.error("Ambiguity for the '" + osgiType + "' requirement " + mrid.getName() + ";version=" + mrid.getRevision());
                        Iterator itMatching = matching.entrySet().iterator();
                        while (itMatching.hasNext()) {
                            entry = itMatching.next();
                            Message.error("\t" + entry.getKey());
                            itB = ((List)entry.getValue()).iterator();
                            while (itB.hasNext()) {
                                MDResolvedResource c = (MDResolvedResource)itB.next();
                                Message.error("\t\t" + c.getRevision() + (found == c ? " (best match)" : ""));
                            }
                        }
                        return null;
                    }
                }
            }
            Message.info("'" + osgiType + "' requirement " + mrid.getName() + ";version=" + mrid.getRevision() + " satisfied by " + ((MDResolvedResource)found).getResolvedModuleRevision().getId().getName() + ";" + found.getRevision());
        }
        return found;
    }

    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        URL url = artifact.getUrl();
        if (url == null) {
            return null;
        }
        Message.verbose("\tusing url for " + artifact + ": " + url);
        this.logArtifactAttempt(artifact, url.toExternalForm());
        URLResource resource = new URLResource(url);
        return new ResolvedResource(resource, artifact.getModuleRevisionId().getRevision());
    }

    protected void checkModuleDescriptorRevision(ModuleDescriptor systemMd, ModuleRevisionId systemMrid) {
        String osgiType = systemMrid.getOrganisation();
        if (osgiType == null || osgiType.equals("bundle")) {
            super.checkModuleDescriptorRevision(systemMd, systemMrid);
        }
    }

    protected Collection filterNames(Collection names) {
        this.getSettings().filterIgnore(names);
        return names;
    }

    protected Collection findNames(Map tokenValues, String token) {
        if ("organisation".equals(token)) {
            return this.getRepoDescriptor().getModuleByCapbilities().keySet();
        }
        String osgiType = (String)tokenValues.get("organisation");
        if (osgiType == null || osgiType.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        String rev = (String)tokenValues.get("revision");
        if ("module".equals(token)) {
            Map moduleByCapbilities = this.getRepoDescriptor().getModuleByCapbilities();
            if (osgiType != null) {
                Map moduleByCapabilityValue = (Map)moduleByCapbilities.get(osgiType);
                if (moduleByCapabilityValue == null) {
                    return Collections.EMPTY_LIST;
                }
                HashSet capabilityValues = new HashSet();
                return moduleByCapabilityValue.keySet();
            }
            HashSet capabilityValues = new HashSet();
            Iterator it = moduleByCapbilities.values().iterator();
            while (it.hasNext()) {
                Map moduleByCapbilityValue = (Map)it.next();
                this.filterCapabilityValues(capabilityValues, moduleByCapbilityValue, tokenValues, rev);
            }
            return capabilityValues;
        }
        if ("revision".equals(token)) {
            String name = (String)tokenValues.get("module");
            ArrayList<String> versions = new ArrayList<String>();
            Set mds = this.getRepoDescriptor().findModule(osgiType, name);
            if (mds != null) {
                Iterator itMd = mds.iterator();
                while (itMd.hasNext()) {
                    ModuleDescriptor md = (ModuleDescriptor)itMd.next();
                    versions.add(md.getRevision());
                }
            }
            return versions;
        }
        if ("conf".equals(token)) {
            Version v;
            String name = (String)tokenValues.get("module");
            if (name == null) {
                return Collections.EMPTY_LIST;
            }
            if (osgiType.equals("package")) {
                return Collections.singletonList("use_" + name);
            }
            Set bundleCapabilities = this.getRepoDescriptor().findModule(osgiType, name);
            if (bundleCapabilities == null) {
                return Collections.EMPTY_LIST;
            }
            String version = (String)tokenValues.get("revision");
            if (version == null) {
                return Collections.EMPTY_LIST;
            }
            try {
                v = new Version(version);
            }
            catch (ParseException e) {
                return Collections.EMPTY_LIST;
            }
            BundleCapabilityAndLocation found = null;
            Iterator itBundle = bundleCapabilities.iterator();
            while (itBundle.hasNext()) {
                BundleCapabilityAndLocation bundleCapability = (BundleCapabilityAndLocation)itBundle.next();
                if (!bundleCapability.getVersion().equals(v)) continue;
                found = bundleCapability;
            }
            if (found == null) {
                return Collections.EMPTY_LIST;
            }
            List confs = BundleInfoAdapter.getConfigurations(found.getBundleInfo());
            return confs;
        }
        return Collections.EMPTY_LIST;
    }

    private void filterCapabilityValues(Set capabilityValues, Map moduleByCapbilityValue, Map tokenValues, String rev) {
        if (rev == null) {
            capabilityValues.addAll(moduleByCapbilityValue.keySet());
        } else {
            Iterator it = moduleByCapbilityValue.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Iterator itModules = ((Set)entry.getValue()).iterator();
                boolean moduleMatchRev = false;
                while (!moduleMatchRev && itModules.hasNext()) {
                    ModuleDescriptor md = (ModuleDescriptor)itModules.next();
                    moduleMatchRev = rev.equals(md.getRevision());
                }
                if (!moduleMatchRev) continue;
                capabilityValues.add(entry.getKey());
            }
        }
    }

    public Map[] listTokenValues(String[] tokens, Map criteria) {
        HashSet<String> tokenSet = new HashSet<String>(Arrays.asList(tokens));
        Set listTokenValues = this.listTokenValues(tokenSet, criteria);
        return listTokenValues.toArray(new Map[listTokenValues.size()]);
    }

    private Set listTokenValues(Set tokens, Map criteria) {
        if (tokens.isEmpty()) {
            return Collections.singleton(criteria);
        }
        HashSet tokenSet = new HashSet(tokens);
        HashMap<String, String> values = new HashMap<String, String>();
        tokenSet.remove("organisation");
        String osgiType = (String)criteria.get("organisation");
        if (osgiType == null || osgiType.length() == 0) {
            return Collections.EMPTY_SET;
        }
        values.put("organisation", osgiType);
        if (osgiType == null) {
            HashSet tokenValues = new HashSet();
            HashMap<String, String> newCriteria = new HashMap<String, String>(criteria);
            newCriteria.put("organisation", "bundle");
            tokenValues.addAll(this.listTokenValues(tokenSet, newCriteria));
            newCriteria = new HashMap(criteria);
            newCriteria.put("organisation", "package");
            tokenValues.addAll(this.listTokenValues(tokenSet, newCriteria));
            newCriteria = new HashMap(criteria);
            newCriteria.put("organisation", "service");
            tokenValues.addAll(this.listTokenValues(tokenSet, newCriteria));
            return tokenValues;
        }
        Set capabilities = this.getRepoDescriptor().getCapabilityValues(osgiType);
        if (capabilities == null || capabilities.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        tokenSet.remove("module");
        String module = (String)criteria.get("module");
        if (module == null) {
            HashSet tokenValues = new HashSet();
            Iterator itNames = capabilities.iterator();
            while (itNames.hasNext()) {
                String name = (String)itNames.next();
                HashMap<String, String> newCriteria = new HashMap<String, String>(criteria);
                newCriteria.put("module", name);
                tokenValues.addAll(this.listTokenValues(tokenSet, newCriteria));
            }
            return tokenValues;
        }
        values.put("module", module);
        tokenSet.remove("revision");
        String rev = (String)criteria.get("revision");
        if (rev == null) {
            Set bundleCapabilities = this.getRepoDescriptor().findModule(osgiType, module);
            if (bundleCapabilities == null) {
                return Collections.EMPTY_SET;
            }
            HashSet tokenValues = new HashSet();
            Iterator itBundle = bundleCapabilities.iterator();
            while (itBundle.hasNext()) {
                BundleCapabilityAndLocation capability = (BundleCapabilityAndLocation)itBundle.next();
                HashMap<String, String> newCriteria = new HashMap<String, String>(criteria);
                newCriteria.put("revision", capability.getVersion().toString());
                tokenValues.addAll(this.listTokenValues(tokenSet, newCriteria));
            }
            return tokenValues;
        }
        values.put("revision", rev);
        tokenSet.remove("conf");
        String conf = (String)criteria.get("conf");
        if (conf == null) {
            Version v;
            if (osgiType.equals("package")) {
                values.put("conf", "use_" + module);
                return Collections.singleton(values);
            }
            Set bundleCapabilities = this.getRepoDescriptor().findModule(osgiType, module);
            if (bundleCapabilities == null) {
                return Collections.EMPTY_SET;
            }
            try {
                v = new Version(rev);
            }
            catch (ParseException e) {
                return Collections.EMPTY_SET;
            }
            BundleCapabilityAndLocation found = null;
            Iterator itBundle = bundleCapabilities.iterator();
            while (itBundle.hasNext()) {
                BundleCapabilityAndLocation bundleCapability = (BundleCapabilityAndLocation)itBundle.next();
                if (!bundleCapability.getVersion().equals(v)) continue;
                found = bundleCapability;
            }
            if (found == null) {
                return Collections.EMPTY_SET;
            }
            HashSet tokenValues = new HashSet();
            List configurations = BundleInfoAdapter.getConfigurations(found.getBundleInfo());
            for (int i = 0; i < configurations.size(); ++i) {
                HashMap newCriteria = new HashMap(criteria);
                newCriteria.put("conf", configurations.get(i));
                tokenValues.add(newCriteria);
            }
            return tokenValues;
        }
        values.put("conf", conf);
        return Collections.singleton(values);
    }

    protected long get(Resource resource, File dest) throws IOException {
        Message.verbose("\t" + this.getName() + ": downloading " + resource.getName());
        Message.debug("\t\tto " + dest);
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        this.getRepository().get(resource.getName(), dest);
        return dest.length();
    }

    protected Resource getResource(String source) throws IOException {
        return this.getRepository().getResource(source);
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static class RequirementStrategy {
        public static RequirementStrategy first = new RequirementStrategy();
        public static RequirementStrategy noambiguity = new RequirementStrategy();

        public static RequirementStrategy valueOf(String strategy) {
            if (strategy.equals("first")) {
                return first;
            }
            if (strategy.equals("noambiguity")) {
                return noambiguity;
            }
            throw new IllegalStateException();
        }
    }
}

