/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.updatesite.xml;

import com.crashlytics.reloc.org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import com.crashlytics.reloc.org.apache.ivy.osgi.updatesite.xml.EclipsePlugin;
import com.crashlytics.reloc.org.apache.ivy.osgi.updatesite.xml.Require;
import com.crashlytics.reloc.org.apache.ivy.osgi.util.DelegetingHandler;
import com.crashlytics.reloc.org.apache.ivy.osgi.util.Version;
import com.crashlytics.reloc.org.apache.ivy.util.XMLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureParser {
    public static EclipseFeature parse(InputStream in) throws ParseException, IOException, SAXException {
        FeatureHandler handler = new FeatureHandler();
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        return handler.feature;
    }

    static class DiscoveryHandler
    extends DelegetingHandler {
        private static final String DISCOVERY = "discovery";
        private static final String URL = "url";
        private static final String LABEL = "label";
        private static final String TYPE = "type";

        public DiscoveryHandler() {
            super(DISCOVERY);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String type = atts.getValue(TYPE);
            String label = atts.getValue(LABEL);
            String url = atts.getValue(URL);
        }
    }

    static class UpdateHandler
    extends DelegetingHandler {
        private static final String UPDATE = "update";
        private static final String LABEL = "label";
        private static final String URL = "url";

        public UpdateHandler() {
            super(UPDATE);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String label = atts.getValue(LABEL);
            String url = atts.getValue(URL);
        }
    }

    static class UrlHandler
    extends DelegetingHandler {
        private static final String URL = "url";

        public UrlHandler() {
            super(URL);
            this.addChild(new UpdateHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
            this.addChild(new DiscoveryHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
        }
    }

    static class InstallHandlerHandler
    extends DelegetingHandler {
        private static final String INSTALL_HANDLER = "install-handler";
        private static final String URL = "url";
        private static final String LIBRARY = "library";
        private static final String HANDLER = "handler";

        public InstallHandlerHandler() {
            super(INSTALL_HANDLER);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String handler = atts.getValue(HANDLER);
            String library = atts.getValue(LIBRARY);
            String url = atts.getValue(URL);
        }
    }

    static class IncludesHandler
    extends DelegetingHandler {
        private static final String INCLUDES = "includes";
        private static final String FILTER = "filter";
        private static final String OPTIONAL = "optional";
        private static final String VERSION = "version";
        private static final String ID = "id";

        public IncludesHandler() {
            super(INCLUDES);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String id = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            String optional = atts.getValue(OPTIONAL);
            String filter = atts.getValue(FILTER);
        }
    }

    static class ImportHandler
    extends DelegetingHandler {
        Require require;
        private static final String IMPORT = "import";
        private static final String FILTER = "filter";
        private static final String MATCH = "match";
        private static final String VERSION = "version";
        private static final String PLUGIN = "plugin";
        private static final String FEATURE = "feature";

        public ImportHandler() {
            super(IMPORT);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            this.require = new Require();
            String version = atts.getValue(VERSION);
            this.require.setFeature(atts.getValue(FEATURE));
            this.require.setPlugin(atts.getValue(PLUGIN));
            try {
                this.require.setVersion(new Version(version));
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version on feature's import: " + version + " (" + e.getMessage() + ")");
            }
            this.require.setMatch(atts.getValue(MATCH));
            this.require.setFilter(atts.getValue(FILTER));
        }
    }

    static class RequiresHandler
    extends DelegetingHandler {
        private static final String REQUIRES = "requires";
        List requires = new ArrayList();

        public RequiresHandler() {
            super(REQUIRES);
            this.addChild(new ImportHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    RequiresHandler.this.requires.add(((ImportHandler)child).require);
                }
            });
        }
    }

    static class CopyrightHandler
    extends DelegetingHandler {
        private static final String COPYRIGHT = "copyright";
        private static final String URL = "url";

        public CopyrightHandler() {
            super(COPYRIGHT);
            this.setBufferingChar(true);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String url = atts.getValue(URL);
        }
    }

    static class LicenseHandler
    extends DelegetingHandler {
        private static final String LICENSE = "license";
        private static final String URL = "url";

        public LicenseHandler() {
            super(LICENSE);
            this.setBufferingChar(true);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String url = atts.getValue(URL);
        }
    }

    static class DescriptionHandler
    extends DelegetingHandler {
        private static final String DESCRIPTION = "description";
        private static final String URL = "url";

        public DescriptionHandler() {
            super(DESCRIPTION);
            this.setBufferingChar(true);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String url = atts.getValue(URL);
        }
    }

    static class PluginHandler
    extends DelegetingHandler {
        private static final String PLUGIN = "plugin";
        private static final String FILTER = "filter";
        private static final String FRAGMENT = "fragment";
        private static final String UNPACK = "unpack";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private EclipsePlugin plugin;

        public PluginHandler() {
            super(PLUGIN);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            this.plugin = new EclipsePlugin();
            String id = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            this.plugin.setId(id);
            try {
                this.plugin.setVersion(new Version(version));
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version on feature's plugin '" + id + "': " + version + " (" + e.getMessage() + ")");
            }
            this.plugin.setUnpack(Boolean.valueOf(atts.getValue(UNPACK)));
            this.plugin.setFragment(atts.getValue(FRAGMENT));
            this.plugin.setFilter(atts.getValue(FILTER));
        }
    }

    static class FeatureHandler
    extends DelegetingHandler {
        private static final String FEATURE = "feature";
        private static final String COLOCATION_AFFINITY = "colocation-affinity";
        private static final String PRIMARY = "primary";
        private static final String EXCLUSIVE = "exclusive";
        private static final String PLUGIN = "plugin";
        private static final String APPLICATION = "application";
        private static final String ARCH = "arch";
        private static final String NL = "nl";
        private static final String WS = "ws";
        private static final String OS = "os";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private static final String PROVIDER_NAME = "provider-name";
        private static final String LABEL = "label";
        private static final String IMAGE = "image";
        EclipseFeature feature;

        public FeatureHandler() {
            super(FEATURE);
            this.addChild(new DescriptionHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    FeatureHandler.this.feature.setDescription(child.getBufferedChars().trim());
                }
            });
            this.addChild(new LicenseHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    FeatureHandler.this.feature.setLicense(child.getBufferedChars().trim());
                }
            });
            this.addChild(new CopyrightHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    FeatureHandler.this.feature.setCopyright(child.getBufferedChars().trim());
                }
            });
            this.addChild(new PluginHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    FeatureHandler.this.feature.addPlugin(((PluginHandler)child).plugin);
                }
            });
            this.addChild(new RequiresHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    Iterator itRequire = ((RequiresHandler)child).requires.iterator();
                    while (itRequire.hasNext()) {
                        FeatureHandler.this.feature.addRequire((Require)itRequire.next());
                    }
                }
            });
            this.addChild(new UrlHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String id = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            try {
                this.feature = new EclipseFeature(id, new Version(version));
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version on feature '" + id + "': " + version + " (" + e.getMessage() + ")");
            }
            this.feature.setOS(atts.getValue(OS));
            this.feature.setWS(atts.getValue(WS));
            this.feature.setNL(atts.getValue(NL));
            this.feature.setArch(atts.getValue(ARCH));
            this.feature.setApplication(atts.getValue(APPLICATION));
            this.feature.setPlugin(atts.getValue(PLUGIN));
            this.feature.setExclusive(Boolean.valueOf(atts.getValue(EXCLUSIVE)));
            this.feature.setPrimary(Boolean.valueOf(atts.getValue(PRIMARY)));
            this.feature.setColocationAffinity(atts.getValue(COLOCATION_AFFINITY));
            this.feature.setProviderName(atts.getValue(PROVIDER_NAME));
            this.feature.setLabel(atts.getValue(LABEL));
            this.feature.setImage(atts.getValue(IMAGE));
        }
    }
}

