/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.plugins.repository.sftp;

import com.crashlytics.dependency.reloc.com.jcraft.jsch.ChannelSftp;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.JSchException;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.Session;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.SftpATTRS;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.SftpException;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.SftpProgressMonitor;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.BasicResource;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.Resource;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.sftp.SFTPResource;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.ssh.AbstractSshBasedRepository;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.ssh.SshCache;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SFTPRepository
extends AbstractSshBasedRepository {
    private static final long MILLIS_PER_SECOND = 1000L;

    public Resource getResource(String source) {
        return new SFTPResource(this, source);
    }

    public Resource resolveResource(String path) {
        try {
            ChannelSftp c = this.getSftpChannel(path);
            Vector r = c.ls(this.getPath(path));
            if (r != null) {
                Iterator iter = r.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof ChannelSftp.LsEntry)) continue;
                    ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)obj;
                    SftpATTRS attrs = entry.getAttrs();
                    return new BasicResource(path, true, attrs.getSize(), (long)attrs.getMTime() * 1000L, false);
                }
            }
        }
        catch (Exception e) {
            Message.debug("reolving resource error: " + e.getMessage());
        }
        return new BasicResource(path, false, 0L, 0L, false);
    }

    public InputStream openStream(SFTPResource resource) throws IOException {
        ChannelSftp c = this.getSftpChannel(resource.getName());
        try {
            String path = this.getPath(resource.getName());
            return c.get(path);
        }
        catch (SftpException e) {
            IOException ex = new IOException("impossible to open stream for " + resource + " on " + this.getHost() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException e) {
            IOException ex = new IOException("impossible to open stream for " + resource + " on " + this.getHost() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
            ex.initCause(e);
            throw ex;
        }
    }

    public void get(String source, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source), 5);
        ChannelSftp c = this.getSftpChannel(source);
        try {
            String path = this.getPath(source);
            c.get(path, destination.getAbsolutePath(), (SftpProgressMonitor)new MyProgressMonitor());
        }
        catch (SftpException e) {
            IOException ex = new IOException("impossible to get " + source + " on " + this.getHost() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException e) {
            IOException ex = new IOException("impossible to get " + source + " on " + this.getHost() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
            ex.initCause(e);
            throw ex;
        }
    }

    public void put(File source, String destination, boolean overwrite) throws IOException {
        this.fireTransferInitiated(this.getResource(destination), 6);
        ChannelSftp c = this.getSftpChannel(destination);
        try {
            String path = this.getPath(destination);
            if (!overwrite && this.checkExistence(path, c)) {
                throw new IOException("destination file exists and overwrite == false");
            }
            if (path.indexOf(47) != -1) {
                this.mkdirs(path.substring(0, path.lastIndexOf(47)), c);
            }
            c.put(source.getAbsolutePath(), path, (SftpProgressMonitor)new MyProgressMonitor());
        }
        catch (SftpException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    private void mkdirs(String directory, ChannelSftp c) throws IOException, SftpException {
        try {
            SftpATTRS att = c.stat(directory);
            if (att != null && att.isDir()) {
                return;
            }
        }
        catch (SftpException ex) {
            if (directory.indexOf(47) != -1) {
                this.mkdirs(directory.substring(0, directory.lastIndexOf(47)), c);
            }
            c.mkdir(directory);
        }
    }

    private String getPath(String sftpURI) throws URISyntaxException {
        String result = null;
        URI uri = new URI(sftpURI);
        result = uri.getPath();
        if (result == null) {
            throw new URISyntaxException(sftpURI, "Missing path in URI.");
        }
        return result;
    }

    public List list(String parent) throws IOException {
        try {
            ChannelSftp c = this.getSftpChannel(parent);
            String path = this.getPath(parent);
            Vector r = c.ls(path);
            if (r != null) {
                if (!path.endsWith("/")) {
                    path = parent + "/";
                }
                ArrayList<String> result = new ArrayList<String>();
                Iterator iter = r.iterator();
                while (iter.hasNext()) {
                    ChannelSftp.LsEntry entry;
                    Object obj = iter.next();
                    if (!(obj instanceof ChannelSftp.LsEntry) || ".".equals((entry = (ChannelSftp.LsEntry)obj).getFilename()) || "..".equals(entry.getFilename())) continue;
                    result.add(path + entry.getFilename());
                }
                return result;
            }
        }
        catch (SftpException e) {
            IOException ex = new IOException("Failed to return a listing for '" + parent + "'");
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException usex) {
            IOException ex = new IOException("Failed to return a listing for '" + parent + "'");
            ex.initCause(usex);
            throw ex;
        }
        return null;
    }

    private boolean checkExistence(String file, ChannelSftp channel) throws IOException, SftpException {
        try {
            return channel.stat(file) != null;
        }
        catch (SftpException ex) {
            return false;
        }
    }

    private ChannelSftp getSftpChannel(String pathOrUri) throws IOException {
        Session session = this.getSession(pathOrUri);
        String host = session.getHost();
        ChannelSftp channel = SshCache.getInstance().getChannelSftp(session);
        if (channel == null) {
            try {
                channel = (ChannelSftp)session.openChannel("sftp");
                channel.connect();
                Message.verbose(":: SFTP :: connected to " + host + "!");
                SshCache.getInstance().attachChannelSftp(session, channel);
            }
            catch (JSchException e) {
                IOException ex = new IOException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }
        return channel;
    }

    protected String getRepositoryScheme() {
        return "sftp";
    }

    private final class MyProgressMonitor
    implements SftpProgressMonitor {
        private long totalLength;

        private MyProgressMonitor() {
        }

        public void init(int op, String src, String dest, long max) {
            this.totalLength = max;
            SFTPRepository.this.fireTransferStarted(max);
        }

        public void end() {
            SFTPRepository.this.fireTransferCompleted(this.totalLength);
        }

        public boolean count(long count) {
            SFTPRepository.this.fireTransferProgress(count);
            return true;
        }
    }
}

