/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.util;

import com.crashlytics.reloc.org.apache.ivy.util.url.URLHandlerRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLHelper {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String XML_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static boolean canUseSchemaValidation = true;

    private static SAXParser newSAXParser(URL schema, InputStream schemaStream) throws ParserConfigurationException, SAXException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(canUseSchemaValidation && schema != null);
        SAXParser parser = parserFactory.newSAXParser();
        if (canUseSchemaValidation && schema != null) {
            try {
                parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                parser.setProperty(JAXP_SCHEMA_SOURCE, schemaStream);
            }
            catch (SAXNotRecognizedException ex) {
                System.err.println("WARNING: problem while setting JAXP validating property on SAXParser... XML validation will not be done: " + ex.getMessage());
                canUseSchemaValidation = false;
                parserFactory.setValidating(false);
                parser = parserFactory.newSAXParser();
            }
        }
        parser.getXMLReader().setFeature(XML_NAMESPACE_PREFIXES, true);
        return parser;
    }

    public static String toSystemId(URL url) {
        try {
            return new URI(url.toExternalForm()).toASCIIString();
        }
        catch (URISyntaxException e) {
            return url.toExternalForm();
        }
    }

    public static void parse(URL xmlURL, URL schema, DefaultHandler handler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(xmlURL, schema, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(URL xmlURL, URL schema, DefaultHandler handler, LexicalHandler lHandler) throws SAXException, IOException, ParserConfigurationException {
        InputStream xmlStream = URLHandlerRegistry.getDefault().openStream(xmlURL);
        try {
            InputSource inSrc = new InputSource(xmlStream);
            inSrc.setSystemId(XMLHelper.toSystemId(xmlURL));
            XMLHelper.parse(inSrc, schema, handler, lHandler);
        }
        finally {
            try {
                xmlStream.close();
            }
            catch (IOException e) {}
        }
    }

    public static void parse(InputStream xmlStream, URL schema, DefaultHandler handler, LexicalHandler lHandler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(new InputSource(xmlStream), schema, handler, lHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(InputSource xmlStream, URL schema, DefaultHandler handler, LexicalHandler lHandler) throws SAXException, IOException, ParserConfigurationException {
        InputStream schemaStream = null;
        try {
            if (schema != null) {
                schemaStream = URLHandlerRegistry.getDefault().openStream(schema);
            }
            SAXParser parser = XMLHelper.newSAXParser(schema, schemaStream);
            if (lHandler != null) {
                try {
                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", lHandler);
                }
                catch (SAXException ex) {
                    System.err.println("WARNING: problem while setting the lexical handler property on SAXParser: " + ex.getMessage());
                }
            }
            parser.parse(xmlStream, handler);
        }
        finally {
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static boolean canUseSchemaValidation() {
        return canUseSchemaValidation;
    }

    public static String escape(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(text.length());
        char[] chars = text.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(chars[i]);
                }
            }
        }
        return result.toString();
    }

    public static Document parseToDom(InputSource source, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilder docBuilder = XMLHelper.getDocBuilder(entityResolver);
        return docBuilder.parse(source);
    }

    public static DocumentBuilder getDocBuilder(EntityResolver entityResolver) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            if (entityResolver != null) {
                docBuilder.setEntityResolver(entityResolver);
            }
            return docBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private XMLHelper() {
    }
}

