/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.collect.Sets;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.KitClass;
import com.crashlytics.tools.android.onboard.MoPubAdType;
import com.crashlytics.tools.android.onboard.PluginDescriptor;
import com.crashlytics.tools.android.onboard.Repository;
import com.crashlytics.tools.android.onboard.TwitterFeature;
import com.crashlytics.tools.android.onboard.dsl.NestedMethodInvocation;
import java.util.Arrays;
import java.util.List;

public class OnboardingConstants {
    public static final String FABRIC_REPOSITORY_URL = "https://maven.fabric.io/repo";
    public static final String LEGACY_CRASHLYTICS_REPOSITORY_URL = "http://download.crashlytics.com/maven";
    public static final String FABRIC_AUTH_INTERNAL_USERNAME = "sdk-internal-user";
    public static final String FABRIC_AUTH_INTERNAL_PASSWORD = "AP5FmPqPrwE3GWjh3NimiDaVd3XEFfK3aobgxM";
    public static final Repository FABRIC_REPOSITORY = DeveloperTools.isInternalEnabled() ? Repository.createAuthenticatedRepository("https://maven.fabric.io/repo", "sdk-internal-user", "AP5FmPqPrwE3GWjh3NimiDaVd3XEFfK3aobgxM") : Repository.createPublicRepository("https://maven.fabric.io/repo");
    public static final Repository LEGACY_CRASHLYTICS_REPOSITORY = Repository.createPublicRepository("http://download.crashlytics.com/maven");
    public static final Repository PROPERTIES_REPOSITORY = Repository.createAuthenticatedRepository("AUTHENTICATED_MAVEN_URL", "AUTHENTICATED_MAVEN_USERNAME", "AUTHENTICATED_MAVEN_PASSWORD");
    public static final String FABRIC_PACKAGE = "io.fabric.sdk.android";
    public static final String TWITTER_PACKAGE = "com.twitter.sdk.android";
    public static final String CRASHLYTICS_PACKAGE = "com.crashlytics.android";
    public static final String MOPUB_PACKAGE = "com.mopub.common";
    public static final String DIGITS_PACKAGE = "com.digits.sdk.android";
    public static final String CRASHLYTICS_FULLY_QUALIFIED = "com.crashlytics.android.Crashlytics";
    public static final String FABRIC_FULLY_QUALIFIED = "io.fabric.sdk.android.Fabric";
    private static final KitClass CRASHLYTICS_CLASS = new KitClass("com.crashlytics.android", "Crashlytics");
    private static final KitClass TWITTER_CLASS = new KitClass("com.twitter.sdk.android", "Twitter");
    private static final KitClass MOPUB_CLASS = new KitClass("com.mopub.common", "MoPub");
    private static final String CRASHLYTICS_SDK_GROUP_ID = "com.crashlytics.sdk.android";
    private static final String TWITTER_SDK_GROUP_ID = "com.twitter.sdk.android";
    private static final String MOPUB_SDK_GROUP_ID = "com.mopub.sdk.android";
    private static final String CRASHLYTICS_LEGACY_GROUP_ID = "com.crashlytics.android";
    private static final String CRASHLYTICS_ARTIFACT_ID = "crashlytics";
    private static final String TWITTER_ARTIFACT_ID = "twitter";
    private static final String MOPUB_ARTIFACT_ID = "mopub";
    private static final String CRASHLYTICS_BACKEND_FEATURE_ID = "com.twitter.sdk.android.crashlytics";
    private static final String TWITTER_BACKEND_FEATURE_ID = "com.twitter.sdk.android";
    private static final String MOPUB_BACKEND_FEATURE_ID = "com.mopub.common";
    public static final Kit LEGACY_CRASHLYTICS_KIT = Kit.createLegacyKit("com.twitter.sdk.android.crashlytics", "com.crashlytics.android", "crashlytics", "1.+", CRASHLYTICS_CLASS, "Crashlytics");
    public static final Kit CRASHLYTICS_KIT = new Kit("com.twitter.sdk.android.crashlytics", "com.crashlytics.sdk.android", "crashlytics", "2.0.0" + (DeveloperTools.isInternalEnabled() ? "-SNAPSHOT" : ""), "Crashlytics", "The world's best crash reporting", CRASHLYTICS_CLASS, Kit.Feature.featureless(), Optional.<String>absent(), Optional.of("crashlytics"), Optional.of("resources/images/kit.crashlytics.white.png"), Optional.of("https://dev.twitter.com/crashlytics"), Optional.of("The world's most powerful, yet lightest weight crash reporting solution."), true, false);
    public static final Kit TWITTER_KIT = new Kit("com.twitter.sdk.android", "com.twitter.sdk.android", "twitter", "1.0.0" + (DeveloperTools.isInternalEnabled() ? "-SNAPSHOT" : ""), "Twitter", "Drive downloads and engagement", TWITTER_CLASS, Sets.newHashSet(new Kit.Feature<TwitterFeature>(TwitterFeature.Digits), new Kit.Feature<TwitterFeature>(TwitterFeature.EmbedTweet), new Kit.Feature<TwitterFeature>(TwitterFeature.TwitterSignIn)), Optional.of("authConfig"), Optional.of("twitter"), Optional.of("resources/images/kit.twitter.logo.white.png"), Optional.of("https://dev.twitter.com/twitter-kit"), Optional.of("Integrate Sign in with Twitter, embed Tweets, and leverage the Twitter API."), true, true);
    public static final Kit MOPUB_KIT = new Kit("com.mopub.common", "com.mopub.sdk.android", "mopub", "3.1.0" + (DeveloperTools.isInternalEnabled() ? "-SNAPSHOT" : ""), "MoPub", "Drive more mobile ad revenue", MOPUB_CLASS, Sets.newHashSet(new Kit.Feature<MoPubAdType>(MoPubAdType.Banner), new Kit.Feature<MoPubAdType>(MoPubAdType.Interstitial)), Optional.<String>absent(), Optional.of("mopub"), Optional.of("resources/images/kit.mopub.logo.white.png"), Optional.of("https://dev.twitter.com/mopub"), Optional.of("Earn money by connecting to the world's largest mobile ad exchange."), true, true);
    public static final String TWITTER_AUTH_CLASS = "TwitterAuthConfig";
    public static final String TWITTER_AUTH_IMPORT = "com.twitter.sdk.android.core.TwitterAuthConfig";
    public static final List<Kit> DEFAULT_KITS = Arrays.asList(CRASHLYTICS_KIT, TWITTER_KIT, MOPUB_KIT);
    public static final String FABRIC_PLUGIN_DEPENDENCY = "io.fabric.tools:gradle";
    public static final String BUILDSCRIPT_DEPENDENCY_BARE = "com.crashlytics.tools.gradle:crashlytics-gradle";
    public static final PluginDescriptor CRASHLYTICS_PLUGIN = new PluginDescriptor(LEGACY_CRASHLYTICS_REPOSITORY, "com.crashlytics.tools.gradle:crashlytics-gradle", "crashlytics");
    public static final PluginDescriptor FABRIC_PLUGIN = new PluginDescriptor(FABRIC_REPOSITORY, "io.fabric.tools:gradle", "io.fabric");
    public static final String EXAMPLE_SRC_PATH = "examples/";
    public static final String PROGUARD_PATH = "proguard/";
    public static final String MANIFEST_TITLE = "AndroidManifest.xml";
    public static final String MAIN_LAYOUT_TITLE = "activity_main.xml";
    public static final String BUILD_GRADLE_TITLE = "build.gradle";
    public static final String EXAMPLE_MANIFEST_FILE_NAME = "AndroidManifest.xml.txt";
    public static final String EXAMPLE_MANIFEST_FILE = "examples/AndroidManifest.xml.txt";
    public static final String EXAMPLE_MAIN_LAYOUT_FILE_NAME = "activity_main.xml.txt";
    public static final String EXAMPLE_MAIN_LAYOUT_FILE = "examples/activity_main.xml.txt";
    public static final String JAVA_MAIN_ACTIVITY_NAME = "Start Activity";
    public static final String SRC_ACTIVITY = "MainActivity.java.txt";
    public static final String SRC_ACTIVITY_LOCATIONS = "MainActivityLocations.properties";
    public static final String FILE_EXAMPLE_SRC_ACTIVITY = "examples/MainActivity.java.txt";
    public static final String FILE_EXAMPLE_MAIN_LAYOUT = "examples/activity_main.xml.txt";
    public static final String BUILD_GRADLE_ACTIVITY = "build.gradle.txt";
    public static final String FILE_EXAMPLE_BUILD_GRADLE_ACTIVITY = "examples/build.gradle.txt";
    public static final String PERMISSION_FORMAT = "<uses-permission android:name=\"%s\"/>";
    public static final String METADATA_ELEMENT_FORMAT = "<meta-data android:name=\"com.crashlytics.ApiKey\" android:value=\"%s\"/>";
    public static final String ACTIVITY_ELEMENT_FORMAT = "<activity android:name=\"%s\"\n%sandroid:configChanges=\"keyboardHidden|orientation\"/>";
    public static final String GRADLE_PROPERTIES_TITLE = "gradle.properties";
    public static final String KITS_PROPERTIES_TITLE = "kits.properties";
    public static final String METHOD_SEARCHED = "onCreate";

    public static boolean isCrashlyticsKit(Kit kit) {
        return kit != null && (kit.isSameArtifact(CRASHLYTICS_KIT) || kit.isSameArtifact(LEGACY_CRASHLYTICS_KIT));
    }

    public static String startClass(boolean hasKitsEnabled) {
        return hasKitsEnabled ? "Fabric" : "Crashlytics";
    }

    public static String startMethod(boolean hasKitsEnabled) {
        return hasKitsEnabled ? "with" : "start";
    }

    public static String injectionTitle(boolean hasKitsEnabled) {
        return "Added " + OnboardingConstants.startClass(hasKitsEnabled) + "." + OnboardingConstants.startMethod(hasKitsEnabled) + "...";
    }

    public static NestedMethodInvocation getStartMethod(boolean hasKitsEnabled) {
        return new NestedMethodInvocation(OnboardingConstants.startClass(hasKitsEnabled), OnboardingConstants.startClassFullyQualified(hasKitsEnabled), METHOD_SEARCHED, OnboardingConstants.startMethod(hasKitsEnabled));
    }

    public static NestedMethodInvocation getLegacyStartMethod() {
        return new NestedMethodInvocation(LEGACY_CRASHLYTICS_KIT.getKitClass().getClassName(), LEGACY_CRASHLYTICS_KIT.getKitClass().getFullyQualifiedClassName(), METHOD_SEARCHED, OnboardingConstants.startMethod(false));
    }

    public static String startClassFullyQualified(boolean hasKitsEnabled) {
        return hasKitsEnabled ? FABRIC_FULLY_QUALIFIED : CRASHLYTICS_FULLY_QUALIFIED;
    }
}

