/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard.directions;

import com.crashlytics.reloc.com.google.common.collect.ImmutableList;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.StubCode;
import com.crashlytics.tools.android.onboard.dsl.ModifiableClass;
import com.crashlytics.tools.android.onboard.dsl.ModifiableNestedMethodInvocation;
import com.crashlytics.tools.android.onboard.dsl.NestedMethodInvocation;
import com.crashlytics.tools.android.onboard.kits.KitUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModifiableExampleClass
implements ModifiableClass {
    public static String IMPORT_LOCATION_TAG = "imports";
    public static String FIELD_LOCATION_TAG = "fields";
    private final String _exampleClassContents;
    public List<String> _fields = new LinkedList<String>();
    public Set<String> _imports = new HashSet<String>();
    private Map<String, Integer> _locationPositions;
    public Map<NestedMethodInvocation, ModifiableExampleMethodInvocation> methodsAdded = new HashMap<NestedMethodInvocation, ModifiableExampleMethodInvocation>();
    private String _className;

    public ModifiableExampleClass(String className, String exampleClassContents, Map<String, Integer> locationPositions) {
        this._className = className;
        this._exampleClassContents = exampleClassContents;
        this._locationPositions = locationPositions;
    }

    @Override
    public void addFields(String ... fields) throws OnboardException {
        this._fields.addAll(Arrays.asList(fields));
    }

    @Override
    public boolean deleteMethodInvocation(NestedMethodInvocation invocation) throws OnboardException {
        return false;
    }

    @Override
    public void flagUpgrade() {
    }

    @Override
    public ModifiableNestedMethodInvocation getOrCreate(NestedMethodInvocation invocation) throws OnboardException {
        ModifiableExampleMethodInvocation methodAdded = this.methodsAdded.get(invocation);
        if (methodAdded == null) {
            methodAdded = new ModifiableExampleMethodInvocation();
            this.methodsAdded.put(invocation, methodAdded);
        }
        return methodAdded;
    }

    @Override
    public void addImports(String ... imports) throws OnboardException {
        LinkedList<String> importLines = new LinkedList<String>();
        for (String importName : imports) {
            importLines.add("import " + importName + ";");
        }
        this._imports.addAll(importLines);
    }

    @Override
    public CodeChange getCodeChange() throws OnboardException {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        changes.add(this.insert(this.find(IMPORT_LOCATION_TAG), this._imports));
        changes.add(this.insert(this.find(FIELD_LOCATION_TAG), this._fields));
        for (Map.Entry<NestedMethodInvocation, ModifiableExampleMethodInvocation> invocationEntry : this.methodsAdded.entrySet()) {
            NestedMethodInvocation invocation = invocationEntry.getKey();
            ModifiableExampleMethodInvocation modifications = invocationEntry.getValue();
            changes.add(this.insert(this.find(this.getTag(invocation)), ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(modifications.getStatements())).add(this.createMethodInvocationString(invocation, modifications.getParams()))).build()));
        }
        return new CodeChange(this._className, new StubCode(this._exampleClassContents), changes);
    }

    private String getTag(NestedMethodInvocation invocation) {
        return "method." + invocation.parentMethod;
    }

    private String createMethodInvocationString(NestedMethodInvocation invocation, List<String> params) {
        return KitUtils.createMethodInvocation(invocation, params);
    }

    private CodeChange.BlockChange insert(int location, Collection<String> lines) {
        String lineWhitespace = this.getWhitespace(location);
        StringBuilder insertedLines = new StringBuilder();
        for (String line : lines) {
            insertedLines.append(line + "\n" + lineWhitespace);
        }
        return new CodeChange.Insertion(location, insertedLines.toString());
    }

    private int find(String locationByTag) {
        return this._locationPositions.get(locationByTag);
    }

    private String getWhitespace(int location) {
        return this._exampleClassContents.substring(this._exampleClassContents.lastIndexOf("\n", location), location);
    }

    public static class ModifiableExampleMethodInvocation
    implements ModifiableNestedMethodInvocation {
        private final List<String> _params = new LinkedList<String>();
        private final List<String> _statements = new LinkedList<String>();

        @Override
        public boolean addParameter(String parameter) throws OnboardException {
            this._params.add(parameter);
            return true;
        }

        @Override
        public void insertBefore(String ... statements) throws OnboardException {
            this._statements.addAll(Arrays.asList(statements));
        }

        public List<String> getParams() {
            return this._params;
        }

        public List<String> getStatements() {
            return this._statements;
        }

        @Override
        public boolean existed() {
            return false;
        }
    }
}

