/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.net.auth;

import com.crashlytics.api.net.auth.OAuthUtils;
import com.crashlytics.api.storage.FileStore;
import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import com.crashlytics.reloc.org.apache.http.Header;
import com.crashlytics.reloc.org.apache.http.HttpResponse;
import com.crashlytics.reloc.org.apache.http.client.ClientProtocolException;
import com.crashlytics.reloc.org.apache.http.client.HttpClient;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpPost;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpRequestBase;
import com.crashlytics.reloc.org.apache.http.entity.StringEntity;
import com.crashlytics.reloc.org.json.simple.JSONArray;
import com.crashlytics.reloc.org.json.simple.JSONObject;
import com.crashlytics.reloc.org.json.simple.parser.JSONParser;
import com.crashlytics.reloc.org.json.simple.parser.ParseException;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.SecretObfuscator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;

public final class OAuthClient {
    private static final String TOKEN_STORE_FILE = DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath() + "/Scopes.json";
    private static final String TOKEN_ENDPOINT = "/oauth/token?grant_type=password";
    private static final String REFRESH_TOKEN_ENDPOINT = "/oauth/token?grant_type=refresh_token";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String REFRESH_TOKEN_QUERY = "&refresh_token=";
    private static final String[] DEFAULT_SCOPES = new String[]{"organizations", "apps", "issues", "features", "account", "twitter_client_apps", "beta", "software"};
    private static final String DEFAULT_SCOPE_QUERY = "&scope=" + Joiner.on("%20").join(DEFAULT_SCOPES);
    private static final String UTF8 = "UTF-8";
    private static final char[][] ENCODED_APP_ID = new char[][]{"YzUzNjhhNzYwZDk0".toCharArray(), "YzhiYmViNGVlZGZi".toCharArray(), "YWVjZjNmODk0NTg4".toCharArray(), "ZmU4NjM4OGY2N2U3".toCharArray(), "NzRhMDU0YmFkYTIw".toCharArray(), "NTQ5NA==".toCharArray()};
    private static final char[][] ENCODED_SECRET = new char[][]{"Mjk5NWEzMGExMTcy".toCharArray(), "OWFhYWUzNjkxMzk2".toCharArray(), "MDExN2FhNGYyYzdk".toCharArray(), "MTZjZTAyNWNjYTBj".toCharArray(), "M2QwNWU4OTM0YjE4".toCharArray(), "MzQwNQ==".toCharArray()};
    private static final char[][] SHUFFLE = new char[][]{"35041627".toCharArray(), "231405".toCharArray(), "45602173".toCharArray(), "132405".toCharArray()};
    private static final String APP_ID;
    private static final String SECRET;
    private final URI _baseUri;

    public OAuthClient(URI baseUri) {
        this._baseUri = baseUri;
    }

    public URI getBaseUrl() {
        return this._baseUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Token getToken(HttpClient client, final String username, final String password) throws IOException {
        block9: {
            InputStream stream = null;
            try {
                HttpPost post = new HttpPost(new URI(this._baseUri + TOKEN_ENDPOINT + DEFAULT_SCOPE_QUERY));
                post.setEntity(new StringEntity(OAuthUtils.formEncode(new HashMap<String, String>(){
                    {
                        this.put(OAuthClient.USERNAME, username);
                        this.put(OAuthClient.PASSWORD, password);
                        this.put(OAuthClient.CLIENT_ID, APP_ID);
                        this.put(OAuthClient.CLIENT_SECRET, SECRET);
                    }
                }.entrySet(), UTF8)));
                stream = OAuthClient.fetch(client, post);
                if (stream != null) {
                    Token token = OAuthClient.parse(stream);
                    if (token != null) {
                        OAuthClient.writeScopes(TOKEN_STORE_FILE, DEFAULT_SCOPES);
                    }
                    Token token2 = token;
                    IOUtils.closeQuietly(stream);
                    return token2;
                }
                IOUtils.closeQuietly(stream);
            }
            catch (URISyntaxException e) {
                DeveloperTools.logE("Crashlytics encountered a bad URI", e);
            }
            catch (UnsupportedEncodingException e2) {
                DeveloperTools.logE("Crashlytics doesn't support this encoding", e2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Token refreshToken(HttpClient client, Token token) throws IOException {
        InputStream stream;
        block9: {
            Token token2;
            block8: {
                if (token == null) {
                    return null;
                }
                stream = null;
                try {
                    HttpPost post = new HttpPost(new URI(this._baseUri + REFRESH_TOKEN_ENDPOINT + REFRESH_TOKEN_QUERY + token.getRefreshToken()));
                    stream = OAuthClient.fetch(client, post);
                    if (stream != null) {
                        token2 = OAuthClient.parse(stream);
                        if (stream == null) return token2;
                        break block8;
                    }
                    if (stream == null) return null;
                    break block9;
                }
                catch (URISyntaxException e) {
                    DeveloperTools.logE("Crashlytics encountered a bad URI", e);
                    return null;
                }
            }
            IOUtils.closeQuietly(stream);
            return token2;
        }
        IOUtils.closeQuietly(stream);
        return null;
        finally {
            if (stream != null) {
                IOUtils.closeQuietly(stream);
            }
        }
    }

    private static InputStream fetch(HttpClient client, HttpPost post) throws IOException {
        try {
            post.addHeader("Content-Type", "application/x-www-form-urlencoded");
            post.addHeader("Accept", "application/json");
            DeveloperTools.logD("REQUEST: " + post.getURI());
            HttpResponse response = client.execute(post);
            Header requestIdHeader = response.getFirstHeader("X-Request-Id");
            String requestId = requestIdHeader == null ? "null" : requestIdHeader.getValue();
            DeveloperTools.logD("RESPONSE: " + response.getStatusLine().getStatusCode() + " [reqId=" + requestId + "]");
            if (response.getStatusLine().getStatusCode() != 200) {
                return null;
            }
            return response.getEntity().getContent();
        }
        catch (ClientProtocolException e) {
            DeveloperTools.logE("Crashlytics encountered a client protocol exception", e);
            return null;
        }
    }

    public static HttpRequestBase sign(HttpRequestBase request, Token token) {
        request.setHeader("Authorization", "Bearer " + token.getAccessToken());
        return request;
    }

    private static Token parse(InputStream stream) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject parsed = (JSONObject)parser.parse(new InputStreamReader(stream, Charset.forName(UTF8)));
            return new Token((String)parsed.get("access_token"), (String)parsed.get("refresh_token"), (String)parsed.get("token_type"), (Long)parsed.get("expires_in"));
        }
        catch (ParseException e) {
            DeveloperTools.logE("Crashlytics couldn't extract the token", e);
        }
        catch (IOException e) {
            DeveloperTools.logE("Crashlytics couldn't extract the token", e);
        }
        return null;
    }

    private static void writeScopes(String filename, String[] scopes) {
        try {
            new FileStore(filename).put(JSONArray.toJSONString(Arrays.asList(scopes)));
        }
        catch (IOException e) {
            DeveloperTools.logW("Crashlytics couldn't write the default scopes", e);
        }
    }

    private static String appId() {
        return SecretObfuscator.decode(ENCODED_APP_ID, SHUFFLE[1], SHUFFLE[0]);
    }

    private static String secret() {
        return SecretObfuscator.decode(ENCODED_SECRET, SHUFFLE[3], SHUFFLE[2]);
    }

    static {
        String APP_ID_OVERRIDE = System.getProperty("crashlytics.app_id");
        String SECRET_OVERRIDE = System.getProperty("crashlytics.secret");
        APP_ID = APP_ID_OVERRIDE == null ? OAuthClient.appId() : APP_ID_OVERRIDE;
        SECRET = SECRET_OVERRIDE == null ? OAuthClient.secret() : SECRET_OVERRIDE;
    }

    public static final class Token {
        private final String _accessToken;
        private final String _refreshToken;
        private final String _tokenType;
        private final long _expiresIn;

        public Token() {
            this._accessToken = null;
            this._refreshToken = null;
            this._tokenType = null;
            this._expiresIn = 0L;
        }

        public Token(String accessToken, String refreshToken, String tokenType, long expiresIn) {
            this._accessToken = accessToken;
            this._refreshToken = refreshToken;
            this._tokenType = tokenType;
            this._expiresIn = expiresIn;
        }

        public String getAccessToken() {
            return this._accessToken;
        }

        public String getRefreshToken() {
            return this._refreshToken;
        }

        public String toString() {
            return "{ accessToken=" + this._accessToken + ", refreshToken=" + this._refreshToken + ", tokenType=" + this._tokenType + ", expiresIn=" + this._expiresIn + " }";
        }
    }
}

