/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.storage;

import com.crashlytics.api.storage.Storage;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class FileStore
implements Storage<String> {
    private static Charset UTF_8 = Charset.forName("UTF-8");
    private String _filename;

    public FileStore(String filename) {
        this._filename = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String data) throws IOException {
        File file = new File(this._filename);
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            stream.write(data.getBytes(UTF_8));
            stream.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly(stream);
    }

    @Override
    public Optional<String> get() {
        File file = new File(this._filename);
        if (!file.exists()) {
            return Optional.absent();
        }
        try {
            return Optional.fromNullable(FileUtils.fileToString(file));
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not read cache file " + file, e);
            return Optional.absent();
        }
    }

    @Override
    public boolean purge() {
        return new File(this._filename).delete();
    }

    @Override
    public String filename() {
        return this._filename;
    }
}

