/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarListSanitizer {
    private static final byte[] sBuffer = new byte[4096];
    private static final String CACHE_FILENAME = "jarlist.cache";
    private static final Pattern READ_PATTERN = Pattern.compile("^(\\d+) (\\d+) ([0-9a-f]+) (.+)$");
    private final File mOut;
    private final PrintStream mOutStream;

    public JarListSanitizer(File file) {
        this.mOut = file;
        this.mOutStream = System.out;
    }

    public JarListSanitizer(File file, PrintStream printStream) {
        this.mOut = file;
        this.mOutStream = printStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> sanitize(Collection<File> collection) throws DifferentLibException, Sha1Exception {
        Object object;
        ArrayList<File> arrayList = new ArrayList<File>();
        Map<String, JarEntity> map = this.getCachedJarList();
        boolean bl = false;
        for (JarEntity object2 : map.values()) {
            if (object2.getFile().exists()) continue;
            arrayList.add(object2.getFile());
        }
        if (arrayList.size() > 0) {
            for (File file : arrayList) {
                map.remove(file.getAbsolutePath());
            }
            arrayList.clear();
            bl = true;
        }
        HashMap hashMap = new HashMap();
        for (File file : collection) {
            object = file.getAbsolutePath();
            JarEntity jarEntity = map.get(object);
            if (jarEntity == null) {
                jarEntity = new JarEntity(file);
                map.put((String)object, jarEntity);
                bl = true;
            } else {
                bl |= jarEntity.checkValidity();
            }
            String string = file.getName();
            ArrayList<JarEntity> arrayList2 = (ArrayList<JarEntity>)hashMap.get(string);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<JarEntity>();
                hashMap.put(string, arrayList2);
            }
            arrayList2.add(jarEntity);
        }
        try {
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (List)entry.getValue();
                this.checkEntities((String)entry.getKey(), (List<JarEntity>)object);
                arrayList.add(((JarEntity)object.get(0)).getFile());
            }
            this.checkSupportLibs(hashMap, arrayList);
        }
        finally {
            if (bl) {
                this.writeJarList(hashMap);
            }
        }
        return arrayList;
    }

    private void checkEntities(String string, List<JarEntity> list) throws DifferentLibException, Sha1Exception {
        if (list.size() == 1) {
            return;
        }
        JarEntity jarEntity = list.get(0);
        long l = jarEntity.getLength();
        String string2 = jarEntity.getSha1();
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            JarEntity jarEntity2 = list.get(i);
            if (jarEntity2.getLength() == l && jarEntity2.getSha1().equals(string2)) continue;
            throw new DifferentLibException("Jar mismatch! Fix your dependencies", this.getEntityDetails(string, list));
        }
    }

    private void checkSupportLibs(Map<String, List<JarEntity>> map, List<File> list) {
        List<JarEntity> list2 = map.get("android-support-v4.jar");
        List<JarEntity> list3 = map.get("android-support-v13.jar");
        if (list3 != null && list2 != null) {
            this.mOutStream.println("WARNING: Found both android-support-v4 and android-support-v13 in the dependency list.");
            this.mOutStream.println("Because v13 includes v4, using only v13.");
            list.remove(list2.get(0).getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, JarEntity> getCachedJarList() {
        HashMap<String, JarEntity> hashMap = new HashMap<String, JarEntity>();
        File file = new File(this.mOut, CACHE_FILENAME);
        if (!file.exists()) {
            return hashMap;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                Matcher matcher;
                if (string.charAt(0) == '#' || !(matcher = READ_PATTERN.matcher(string)).matches()) continue;
                String string2 = matcher.group(4);
                JarEntity jarEntity = new JarEntity(string2, Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)), matcher.group(3));
                hashMap.put(string2, jarEntity);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJarList(Map<String, List<JarEntity>> map) {
        File file = new File(this.mOut, CACHE_FILENAME);
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            outputStreamWriter.write("# cache for current jar dependecy. DO NOT EDIT.\n");
            outputStreamWriter.write("# format is <lastModified> <length> <SHA-1> <path>\n");
            outputStreamWriter.write("# Encoding is UTF-8\n");
            for (List<JarEntity> list : map.values()) {
                int n = 0;
                while (n < list.size()) {
                    JarEntity jarEntity = list.get(n);
                    if (jarEntity.hasSha1()) {
                        ++n;
                        continue;
                    }
                    list.remove(n);
                }
                if (list.size() <= 1) continue;
                for (JarEntity jarEntity : list) {
                    outputStreamWriter.write(String.format("%d %d %s %s\n", jarEntity.getLastModified(), jarEntity.getLength(), jarEntity.getSha1(), jarEntity.getFile().getAbsolutePath()));
                }
            }
        }
        catch (IOException iOException) {
            this.mOutStream.println("WARNING: unable to write jarlist cache file " + file.getAbsolutePath());
        }
        catch (Sha1Exception sha1Exception) {
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String[] getEntityDetails(String string, List<JarEntity> list) throws Sha1Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("Found %d versions of %s in the dependency list,", list.size(), string));
        arrayList.add("but not all the versions are identical (check is based on SHA-1 only at this time).");
        arrayList.add("All versions of the libraries must be the same at this time.");
        arrayList.add("Versions found are:");
        for (JarEntity jarEntity : list) {
            arrayList.add("Path: " + jarEntity.getFile().getAbsolutePath());
            arrayList.add("\tLength: " + jarEntity.getLength());
            arrayList.add("\tSHA-1: " + jarEntity.getSha1());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String getSha1(File file) throws Sha1Exception {
        byte[] byArray = sBuffer;
        synchronized (sBuffer) {
            try {
                int n;
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                FileInputStream fileInputStream = new FileInputStream(file);
                while ((n = fileInputStream.read(sBuffer)) > 0) {
                    messageDigest.update(sBuffer, 0, n);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return JarListSanitizer.byteArray2Hex(messageDigest.digest());
            }
            catch (Exception exception) {
                throw new Sha1Exception(file, (Throwable)exception);
            }
        }
    }

    private static String byteArray2Hex(byte[] byArray) {
        Formatter formatter = new Formatter();
        for (byte by : byArray) {
            formatter.format("%02x", by);
        }
        return formatter.toString();
    }

    public static final class Sha1Exception
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final File mJarFile;

        public Sha1Exception(File file, Throwable throwable) {
            super(throwable);
            this.mJarFile = file;
        }

        public File getJarFile() {
            return this.mJarFile;
        }
    }

    public static final class DifferentLibException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String[] mDetails;

        public DifferentLibException(String string, String[] stringArray) {
            super(string);
            this.mDetails = stringArray;
        }

        public String[] getDetails() {
            return this.mDetails;
        }
    }

    private static final class JarEntity {
        private final File mFile;
        private final long mLastModified;
        private long mLength;
        private String mSha1;

        private JarEntity(String string, long l, long l2, String string2) {
            this.mFile = new File(string);
            this.mLastModified = l;
            this.mLength = l2;
            this.mSha1 = string2;
        }

        private JarEntity(File file) {
            this.mFile = file;
            this.mLastModified = file.lastModified();
            this.mLength = file.length();
        }

        private boolean checkValidity() {
            if (this.mLastModified != this.mFile.lastModified()) {
                this.mLength = this.mFile.length();
                this.mSha1 = null;
                return true;
            }
            return false;
        }

        private File getFile() {
            return this.mFile;
        }

        private long getLastModified() {
            return this.mLastModified;
        }

        private long getLength() {
            return this.mLength;
        }

        private String getSha1() throws Sha1Exception {
            if (this.mSha1 == null) {
                this.mSha1 = JarListSanitizer.getSha1(this.mFile);
            }
            return this.mSha1;
        }

        private boolean hasSha1() {
            return this.mSha1 != null;
        }
    }
}

