/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.repo;

import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleInfo;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleInfoAdapter;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.OSGiManifestParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDescriptorWrapper {
    private BundleInfo bundleInfo;
    private DefaultModuleDescriptor md;
    private URI baseUri;
    private ExecutionEnvironmentProfileProvider profileProvider;

    public ModuleDescriptorWrapper(BundleInfo bundleInfo, URI baseUri, ExecutionEnvironmentProfileProvider profileProvider) {
        this.bundleInfo = bundleInfo;
        this.baseUri = baseUri;
        this.profileProvider = profileProvider;
    }

    public BundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultModuleDescriptor getModuleDescriptor() {
        if (this.md == null) {
            ModuleDescriptorWrapper moduleDescriptorWrapper = this;
            synchronized (moduleDescriptorWrapper) {
                if (this.md != null) {
                    return this.md;
                }
                this.md = BundleInfoAdapter.toModuleDescriptor(OSGiManifestParser.getInstance(), this.baseUri, this.bundleInfo, this.profileProvider);
            }
        }
        return this.md;
    }

    public static Collection<ModuleDescriptor> unwrap(Collection<ModuleDescriptorWrapper> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleDescriptor> unwrapped = new ArrayList<ModuleDescriptor>();
        for (ModuleDescriptorWrapper wrapped : collection) {
            unwrapped.add(wrapped.getModuleDescriptor());
        }
        return unwrapped;
    }

    public int hashCode() {
        return this.bundleInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ModuleDescriptorWrapper)) {
            return false;
        }
        return this.bundleInfo.equals(((ModuleDescriptorWrapper)obj).bundleInfo);
    }

    public String toString() {
        return this.getModuleDescriptor().toString();
    }
}

