/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.reloc.com.google.common.base.Strings;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.StubCode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class TwitterDigitsCodeBlockFactory {
    private static Content in(String contents) {
        return new Content(contents);
    }

    public static CodeChange getManualCodeDirections(String javaContents) {
        return new CodeChange("View Class", new StubCode(javaContents), Arrays.asList(TwitterDigitsCodeBlockFactory.in(javaContents).after("import android.app.Activity;").insert(TwitterDigitsCodeBlockFactory.getImports(TwitterDigitsCodeBlockFactory.getImportStrings())), TwitterDigitsCodeBlockFactory.in(javaContents).after("setContentView(R.layout.activity_main);").insert(TwitterDigitsCodeBlockFactory.getButtonCode("    "))));
    }

    public static CodeChange getManualLayoutDirections(String viewFileContents) {
        String layoutElementContent = "android:layout_height=\"wrap_content\" />";
        return new CodeChange("View XML", new StubCode(viewFileContents), Collections.singletonList(TwitterDigitsCodeBlockFactory.in(viewFileContents).after(layoutElementContent).insert(TwitterDigitsCodeBlockFactory.getView("\n        "))));
    }

    private static String getView(String tab) {
        Joiner joiner = Joiner.on(tab);
        return joiner.join("   <com.digits.sdk.android.DigitsAuthButton", "android:id=\"@+id/auth_button\"", "android:layout_width=\"wrap_content\"", "android:layout_height=\"wrap_content\" />");
    }

    private static Collection<String> getImportStrings() {
        return Arrays.asList("com.digits.sdk.android.AuthCallback", "com.digits.sdk.android.DigitsAuthButton", "com.digits.sdk.android.DigitsException", "com.digits.sdk.android.DigitsSession");
    }

    private static String getImports(Collection<String> importStrings) {
        StringBuilder builder = new StringBuilder();
        for (String importString : importStrings) {
            builder.append("import ");
            builder.append(importString);
            builder.append(";\n");
        }
        return builder.toString();
    }

    private static String getButtonCode(String tab) {
        return Strings.repeat(tab, 1) + "DigitsAuthButton digitsButton = (DigitsAuthButton) findViewById(R.id.auth_button);\n" + Strings.repeat(tab, 1) + "digitsButton.setCallback(new AuthCallback() {\n" + Strings.repeat(tab, 2) + "@Override\n" + Strings.repeat(tab, 2) + "public void success(DigitsSession session, String phoneNumber) {\n" + Strings.repeat(tab, 3) + "// Do something with the session and phone number\n" + Strings.repeat(tab, 2) + "}\n" + "\n" + Strings.repeat(tab, 2) + "@Override\n" + Strings.repeat(tab, 2) + "public void failure(DigitsException exception) {\n" + Strings.repeat(tab, 3) + "// Do something on failure\n" + Strings.repeat(tab, 2) + "}\n" + Strings.repeat(tab, 1) + "});\n";
    }

    private static class Content {
        public String content;

        public Content(String content) {
            this.content = content;
        }

        public Offset after(String elements) {
            return new Offset(this.content, elements);
        }

        public static class Offset {
            public String content;
            public String element;

            public Offset(String content, String element) {
                this.content = content;
                this.element = element;
            }

            private static int offsetOf(String element, String contents) {
                int offset = contents.indexOf(element);
                return offset == -1 ? -1 : offset + element.length() + 1;
            }

            public CodeChange.Insertion insert(String insertable) {
                CodeChange.Insertion insertion;
                int offset = Offset.offsetOf(this.element, this.content);
                if (offset == -1) {
                    DeveloperTools.logW("Couldn't find " + this.element, new IOException("Crashlytics failed to find item"));
                    insertion = new CodeChange.Insertion(0, insertable);
                } else {
                    insertion = new CodeChange.Insertion(offset, insertable);
                }
                return insertion;
            }
        }
    }
}

