/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.IOException;

public class StandardAndroidProject
implements AndroidProject {
    public static final String STANDARD_TYPE = "STANDARD_PROJECT";
    private final File _dataPath;
    private final ManifestData _manifestData;
    private final File _manifestFile;
    private final File _rootPath;
    private final File _propertyFilePath;
    private final File _resourceFile;
    private final File _assetsDir;
    private final String _projectType;
    private final String _buildSecret;
    private final String _apiKey;
    private final String _packageName;
    private final String _applicationName;
    private final File _launcherIcon;
    private final File _ndkOutDir;
    private final File _ndkLibsOutDir;
    private boolean _hasVerified = false;
    private final Optional<String> _twitterId;

    public static File getPropertiesLoc(File projLoc) {
        return new File(projLoc, "crashlytics.properties");
    }

    public static File getDataDirectory(File projectRootDirectory) {
        return new File(DeveloperTools.CRASHLYTICS_PROJECTS_ROOT, FileUtils.getIdentifier(projectRootDirectory));
    }

    public static File getStringResourceLoc(File projectResDirectory) {
        if (!projectResDirectory.isDirectory()) {
            throw new IllegalArgumentException("Invalid resource path: " + projectResDirectory.getAbsolutePath());
        }
        File valuesPath = new File(projectResDirectory, "values");
        File resourceFile = new File(valuesPath, "com_crashlytics_export_strings.xml");
        return resourceFile;
    }

    public StandardAndroidProject(File projectPath, File manifestFile, File projectDataPath, File propertyFilePath, File resourceFile, File assetsDir, ManifestData manifestData, String projectType, String buildSecret, String apiKey, String packageName, String applicationName, File launcherIcon, Optional<String> twitterId, File ndkOutDir, File ndkLibsOutDir) {
        this._manifestFile = manifestFile;
        this._manifestData = manifestData;
        this._dataPath = projectDataPath;
        this._rootPath = projectPath;
        this._propertyFilePath = propertyFilePath;
        this._resourceFile = resourceFile;
        this._assetsDir = assetsDir;
        this._projectType = projectType;
        this._buildSecret = buildSecret;
        this._apiKey = apiKey;
        this._packageName = packageName;
        this._applicationName = applicationName;
        this._launcherIcon = launcherIcon;
        this._twitterId = twitterId;
        this._ndkOutDir = ndkOutDir;
        this._ndkLibsOutDir = ndkLibsOutDir;
    }

    protected synchronized void createDataDir() throws IOException {
        FileUtils.verifyDirectory(this._dataPath);
    }

    @Override
    public File getManifestFile() {
        return this._manifestFile;
    }

    @Override
    public Optional<String> getTwitterId() {
        return this._twitterId;
    }

    @Override
    public ManifestData getManifestData() {
        return this._manifestData;
    }

    @Override
    public File getLauncherIcon() {
        return this._manifestData.getLauncherIcon();
    }

    @Override
    public File getDataDirectory() {
        if (!this._hasVerified) {
            try {
                FileUtils.verifyDirectory(this._dataPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._hasVerified = true;
        }
        return this._dataPath;
    }

    @Override
    public File getResourceFile() {
        return this._resourceFile;
    }

    @Override
    public File getRootPath() {
        return this._rootPath;
    }

    @Override
    public File getAssetsDir() {
        return this._assetsDir;
    }

    @Override
    public String getApiKey() {
        return this._apiKey;
    }

    @Override
    public File getPropertiesPath() {
        return this._propertyFilePath;
    }

    @Override
    public String getProjectType() {
        return this._projectType;
    }

    @Override
    public String getBuildSecret() {
        return this._buildSecret;
    }

    @Override
    public String getPackageName() {
        return this._packageName;
    }

    @Override
    public String getApplicationName() {
        return this._applicationName;
    }

    @Override
    public File getIcon() {
        return this._launcherIcon;
    }

    @Override
    public File getNdkOutDir() {
        return this._ndkOutDir;
    }

    @Override
    public File getNdkLibsOutDir() {
        return this._ndkLibsOutDir;
    }

    public String toString() {
        return "StandardAndroidProject{dataPath=" + this._dataPath + ", manifestFile=" + this._manifestFile + ", rootPath=" + this._rootPath + ", propertyFilePath=" + this._propertyFilePath + ", resourceFile=" + this._resourceFile + ", assetsDir=" + this._assetsDir + ", projectType='" + this._projectType + '\'' + ", buildSecret='" + this._buildSecret + '\'' + ", hasVerified=" + this._hasVerified + ", apiKey='" + this._apiKey + '\'' + ", packageName='" + this._packageName + '\'' + ", launcherIcon=" + this._launcherIcon + ", ndkOutDir=" + this._ndkOutDir + ", ndkLibsOutDir=" + this._ndkLibsOutDir + '}';
    }
}

