/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.codemapping.csym;

import com.crashlytics.tools.android.project.codemapping.csym.CSym;
import com.crashlytics.tools.android.project.codemapping.csym.CSymGenerator;
import com.crashlytics.tools.android.project.codemapping.csym.CSymIdStrategy;
import com.crashlytics.tools.utils.elf.EMachine;
import com.crashlytics.tools.utils.elf.ElfData;
import com.crashlytics.tools.utils.elf.ElfSymbol;
import java.io.File;
import java.io.IOException;

public class ElfCSymGenerator
implements CSymGenerator {
    private static final String CSYM_TYPE = "elf_symtab";
    private final CSymIdStrategy _idStrategy;

    public ElfCSymGenerator(CSymIdStrategy idStrategy) {
        this._idStrategy = idStrategy;
    }

    @Override
    public CSym generateCSymFromFile(File binFile) throws IOException {
        if (!binFile.isFile()) {
            throw new IllegalArgumentException("Invalid object file: " + binFile);
        }
        String uuid = this._idStrategy.createCSymIdForFile(binFile);
        ElfData elfData = ElfData.parse(binFile);
        String arch = EMachine.getMachineName(elfData.getElfFileHeader().eMachine);
        if (arch.equalsIgnoreCase("arm") && elfData.getArmVersion().isPresent()) {
            arch = arch + String.format("v%s", elfData.getArmVersion().get());
        }
        CSym.Builder builder = new CSym.Builder(uuid, CSYM_TYPE, arch);
        for (ElfSymbol symbol : elfData.getElfSymbols()) {
            if (!ElfCSymGenerator.isNecessarySymbol(symbol)) continue;
            builder.addRange(symbol.stValue, symbol.stSize, symbol.stNameString);
        }
        return builder.build();
    }

    private static boolean isNecessarySymbol(ElfSymbol symbol) {
        return (symbol.stInfo & 0xF) == 2 && symbol.stSize != 0L;
    }
}

