/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.library;

import com.crashlytics.reloc.com.android.sdklib.xml.AndroidManifestParser;
import com.crashlytics.reloc.com.android.sdklib.xml.ManifestData;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.library.AndroidLibrary;
import com.crashlytics.tools.android.project.library.AndroidLibraryProjectInfo;
import com.crashlytics.tools.utils.PropertiesUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class AndroidLibraryProject {
    public static final String KIT_INFO_FILE_NAME = "kit-version.properties";
    public static final String PROJECT_PROPERTIES_FILE = "project.properties";
    public static final String KITS_FOLDER = "kit-libs";
    private final File _projectDir;
    private final File _propertiesFile;
    private final File _classesFile;
    private final File _libsfolder;
    private final File _srcFolder;
    private final File _androidManifestFile;

    public AndroidLibraryProject(File projectDir, File propertiesFile, File classesFile, File libsFolder, File srcFolder, File androidManifestFile) {
        this._projectDir = projectDir;
        this._propertiesFile = propertiesFile;
        this._classesFile = classesFile;
        this._libsfolder = libsFolder;
        this._srcFolder = srcFolder;
        this._androidManifestFile = androidManifestFile;
    }

    public File getProjectDir() {
        return this._projectDir;
    }

    public File getPropertiesFile() {
        return this._propertiesFile;
    }

    public File getClassesFile() {
        return this._classesFile;
    }

    public File getLibsfolder() {
        return this._libsfolder;
    }

    public File getSrcFolder() {
        return this._srcFolder;
    }

    public int getTargetPlatform() throws IOException {
        int n;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this._androidManifestFile);
            ManifestData data = AndroidManifestParser.parse(inputStream);
            n = data.getTargetSdkVersion();
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return n;
    }

    public static Optional<AndroidLibraryProjectInfo> getKitInfo(File kitInfoFile) {
        try {
            if (!kitInfoFile.exists()) {
                return Optional.absent();
            }
            Properties properties = PropertiesUtils.read(kitInfoFile);
            return Optional.of(new AndroidLibraryProjectInfo(properties.getProperty("name"), properties.getProperty("version"), Long.parseLong(properties.getProperty("timestamp"))));
        }
        catch (Exception e) {
            DeveloperTools.logW("Issue loading properties file", e);
            return Optional.absent();
        }
    }

    public static void writeKitInfo(File kitInfoFile, AndroidLibrary library) throws IOException {
        Properties kitInfo = new Properties();
        kitInfo.setProperty("name", library.name);
        kitInfo.setProperty("version", library.version);
        kitInfo.setProperty("timestamp", Long.toString(library.timestamp));
        PropertiesUtils.write(kitInfoFile, kitInfo, "This file describes the version of the kit. Do not modify.");
    }
}

