/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.api.AppRelease;
import com.crashlytics.reloc.com.google.common.base.Predicate;
import com.crashlytics.reloc.com.google.common.collect.Iterators;
import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ApkUtils {
    private static final String TAG = "[ApkUtils] ";
    private static final Pattern SIGNATURE_FILE_ENTRY_PATTERN = Pattern.compile("\\AMETA-INF/.+\\.SF\\z", 2);
    public static final boolean DEBUG_LOGGING = false;

    public static final boolean isSigned(File apkFile) throws IOException {
        return Iterators.any(Iterators.forEnumeration(new JarFile(apkFile).entries()), new Predicate<JarEntry>(){

            @Override
            public boolean apply(JarEntry input) {
                return SIGNATURE_FILE_ENTRY_PATTERN.matcher(input.getName()).matches();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AppRelease readBuildPropertiesFromApk(File apkFile) {
        ZipInputStream zin = null;
        Properties buildProperties = new Properties();
        try {
            ZipEntry ze;
            zin = new ZipInputStream(new FileInputStream(apkFile));
            while ((ze = zin.getNextEntry()) != null) {
                String name;
                if (ze.isDirectory() || !"assets/crashlytics-build.properties".equals(name = ze.getName())) continue;
                buildProperties.load(zin);
                break;
            }
        }
        catch (Exception e) {
            try {
                ApkUtils.logE("Crashlytics could not find assets/crashlytics-build.properties in the APK.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zin);
                throw throwable;
            }
            IOUtils.closeQuietly(zin);
        }
        IOUtils.closeQuietly(zin);
        if (!buildProperties.isEmpty()) {
            String appName = buildProperties.getProperty("app_name");
            String packageName = buildProperties.getProperty("package_name");
            String instanceId = buildProperties.getProperty("build_id");
            String displayVersion = buildProperties.getProperty("version_name");
            String buildVersion = buildProperties.getProperty("version_code");
            return new AppRelease(appName, packageName, instanceId, displayVersion, buildVersion);
        }
        return null;
    }

    public static void log(String s) {
    }

    public static void logW(String s, Throwable t) {
        DeveloperTools.logW(TAG + s, t);
    }

    public static void logE(String s, Throwable t) {
        DeveloperTools.logE(TAG + s, t);
    }
}

